/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindowStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.framework.PrintInfo;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPrintWindow
extends HttpServlet {
    private static final long serialVersionUID = 9003001336699200370L;
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_RECORD = 500;
    private final CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrintWindow.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Print Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        int tableId = ws.curTab.getAD_Table_ID();
        Query query = ws.getCurTab().getQuery().deepCopy();
        query.addRestriction(ws.getCurTab().getWhereClause());
        String queryColumn = ws.curTab.getLinkColumnName();
        String infoName = null;
        String infoDisplay = null;
        for (int i2 = 0; i2 < ws.curTab.getFieldCount(); ++i2) {
            GridField field = ws.curTab.getField(i2);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
        }
        if (queryColumn.length() != 0) {
            String value = ws.ctx.getContext(ws.mWindow.getWindowNo(), ws.curTab.getTabNo(), queryColumn);
            query.addRestriction(queryColumn, "=", value, infoName, infoDisplay);
        }
        MPrintFormat printFormat = null;
        if (request.getParameter("PrintFormat").equals("")) {
            printFormat = MPrintFormat.createFromTable(ws.ctx, tableId);
        } else {
            int pfId = new Integer(request.getParameter("PrintFormat"));
            printFormat = MPrintFormat.get(wsc.ctx, pfId, false);
        }
        printFormat.setLanguage(wsc.language);
        printFormat.setTranslationLanguage(wsc.language);
        PrintInfo printInfo = new PrintInfo(printFormat.getName(), printFormat.getAD_Table_ID(), ws.curTab.getRecord_ID());
        printInfo.setDescription(query.getInfo());
        ReportEngine re = new ReportEngine(wsc.ctx, printFormat, query, printInfo);
        if (re.getRowCount() > 500) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "Can not create report for over 500 records!!!"));
        } else {
            boolean result = WPrintWindow.makeDownloadFile(re, request, response, wsc.language);
            if (!result) {
                WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "Can not create report !!!"));
            }
        }
        re = null;
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean makeDownloadFile(ReportEngine reportEngine, HttpServletRequest request, HttpServletResponse response, Language language) {
        boolean result;
        block14: {
            result = true;
            try {
                String fileAction;
                String string = fileAction = "true".equals(WebUtil.getParameter(request, "SaveFile")) ? "attachment" : "inline";
                if (request.getParameter("FileFormat").equals("ps")) {
                    int len;
                    response.setContentType("application/postscript");
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "ps");
                    response.setHeader("Content-Description", "File download for PS.");
                    File f = File.createTempFile("ReportEngine", ".ps");
                    reportEngine.createPS(f);
                    FileInputStream fis = new FileInputStream(f);
                    ServletOutputStream ouputStream = response.getOutputStream();
                    byte[] buf = new byte[1024];
                    while ((len = fis.read(buf)) != -1) {
                        ouputStream.write(buf, 0, len);
                    }
                    fis.close();
                    f.delete();
                    ouputStream.flush();
                    ouputStream.close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("xml")) {
                    response.setContentType("application/xml;charset=UTF8");
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "xml");
                    response.setHeader("Content-Description", "File download for XML.");
                    PrintWriter writer = response.getWriter();
                    reportEngine.createXML(writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("pdf")) {
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "pdf");
                    response.setHeader("Content-Description", "File download for PDF.");
                    ServletOutputStream ouputStream = response.getOutputStream();
                    ouputStream.write(reportEngine.createPDFData());
                    ouputStream.flush();
                    ouputStream.close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("html")) {
                    response.setContentType("text/html");
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "html");
                    response.setHeader("Content-Description", "File download for HTML.");
                    PrintWriter writer = response.getWriter();
                    reportEngine.createHTML(writer, false, language);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("txt")) {
                    response.setContentType("text/plain;charset=" + WPrintWindow.getCharSet(request.getLocale().getLanguage()));
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "txt");
                    response.setHeader("Content-Description", "File download for TXT.");
                    PrintWriter writer = response.getWriter();
                    reportEngine.createCSV(writer, '\t', language);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("ssv")) {
                    response.setContentType("text/plain;charset=" + WPrintWindow.getCharSet(request.getLocale().getLanguage()));
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "ssv");
                    response.setHeader("Content-Description", "File download for SSV.");
                    PrintWriter writer = response.getWriter();
                    reportEngine.createCSV(writer, ';', language);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    break block14;
                }
                if (request.getParameter("FileFormat").equals("csv")) {
                    response.setHeader("Content-Disposition", fileAction + "; filename=" + reportEngine.getPrintFormat().get_ID() + "." + "csv");
                    response.setContentType("text/csv; charset=" + WPrintWindow.getCharSet(request.getLocale().getLanguage()));
                    File f = File.createTempFile("ReportEngine", ".csv");
                    f.deleteOnExit();
                    reportEngine.createCSV(f, ',', reportEngine.getPrintFormat().getLanguage());
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), WPrintWindow.getCharSet(request.getLocale().getLanguage())));
                    BufferedReader input2 = null;
                    try {
                        input2 = new BufferedReader(new FileReader(f));
                        String line = null;
                        while ((line = input2.readLine()) != null) {
                            writer.write(line);
                            writer.write(Env.NL);
                        }
                    }
                    finally {
                        input2.close();
                    }
                    writer.close();
                    f.delete();
                    break block14;
                }
                result = false;
            }
            catch (IOException e) {
                result = false;
            }
        }
        return result;
    }

    public static final String getCharSet(String local) {
        String charset = "UTF8";
        charset = local.equals("ar") ? "ISO-8859-6" : (local.equals("be") ? "ISO-8859-5" : (local.equals("bg") ? "ISO-8859-5" : (local.equals("ca") ? "ISO-8859-1" : (local.equals("cs") ? "ISO-8859-2" : (local.equals("da") ? "ISO-8859-1" : (local.equals("de") ? "ISO-8859-1" : (local.equals("el") ? "ISO-8859-7" : (local.equals("en") ? "ISO-8859-1" : (local.equals("es") ? "ISO-8859-1" : (local.equals("et") ? "ISO-8859-1" : (local.equals("fi") ? "ISO-8859-1" : (local.equals("fr") ? "ISO-8859-1" : (local.equals("hr") ? "ISO-8859-2" : (local.equals("hu") ? "ISO-8859-2" : (local.equals("is") ? "ISO-8859-1" : (local.equals("it") ? "ISO-8859-1" : (local.equals("iw") ? "ISO-8859-8" : (local.equals("ja") ? "Windows-31J" : (local.equals("ko") ? "EUC-KR" : (local.equals("lt") ? "ISO-8859-2" : (local.equals("lv") ? "ISO-8859-2" : (local.equals("mk") ? "ISO-8859-5" : (local.equals("nl") ? "ISO-8859-1" : (local.equals("no") ? "ISO-8859-1" : (local.equals("pl") ? "ISO-8859-2" : (local.equals("pt") ? "ISO-8859-1" : (local.equals("ro") ? "ISO-8859-2" : (local.equals("ru") ? "ISO-8859-5" : (local.equals("sh") ? "ISO-8859-5" : (local.equals("sk") ? "ISO-8859-2" : (local.equals("sl") ? "ISO-8859-2" : (local.equals("sq") ? "ISO-8859-2" : (local.equals("sr") ? "ISO-8859-5" : (local.equals("sv") ? "ISO-8859-1" : (local.equals("tr") ? "ISO-8859-9" : (local.equals("uk") ? "ISO-8859-5" : (local.equals("zh") ? "GB2312" : (local.equals("zh_TW") ? "Big5" : "UTF8"))))))))))))))))))))))))))))))))))))));
        return charset;
    }
}

