/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WPrintWindow;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.framework.PrintInfo;
import org.compiere.framework.Query;
import org.compiere.model.MPInstance;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPrintReport
extends HttpServlet {
    private static final long serialVersionUID = 9003001336699200370L;
    private static final int MAX_RECORD = 500;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private ReportEngine re;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrintWindow.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Print Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        Language oldLogin = Language.getLoginLanguage();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        Language.setLoginLanguage(wsc.language);
        MProcess process = MProcess.get(wsc.ctx, wsc.ctx.getContextAsInt("AD_Process_ID"));
        int pInstanceId = wsc.ctx.getContextAsInt("AD_PInstance_ID");
        MPInstance pInstance = new MPInstance(wsc.ctx, pInstanceId, null);
        ProcessInfo processInfo = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        processInfo.setAD_User_ID(wsc.ctx.getAD_User_ID());
        processInfo.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(pInstance.getRecord_ID());
        if (ws != null) {
            processInfo.setRecord_ID(ws.curTab.getRecord_ID());
        }
        if (processInfo.getAD_Process_ID() == 110) {
            this.re = ReportEngine.get(wsc.ctx, 0, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 116) {
            this.re = ReportEngine.get(wsc.ctx, 2, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 117) {
            this.re = ReportEngine.get(wsc.ctx, 1, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 217) {
            this.re = ReportEngine.get(wsc.ctx, 3, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 276) {
            this.re = ReportEngine.get(wsc.ctx, 4, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 313) {
            int paySelectionCheckId = 0;
            MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment(wsc.ctx, processInfo.getRecord_ID(), null);
            if (psc != null) {
                paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
            } else {
                psc = MPaySelectionCheck.createForPayment(wsc.ctx, processInfo.getRecord_ID(), null);
                if (psc != null) {
                    paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
                }
            }
            this.re = ReportEngine.get(wsc.ctx, 6, paySelectionCheckId);
        } else if (processInfo.getAD_Process_ID() == 159) {
            this.re = ReportEngine.get(wsc.ctx, 7, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 202 || processInfo.getAD_Process_ID() == 204) {
            String tableName = processInfo.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
            Query query = Query.get(wsc.ctx, processInfo.getAD_PInstance_ID(), tableName);
            MPrintFormat format = (MPrintFormat)processInfo.getTransientObject();
            if (format == null) {
                format = (MPrintFormat)processInfo.getSerializableObject();
            }
            if (format == null) {
                this.log.log(Level.SEVERE, "startFinReport - No PrintFormat");
                return;
            }
            PrintInfo info = new PrintInfo(processInfo);
            this.re = new ReportEngine(wsc.ctx, format, query, info);
        } else {
            this.re = ReportEngine.get(wsc.ctx, processInfo);
        }
        int pfId = WebUtil.getParameterAsInt(request, "PrintFormat");
        MPrintFormat printFormat = MPrintFormat.get(wsc.ctx, pfId, false);
        printFormat.setLanguage(this.re.getPrintFormat().getLanguage());
        printFormat.setTranslationLanguage(this.re.getPrintFormat().getLanguage());
        this.re = new ReportEngine(wsc.ctx, printFormat, this.re.getQuery(), this.re.getPrintInfo());
        this.re.setPrintData(this.re.getPrintData());
        if (this.re.getRowCount() > 500) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "ParameterMissing"));
        } else {
            boolean result = WPrintWindow.makeDownloadFile(this.re, request, response, wsc.language);
            if (!result) {
                WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "Can not create report !!!"));
            }
        }
        this.re = null;
        Language.setLoginLanguage(oldLogin);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }
}

