/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WJasperPrint
extends HttpServlet {
    private static final long serialVersionUID = -4790517244763398554L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WJasperPrint.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Jasper Print Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int i2;
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        int pInstanceId = WebUtil.getParameterAsInt(request, "AD_PInstance_ID");
        MPInstance pInstance = new MPInstance(wsc.ctx, pInstanceId, null);
        String title = Msg.translate(wsc.ctx, "JasperReportViewer");
        WebDoc doc = WebDoc.createWindow(title);
        doc.getBody().addElement((Element)new script("top.document.title='" + title + "';"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        td center = doc.addWindowCenter(false);
        form myForm = new form("WJasperPrint").setName("WJasperPrint");
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WJasperPrint");
        tr line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "AD_PrintFormat_ID")).setAlign("right"));
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (pInstanceId > 0) {
            MPInstancePara[] params = pInstance.getParameters();
            for (i2 = 0; i2 < params.length; ++i2) {
                if (!"AD_Jasperformat_ID".equals(params[i2].getParameterName())) continue;
                ids.add(params[i2].getP_Number().toString());
                names.add(params[i2].getInfo());
            }
        } else {
            int tableId = ws.curTab.getAD_Table_ID();
            String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT AD_JasperFormat_ID, Name, AD_Client_ID FROM AD_JasperFormat WHERE AD_Table_ID=? AND IsActive='Y' ORDER BY AD_Client_ID DESC, IsDefault DESC, Name", null, false, false);
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, tableId);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                    names.add(rs.getString(2));
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        option[] options = new option[ids.size()];
        for (i2 = 0; i2 < ids.size(); ++i2) {
            options[i2] = new option((String)ids.get(i2)).addElement((String)names.get(i2));
        }
        line.addElement((Element)new td().addElement(new select("PrintFormat", options).setID("PrintFormat")));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "Export")).setAlign("right"));
        options = new option[3];
        options[0] = new option("pdf").addElement(Msg.getMsg(wsc.ctx, "FilePDF"));
        options[0].setSelected(true);
        options[1] = new option("html").addElement(Msg.getMsg(wsc.ctx, "FileHTML"));
        options[2] = new option("xls").addElement(Msg.getMsg(wsc.ctx, "FileXLS"));
        line.addElement((Element)new td().addElement(new select("FileFormat", options).setID("FileFormat")));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(WebEnv.NBSP).setColSpan(2));
        myTable.addElement((Element)line);
        line = new tr();
        input bt = new input("button", "Export", Msg.translate(wsc.ctx, "Start"));
        StringBuffer sb = new StringBuffer();
        sb.append("openPrintWindow('/compiere/ampiere/WJasperReport");
        sb.append("?PrintFormat='+document.WJasperPrint.PrintFormat.value+'");
        sb.append("&FileFormat='+document.WJasperPrint.FileFormat.value+'");
        if (pInstanceId > 0) {
            sb.append("&AD_PInstance_ID=" + pInstanceId);
        }
        sb.append("&PrintFormatName='+document.WJasperPrint.PrintFormat.options[document.WJasperPrint.PrintFormat.selectedIndex].text");
        sb.append(",'' );");
        bt.setOnClick(sb.toString());
        line.addElement((Element)new td(null, "center", "middle", false, (Element)bt).setColSpan(2));
        myTable.addElement((Element)line);
        myForm.addElement((Element)myTable);
        center.addElement((Element)myForm);
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }
}

