/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WFindAdvanced;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WFind
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static String SELECTED_QUERY_ID = "selectedQueryId";
    private String ALL = "All";
    private String YEAR = "Year";
    private String MONTH = "Month";
    private String WEEK = "Week";
    private String DAY = "Day";
    private static String FCREATED = "FCreated";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createFindPage(request);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String m_created;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        Query query = new Query(ws.curTab.getTableName());
        GridField[] findFields = GridField.createFields(ws.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
        int onlyCurrentDays = 0;
        boolean created = false;
        if ((request.getParameter(this.ALL) != null || request.getParameter(this.YEAR) != null || request.getParameter(this.MONTH) != null || request.getParameter(this.WEEK) != null || request.getParameter(this.DAY) != null || request.getParameter(SELECTED_QUERY_ID) != null) && "on".equals(m_created = request.getParameter(FCREATED))) {
            created = true;
        }
        if (request.getParameter(this.ALL) != null) {
            onlyCurrentDays = 0;
        } else if (request.getParameter(this.YEAR) != null) {
            onlyCurrentDays = 356;
        } else if (request.getParameter(this.MONTH) != null) {
            onlyCurrentDays = 31;
        } else if (request.getParameter(this.WEEK) != null) {
            onlyCurrentDays = 7;
        } else if (request.getParameter(this.DAY) != null) {
            onlyCurrentDays = 1;
        } else if (!StringUtils.isEmpty(request.getParameter(SELECTED_QUERY_ID))) {
            String savedQueryId = request.getParameter(SELECTED_QUERY_ID);
            query.addRestriction(savedQueryId);
        } else {
            for (int i2 = 0; i2 < findFields.length; ++i2) {
                GridField field = findFields[i2];
                String columnName = field.getColumnName();
                if (columnName.equals("Value")) {
                    String value = WebUtil.getParameter(request, columnName).toUpperCase();
                    if (value.equals("") || value.equals("%")) continue;
                    if (!value.endsWith("%")) {
                        value = value + "%";
                    }
                    query.addRestriction("UPPER(Value)", " LIKE ", value);
                    continue;
                }
                if (columnName.equals("Name")) {
                    String value = WebUtil.getParameter(request, columnName).toUpperCase();
                    if (value.equals("") || value.equals("%")) continue;
                    if (!value.endsWith("%")) {
                        value = value + "%";
                    }
                    query.addRestriction("UPPER(Name)", " LIKE ", value);
                    continue;
                }
                if (columnName.equals("DocumentNo")) {
                    String value = WebUtil.getParameter(request, columnName).toUpperCase();
                    if (value.equals("") || value.equals("%")) continue;
                    if (!value.endsWith("%")) {
                        value = value + "%";
                    }
                    query.addRestriction("UPPER(DocumentNo)", " LIKE ", value);
                    continue;
                }
                if (columnName.equals("Description")) {
                    String value = WebUtil.getParameter(request, columnName).toUpperCase();
                    if (value.equals("") || value.equals("%")) continue;
                    if (!value.endsWith("%")) {
                        value = value + "%";
                    }
                    query.addRestriction("UPPER(Description)", " LIKE ", value);
                    continue;
                }
                if (!field.isSelectionColumn()) continue;
                boolean notSQL = columnName.equals(field.getColumnSQL(false));
                String value = WebUtil.getParameter(request, columnName);
                if (!notSQL || value == null || value.toString().length() <= 0) continue;
                this.log.fine(columnName + "=" + value);
                if (value.toString().indexOf("%") != -1) {
                    query.addRestriction(columnName, " LIKE ", value);
                    continue;
                }
                query.addRestriction(columnName, "=", value, columnName, value);
            }
        }
        if (onlyCurrentDays > 0) {
            boolean showNotProcessed;
            StringBuffer where = new StringBuffer("");
            if (where.length() > 0) {
                where.append(" AND ");
            }
            if (showNotProcessed = true) {
                where.append("(Processed='N' OR ");
            }
            if (created) {
                where.append("Created>=");
            } else {
                where.append("Updated>=");
            }
            where.append("addDays(SysDate, -").append(onlyCurrentDays).append(")");
            if (showNotProcessed) {
                where.append(")");
            }
            query.addRestriction(where.toString());
        }
        if (query != null && query.isActive()) {
            ws.curTab.setQuery(query);
        } else {
            ws.curTab.setQuery(null);
        }
        ws.curTab.query(0);
        WebDoc doc = WebDoc.createWindow(ws.curTab.getTableName());
        doc.getBody().addElement(ws.curTab.getQuery().getWhereClause());
        StringBuffer sb = new StringBuffer();
        sb.append("<script language='javascript'>");
        sb.append("   opener.document.WForm.PCommand.value='Refresh';");
        sb.append("   opener.document.WForm.submit();");
        sb.append("   window.close();");
        sb.append("</script>");
        doc.getBody().addElement(sb.toString());
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createFindPage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = WebDoc.createWindow(ws.mWindow.getName() + " - " + ws.curTab.getName());
        this.addTabFindAdvanced(request, doc);
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        form myForm = new form(request.getRequestURI());
        myForm.setID("WFind");
        table myTable = new table();
        myTable.setAlign("CENTER");
        div divBody = (div)new div().setID("body");
        divBody.addElement((Element)myTable);
        GridField[] findFields = GridField.createFields(ws.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
        for (int i2 = 0; i2 < findFields.length; ++i2) {
            tr myTr = new tr();
            GridField field = findFields[i2];
            String columnName = field.getColumnName();
            if (columnName.equals("Value")) {
                this.addField(wsc, myTr, field, field.getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (columnName.equals("Name")) {
                this.addField(wsc, myTr, field, field.getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                this.addField(wsc, myTr, field, field.getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (columnName.equals("Description")) {
                this.addField(wsc, myTr, field, field.getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (!field.isSelectionColumn()) continue;
            this.addField(wsc, myTr, field, field.getDefault(), false, false);
            myTable.addElement((Element)myTr);
        }
        tr myTr = new tr((Element)new td("&nbsp;").setColSpan(2));
        myTable.addElement((Element)myTr);
        td buttonTd = new td().addElement((Element)new input("reset", "Reset", Msg.translate(wsc.ctx, "Reset")));
        buttonTd.addElement((Element)new input("submit", "Submit", Msg.translate(wsc.ctx, "Start")));
        buttonTd.setColSpan(2);
        buttonTd.setAlign("center");
        myTable.addElement((Element)new tr().addElement((Element)buttonTd));
        table historyTable = WFind.getHistoryTable(request);
        divBody.addElement((Element)historyTable);
        myForm.addElement((Element)divBody);
        doc.getBody().addElement((Element)myForm);
        return doc;
    }

    public static table getHistoryTable(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        table historyTable = new table();
        historyTable.setStyle("margin-top: 20px;");
        historyTable.setAlign("CENTER");
        tr titleTr = new tr();
        td titleTd = new td().setColSpan(2);
        titleTd.addElement(Msg.getMsg(wsc.ctx, "VHistory"));
        titleTr.addElement((Element)titleTd);
        historyTable.addElement((Element)titleTr);
        td hrTd = new td().setColSpan(2);
        hrTd.addElement((Element)new hr());
        historyTable.addElement((Element)new tr().addElement((Element)hrTd));
        tr historyTr = new tr();
        td historyTd = new td().setColSpan(2);
        historyTd.addElement(Msg.getMsg(wsc.ctx, "Created"));
        input bShowAll = new input("submit", "All", Msg.getMsg(wsc.ctx, "All"));
        input bShowYear = new input("submit", "Year", Msg.getMsg(wsc.ctx, "Year"));
        input bShowMonth = new input("submit", "Month", Msg.getMsg(wsc.ctx, "Month"));
        input bShowWeek = new input("submit", "Week", Msg.getMsg(wsc.ctx, "Week"));
        input bShowDay = new input("submit", "Day", Msg.getMsg(wsc.ctx, "Day"));
        int BUTTON_SIZE = 40;
        bShowAll.setStyle("width:" + BUTTON_SIZE + "px;");
        bShowYear.setStyle("width:" + BUTTON_SIZE + "px;");
        bShowMonth.setStyle("width:" + BUTTON_SIZE + "px;");
        bShowWeek.setStyle("width:" + BUTTON_SIZE + "px;");
        bShowDay.setStyle("width:" + BUTTON_SIZE + "px;");
        historyTd.addElement((Element)bShowAll).addElement((Element)bShowYear).addElement((Element)bShowMonth).addElement((Element)bShowWeek).addElement((Element)bShowDay);
        input cbCreated = new input("checkbox", FCREATED, "on");
        cbCreated.setChecked(true);
        cbCreated.addElement(Msg.getMsg(wsc.ctx, "Created"));
        historyTd.addElement((Element)cbCreated);
        select sel = new select(SELECTED_QUERY_ID, WFindAdvanced.getSavedQueryOptions(request, Msg.getMsg(wsc.ctx, "SelectSavedQuery")));
        sel.setOnChange("this.form.submit();");
        historyTd.addElement((Element)sel);
        historyTr.addElement((Element)historyTd);
        historyTable.addElement((Element)historyTr);
        return historyTable;
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly) {
        String columnName = field.getColumnName();
        Object data = oData;
        boolean error = field.isErrorValue();
        if (error) {
            this.log.log(Level.SEVERE, oData.toString());
            data = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        int display_length = field.getDisplayLength();
        display_length = display_length > 500 ? 550 : 200;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), display_length, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        line.addElement((Element)wField.getLabel());
        line.addElement((Element)wField.getField(field.getLookup(), data, field.getAD_Column_ID()));
    }

    void addTabFindAdvanced(HttpServletRequest request, WebDoc doc) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String msgFind = Msg.getMsg(ws.ctx, "Find");
        String msgFindAdvanced = Msg.getMsg(ws.ctx, "Advanced");
        div tabbar = (div)new div().setID("menu_tab");
        ul tabTable = new ul();
        boolean currentTab = false;
        for (int i2 = 0; i2 < 2; ++i2) {
            String tabMouseOver = "";
            String tabMouseOut = "";
            String tabLeftId = "tabLeftId_" + Integer.toString(i2);
            String tabRightId = "tabRightId_" + Integer.toString(i2);
            String tabLeftClass = "tabLeft";
            String tabRightClass = "tabRight";
            span big = i2 == 0 ? new span(msgFind) : new span(msgFindAdvanced);
            if (0 == i2) {
                big.setClass("tabSelected");
                tabLeftClass = tabLeftClass + "Sel";
                tabRightClass = tabRightClass + "Sel";
                currentTab = true;
            } else {
                big.setClass("tab");
                big.setOnClick("window.location.href = 'WFindAdvanced?windowId=" + ws.getCurTab().getAD_Window_ID() + "&windowNo=" + ws.getCurTab().getWindowNo() + "'");
                tabMouseOver = "tabMouseOver('" + tabLeftId + "', '" + tabRightId + "');";
                tabMouseOut = "tabMouseOut('" + tabLeftId + "', '" + tabRightId + "');";
            }
            if (i2 != 0) {
                currentTab = false;
            }
            span tabTdLeft = new span(WebEnv.NBSP);
            tabTdLeft.setClass(tabLeftClass);
            li tabTdRight = (li)new li().setClass(tabRightClass);
            tabTdLeft.setID(tabLeftId);
            tabTdRight.setID(tabRightId);
            tabMouseOver = i2 == 0 ? tabMouseOver + "status='" + msgFind + "';return true;" : tabMouseOver + "status='" + msgFindAdvanced + "';return true;";
            if (tabMouseOver != null && !"".equals(tabMouseOver)) {
                big.setOnMouseOver(tabMouseOver);
            }
            if (tabMouseOut != null && !"".equals(tabMouseOut)) {
                tabMouseOut = tabMouseOut + "status='" + ws.curTab.getName() + "';return true;";
                big.setOnMouseOut(tabMouseOut);
            }
            tabTable.addElement((Element)tabTdRight);
            tabTdRight.addElement((Element)tabTdLeft);
            tabTdRight.addElement((Element)big);
            tabTdRight.setStyle("");
        }
        tabbar.addElement((Element)tabTable);
        doc.getBody().addElement((Element)tabbar);
    }
}

