/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.p;
import org.compiere.util.CLogger;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;

public final class WFilter
implements Filter {
    private FilterConfig m_filterConfig = null;
    private boolean m_timing = false;
    private static CLogger log = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_filterConfig = filterConfig;
        WebEnv.initWeb(filterConfig.getServletContext(), null);
        if (log == null) {
            log = CLogger.getCLogger(WFilter.class);
        }
        log.info(filterConfig.getFilterName());
        Enumeration en = filterConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = filterConfig.getInitParameter(name);
            log.config(name + "=" + value);
            if (!name.equals("Timing") || !value.equals("Y")) continue;
            this.m_timing = true;
        }
    }

    public void destroy() {
        this.m_filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = "";
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            uri = req.getRequestURI();
        }
        boolean check = true;
        if (!uri.startsWith("/compiere/ampiere") || uri.endsWith(".gif") || uri.endsWith(".jpg") || uri.endsWith(".png") || uri.endsWith(".html") || uri.endsWith(".css") || uri.endsWith(".js")) {
            check = false;
        }
        boolean pass = true;
        StringBuffer sb = new StringBuffer("| Parameters");
        if (check) {
            try {
                String enc = request.getCharacterEncoding();
                if (enc == null) {
                    request.setCharacterEncoding("UTF-8");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Set CharacterEndocung=UTF-8", e);
            }
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                sb.append(" - ").append(name).append("=").append(request.getParameter(name));
            }
            if (uri.endsWith("WWindowStatus")) {
                pass = false;
            }
        }
        if (pass && check) {
            log.info("Start " + uri + sb.toString());
        }
        long myTime = 0L;
        if (pass && check && this.m_timing) {
            myTime = System.currentTimeMillis();
        }
        if (pass) {
            chain.doFilter(request, response);
        } else {
            log.warning("Rejected " + uri);
            String msg = "Error: Access Rejected";
            WebDoc doc = WebDoc.create(msg);
            body b = doc.getBody();
            b.addElement((Element)new p(uri, "center"));
            response.setContentType("text/html");
            PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
            doc.output(out);
            out.close();
        }
        if (check && pass) {
            if (this.m_timing) {
                myTime = System.currentTimeMillis() - myTime;
            }
            log.info("End   " + uri + "| " + (this.m_timing ? String.valueOf(myTime) : null));
        }
    }

    public String toString() {
        if (this.m_filterConfig == null) {
            return "WFilter[]";
        }
        StringBuffer sb = new StringBuffer("WFilter[");
        sb.append(this.m_filterConfig);
        sb.append("]");
        return sb.toString();
    }
}

