/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WAbout;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WEMail
extends HttpServlet {
    private static final long serialVersionUID = -4841905070456127217L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final int WINDOW_WIDTH = 600;
    public static final int WINDOW_HEIGHT = 500;
    private static final int INPUT_LENGTH = 535;
    private static final String FROM = "from";
    private static final String TO = "AD_User_ID";
    private static final String TO_NAME = "emailAddress";
    private static final String SUBJECT = "subject";
    private static final String BODY = "body";
    private static final String FORM_NAME = "WForm";
    public static final String EMAIL_TYPE = "emailType";
    public static final String EMAIL_TYPE_TRACE = "emailTypeTrace";
    public static final String EMAIL_TYPE_SUPPORT = "emailTypeSupport";
    public static final String POST_TYPE = "postType";
    public static final String POST_TYPE_GET_ADDRESS = "postTypeGetAddress";
    public static final String POST_TYPE_SEND_EMAIL = "postTypeSendEMail";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.log.info("WEMail.init");
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WEMail.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("WEMail.doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = WebDoc.createPopup(Msg.translate(wsc.ctx, "EMail"));
        doc.getHead().addElement((Element)new script((Element)null, "js/email.js"));
        String fromAddress = "**Invalid**";
        boolean canSendEMail = false;
        MUser user = MUser.get(wsc.ctx);
        if (user != null && user.isEMailValid() && user.isCanSendEMail()) {
            fromAddress = user.getEMail();
            canSendEMail = true;
        }
        table layout = new table();
        layout.setStyle("margin:10px;border-collapse:separate;border-spacing:5px;");
        tr line = new tr();
        line.addElement((Element)new td(Msg.translate(wsc.ctx, "From")));
        input from = new input("text", FROM, fromAddress);
        from.setStyle("width:535px;");
        from.setReadOnly(true);
        line.addElement((Element)new td((Element)from));
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.translate(wsc.ctx, "To")));
        td item = new td();
        input to = new input("hidden", TO, "");
        to.setID("AD_User_IDD");
        to.setOnChange("onUserChange('AD_User_ID');");
        item.addElement((Element)to);
        to = new input("text", TO, "");
        to.setID("AD_User_IDF");
        to.setStyle("width:505px;");
        to.setOnChange("setChangeFlag();startUpdate(this);");
        to.setReadOnly(true);
        item.addElement((Element)to);
        img iBtn = new img("/compiere/ampiere/images/PickOpen16.gif", TO);
        iBtn.setClass("popupButton");
        iBtn.setID("AD_User_IDB");
        iBtn.setAlt(Msg.translate(wsc.ctx, TO));
        iBtn.setTitle(Msg.translate(wsc.ctx, TO));
        iBtn.setOnClick("startLookup('AD_User_ID',0,212,'AD_User_ID', 'N',null);return false;");
        item.addElement((Element)iBtn);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.translate(wsc.ctx, "")));
        input toName = new input("text", TO_NAME, "");
        toName.setID(TO_NAME);
        toName.setStyle("width:535px;");
        toName.setReadOnly(true);
        line.addElement((Element)new td((Element)toName));
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.translate(wsc.ctx, "Subject")));
        input subject = new input("text", SUBJECT, Env.getHeader(wsc.ctx, 0));
        subject.setStyle("width:535px;");
        subject.setID(SUBJECT);
        line.addElement((Element)new td((Element)subject));
        layout.addElement((Element)line);
        line = new tr();
        item = new td();
        item.setColSpan(2);
        textarea infoArea = new textarea();
        infoArea.setName(BODY);
        infoArea.setID(BODY);
        infoArea.setStyle("width:570px;height:300px;");
        infoArea.addElement(WAbout.getInfo(wsc.ctx, null, false).toString() + Env.NL);
        infoArea.addElement("-------------------------------------------------------------" + Env.NL);
        infoArea.addElement(WAbout.getBrowserInfo(request, null, false).toString());
        infoArea.addElement("-------------------------------------------------------------" + Env.NL);
        String[] context = wsc.ctx.getEntireContext();
        for (int i2 = 0; i2 < context.length; ++i2) {
            infoArea.addElement(context[i2] + Env.NL);
        }
        item.addElement((Element)infoArea);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        item = new td();
        item.setColSpan(2);
        item.setAlign("right");
        input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", "window.close();");
        item.addElement((Element)cancel);
        input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "submitForm();");
        if (canSendEMail) {
            ok.setDisabled(false);
        } else {
            ok.setDisabled(true);
        }
        item.addElement((Element)ok);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        form mForm = new form();
        mForm.setMethod("post");
        mForm.setID(FORM_NAME);
        mForm.setName(FORM_NAME);
        mForm.addElement((Element)layout);
        doc.getTable().addElement((Element)mForm);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MUser user;
        int userId;
        this.log.info("WEMail.doPost");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String context = "";
        String postType = WebUtil.getParameter(request, POST_TYPE);
        if (POST_TYPE_SEND_EMAIL.equals(postType)) {
            userId = WebUtil.getParameterAsInt(request, TO);
            if (userId > 0) {
                MUser fromUser = MUser.get(wsc.ctx);
                MUser toUser = MUser.get(wsc.ctx, userId);
                String subject = WebUtil.getParameter(request, SUBJECT);
                String body2 = WebUtil.getParameter(request, BODY);
                EMail mail = MClient.get(wsc.ctx).createEMail(fromUser, toUser, subject, body2);
                String result = mail.send();
                if (result != null) {
                    context = result;
                }
            }
        } else if (POST_TYPE_GET_ADDRESS.equals(postType) && (userId = WebUtil.getParameterAsInt(request, TO)) > 0 && (user = MUser.get(wsc.ctx, userId)) != null) {
            context = user.getEMail();
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(context);
        out.flush();
        out.close();
    }
}

