/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import com.jware.util.StringToIntConverter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAccount
extends HttpServlet {
    private static final long serialVersionUID = -6348547380305885368L;
    protected static final String FORM_NAME = "WForm";
    private static final String P_Command = "PCommand";
    private static final String P_ChangedColumn = "ChangedColumn";
    private static final String M_ACCT_SCHEMA = "MAcctSchema";
    private static final String M_QUERY = "m_query";
    private GridWindow m_mWindow = null;
    private GridTab m_mTab = null;
    private static final String GET_PARAMS_ACTION = "1";
    String f_Alias = null;
    String f_SubAcct_ID = null;
    String f_M_Product_ID = null;
    String f_C_BPartner_ID = null;
    String f_AD_OrgTrx_ID = null;
    String f_C_LocFrom_ID = null;
    String f_C_LocTo_ID = null;
    String f_C_SalesRegion_ID = null;
    String f_C_Project_ID = null;
    String f_C_Campaign_ID = null;
    String f_C_Activity_ID = null;
    String f_User1_ID = null;
    String f_User2_ID = null;
    String f_AD_Org_ID = null;
    String f_Account_ID = null;
    String f_Combination = null;
    String f_Description = null;
    int num = 0;
    tr globalLine = null;
    ArrayList<String> searchElementList = new ArrayList();
    MAcctSchema s_AcctSchema;
    String script = null;
    boolean showResult = false;
    private static CLogger log = CLogger.getCLogger(WAccount.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAccount.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        this.num = 0;
        this.script = "";
        this.setParameters(request);
        log.config("WAccount.doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String columnName = WebUtil.getParameter(request, "columnName");
        String actionType = request.getParameter("actionType");
        if (GET_PARAMS_ACTION.equals(actionType)) {
            this.showResult = false;
            Document xml_doc = this.getParamsXml(request);
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return;
        }
        GridField mField = ws.curTab.getField(columnName);
        log.config("ColumnName=" + columnName + ", MField=" + mField.toString());
        if (mField == null || columnName == null || columnName.equals("")) {
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        String target = columnName;
        int noFields = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < noFields; ++i2) {
            GridField field = ws.curTab.getField(i2);
            String columnNameTemp = field.getColumnName();
            if (!columnNameTemp.equals("AD_Org_ID")) continue;
            field.setValueValidate(request.getParameter("AD_Org_ID"), false);
            break;
        }
        WebDoc doc = WebDoc.createWindow(mField.getHeader());
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, "js/account.js"));
        StringBuffer sb = new StringBuffer();
        sb.append("function selectAccount(columnName, key, value) {\n").append("    if (! checkParent(window)) {\n").append("        window.close();\n").append("\t\treturn;\n").append("\t}\n").append("    var targetObj = null;\n").append("    var updateObj = null;\n").append("    if (window.opener.top.WWindow) {\n").append("    \ttargetObj = (window.opener.top.WWindow.document.getElementById(columnName + 'D'));\n").append("    \tupdateObj = (window.opener.top.WWindow.document.getElementById(columnName + 'F'));\n").append("    } else {\n").append("\t    targetObj = (window.opener.top.document.getElementById(columnName + 'D'));\n").append("\t    updateObj = (window.opener.top.document.getElementById(columnName + 'F'));\n").append("    }\n").append("    if (targetObj != null && updateObj != null) {\n").append("        targetObj.value = key;\n").append("        updateObj.value = value;\n").append("        startUpdate(updateObj);\n").append("    }\n").append("    window.close();\n").append("    window.opener.focus();\n").append("}\n");
        doc.getHead().addElement((org.apache.ecs.Element)new script(sb.toString()));
        sb = new StringBuffer();
        sb.append("function resetAccount(columnName) {\n").append("    selectAccount(columnName, '', '');\n").append("}\n");
        doc.getHead().addElement((org.apache.ecs.Element)new script(sb.toString()));
        body body2 = doc.getBody();
        if (!"C_ValidCombination_ID".equals(target)) {
            body2.setOnBlur("self.focus();");
        }
        body2.addElement((org.apache.ecs.Element)this.searchTable(request, wsc, ws, mField, target));
        if ("Save".equals(request.getParameter(P_Command))) {
            String msg;
            String err_msg = null;
            err_msg = this.action_Save(request);
            if (StringUtils.isEmpty(err_msg)) {
                msg = WebEnv.NBSP + WebEnv.NBSP + "<font color='Red'>Your data has been successfully saved.</font>";
                body2.addElement(msg);
            } else {
                msg = WebEnv.NBSP + WebEnv.NBSP + "<font color='Red'>" + err_msg + "</font>";
                body2.addElement(msg);
            }
        }
        div divBody = (div)new div().setID("body");
        if (!StringUtils.isEmpty(request.getParameter("combinationId")) && !this.showResult) {
            int m_C_AcctSchema_ID = wsc.ctx.getContextAsInt("$C_AcctSchema_ID");
            this.loadInfo(StringToIntConverter.StringToInt(request.getParameter("combinationId")), m_C_AcctSchema_ID);
            this.showResult = true;
        }
        this.action_Find(request, true);
        if (this.showResult) {
            divBody.addElement((org.apache.ecs.Element)this.fillTable(ws, mField, target));
            this.showResult = false;
            if (!StringUtils.isEmpty(this.getFirstItemId(request, mField))) {
                body2.setOnLoad("getParamsRequest(" + this.getFirstItemId(request, mField) + ", '1');");
            }
        } else {
            divBody.addElement((org.apache.ecs.Element)new table().addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)new td())));
        }
        body2.addElement((org.apache.ecs.Element)divBody);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("WAccount.doPost");
        this.showResult = true;
        this.doGet(request, response);
    }

    private String getFirstItemId(HttpServletRequest request, GridField mField) {
        WWindowStatus ws = WWindowStatus.get(request);
        String id = "";
        Lookup lookup = mField.getLookup();
        if (this.m_mTab.getRowCount() > 0) {
            this.m_mTab.navigate(0);
            Object key = this.m_mTab.getField("C_ValidCombination_ID").getValue();
            KeyNamePair np = (KeyNamePair)lookup.get(key);
            id = String.valueOf(np.getKey());
        }
        return id;
    }

    private table fillTable(WWindowStatus ws, GridField mField, String target) {
        table table2 = new table();
        table2.setStyle("margin-top: 20px;");
        tr line = new tr();
        line.addElement((org.apache.ecs.Element)new th("&nbsp"));
        if (this.m_mTab.getRowCount() > 0) {
            for (int i2 = 0; i2 < this.searchElementList.size(); ++i2) {
                String element = this.searchElementList.get(i2);
                line.addElement(new th(Msg.translate(ws.ctx, element)).setStyle("text-align: center;"));
            }
            table2.setBorder(1);
        }
        table2.addElement((org.apache.ecs.Element)line);
        Lookup lookup = mField.getLookup();
        lookup.fillComboBox(mField.isMandatory(false), true, true, true);
        for (int lineNo = 0; lineNo < this.m_mTab.getRowCount(); ++lineNo) {
            this.m_mTab.navigate(lineNo);
            Object key = this.m_mTab.getField("C_ValidCombination_ID").getValue();
            KeyNamePair np = (KeyNamePair)lookup.get(key);
            button button2 = new button();
            button2.addElement("&gt;");
            StringBuffer script2 = new StringBuffer("selectAccount('" + target + "', '" + np.getKey() + "', '" + np.getName() + "');");
            button2.setOnClick(script2.toString());
            line = new tr();
            line.setOnClick("getParamsRequest(" + np.getKey() + ", '1');");
            line.setOnMouseOver("this.style.backgroundColor = 'red';");
            line.setOnMouseOut("this.style.backgroundColor = 'transparent';");
            line.addElement((org.apache.ecs.Element)new td((org.apache.ecs.Element)button2));
            for (int i3 = 0; i3 < this.searchElementList.size(); ++i3) {
                String element = this.searchElementList.get(i3);
                String searchField = "";
                try {
                    searchField = this.m_mTab.getField(element).getValue().toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                line.addElement((org.apache.ecs.Element)new td(searchField));
            }
            table2.addElement((org.apache.ecs.Element)line);
        }
        lookup.fillComboBox(true);
        return table2;
    }

    private form searchTable(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws, GridField mField, String target) {
        int m_WindowNo = ws.getCurTab().getWindowNo() + 1;
        GridWindowVO mWindowVO = GridWindowVO.create(wsc.ctx, m_WindowNo, 153, 0);
        ws = new WWindowStatus(mWindowVO);
        this.m_mWindow = new GridWindow(mWindowVO);
        form f = this.getSR_Form(request, wsc, ws);
        f.addElement((org.apache.ecs.Element)new input("hidden", P_ChangedColumn, ""));
        return f;
    }

    private form getSR_Form(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        HttpSession session = request.getSession();
        log.fine("Tab=" + ws.curTab.getTabNo());
        this.searchElementList.clear();
        div divBody = (div)new div().setID("body");
        table table2 = new table("0", "5", "5", "100%", null).setAlign("center");
        divBody.addElement((org.apache.ecs.Element)table2);
        StringBuffer scriptSrc = new StringBuffer();
        wsc.ctx.setContext(ws.curTab.getWindowNo(), "Record_ID", ws.curTab.getRecord_ID());
        int m_WindowNo = this.m_mWindow.getWindowNo();
        int m_C_AcctSchema_ID = wsc.ctx.getContextAsInt("$C_AcctSchema_ID");
        this.s_AcctSchema = new MAcctSchema(wsc.ctx, m_C_AcctSchema_ID, null);
        session.setAttribute(M_ACCT_SCHEMA, (Object)this.s_AcctSchema);
        if (this.s_AcctSchema.isHasAlias()) {
            String columnName = "Alias";
            table2 = this.addSearchElement(request, columnName, table2);
        }
        GridField combination = this.m_mTab.getField("Combination");
        table2 = this.addSearchElement(request, "Combination", table2);
        MAcctSchemaElement[] elements = this.s_AcctSchema.getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MAcctSchemaElement ase = elements[i2];
            String type = ase.getElementType();
            boolean isMandatory = ase.isMandatory();
            if (type.equals("OO")) {
                table2 = this.addSearchElement(request, "AD_Org_ID", table2);
                continue;
            }
            if (type.equals("AC")) {
                table2 = this.addSearchElement(request, "Account_ID", table2);
                continue;
            }
            if (type.equals("SA")) {
                table2 = this.addSearchElement(request, "C_SubAcct_ID", table2);
                continue;
            }
            if (type.equals("PR")) {
                table2 = this.addSearchElement(request, "M_Product_ID", table2);
                continue;
            }
            if (type.equals("BP")) {
                table2 = this.addSearchElement(request, "C_BPartner_ID", table2);
                continue;
            }
            if (type.equals("MC")) {
                table2 = this.addSearchElement(request, "C_Campaign_ID", table2);
                continue;
            }
            if (type.equals("LF")) {
                table2 = this.addSearchElement(request, "C_LocFrom_ID", table2);
                continue;
            }
            if (type.equals("LT")) {
                table2 = this.addSearchElement(request, "C_LocTo_ID", table2);
                continue;
            }
            if (type.equals("PJ")) {
                table2 = this.addSearchElement(request, "C_Project_ID", table2);
                continue;
            }
            if (type.equals("SR")) {
                table2 = this.addSearchElement(request, "C_SalesRegion_ID", table2);
                continue;
            }
            if (type.equals("OT")) {
                table2 = this.addSearchElement(request, "AD_OrgTrx_ID", table2);
                continue;
            }
            if (type.equals("AY")) {
                table2 = this.addSearchElement(request, "C_Activity_ID", table2);
                continue;
            }
            if (type.equals("U1")) {
                table2 = this.addSearchElement(request, "User1_ID", table2);
                continue;
            }
            if (!type.equals("U2")) continue;
            table2 = this.addSearchElement(request, "User2_ID", table2);
        }
        if (scriptSrc.length() > 0) {
            table2.addElement((org.apache.ecs.Element)new script(scriptSrc.toString()));
        }
        int rowNo = ws.curTab.getCurrentRow();
        form myForm = new form();
        myForm.setTarget("_self");
        myForm.setID("WWindow" + ws.mWindow.getAD_Window_ID());
        myForm.setName(FORM_NAME);
        td toolbar = new td(null, "right", "middle", true);
        String AD_Language = Env.getAD_Language(ws.ctx);
        toolbar.addElement((org.apache.ecs.Element)WAccount.createImage(AD_Language, "Save", "Save", null, true, false));
        toolbar.addElement((org.apache.ecs.Element)WAccount.createImage(AD_Language, "Refresh", "Refresh", null, true, false));
        img refreshImg = WAccount.createImage(AD_Language, "Ignore", "Ignore", null, true, false);
        refreshImg.setOnClick(this.script + "return false;");
        toolbar.addElement((org.apache.ecs.Element)refreshImg);
        table toolTable = new table("0", "0", "5", "100%", null);
        toolTable.setID("WWindow.topTable");
        toolTable.addElement((org.apache.ecs.Element)new tr((org.apache.ecs.Element)toolbar));
        table2.addElement((org.apache.ecs.Element)new input("hidden", P_Command, ""));
        myForm.addElement((org.apache.ecs.Element)divBody);
        myForm.addElement((org.apache.ecs.Element)toolTable);
        return myForm;
    }

    private table addSearchElement(HttpServletRequest request, String columnName, table table2) {
        HttpSession session = request.getSession();
        this.searchElementList.add(columnName);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        this.m_mTab = this.m_mWindow.getTab(0);
        session.setAttribute("m_mTab", (Object)this.m_mTab);
        GridField field = this.m_mTab.getField(columnName);
        if (this.num % 2 == 0) {
            this.globalLine = new tr();
        }
        ++this.num;
        String oldStr = request.getParameter(columnName);
        String oData = request.getParameter(columnName);
        oData = oData != null ? oData : oldStr;
        oData = oData != null && oData.equals("") ? null : oData;
        boolean hasDependents = ws.curTab.hasDependants(columnName);
        if (columnName.equals("Account_ID") && request.getParameter("Account_ID") != null && request.getParameter("Account_ID").equals("") && "Save".equals(request.getParameter(P_Command))) {
            field.setErrorValue("");
        }
        String changeColum = request.getParameter(P_ChangedColumn);
        String param = request.getParameter("Account_ID");
        boolean changeColumFlag = false;
        String p_command = request.getParameter(P_Command);
        if ("C_SubAcct_ID".equals(field.getColumnName()) && ("Account_ID".equals(changeColum) || "Save".equals(p_command) || "Find".equals(p_command))) {
            changeColumFlag = true;
        }
        this.addField(wsc, this.globalLine, field, oData, hasDependents, false, changeColumFlag, param);
        table2.addElement((org.apache.ecs.Element)this.globalLine);
        return table2;
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly, boolean changeColumFlag, String param) {
        String columnName = field.getColumnName();
        boolean error = field.isErrorValue();
        if (error) {
            oData = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        int display_length = field.getDisplayLength();
        display_length = 20;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), display_length * 12, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        if (changeColumFlag) {
            line.addElement(wField.getLabel().setStyle("text-align:right;"));
        } else {
            line.addElement(wField.getLabel().setStyle("text-align:right;")).addElement((org.apache.ecs.Element)wField.getField(field.getLookup(), oData, field.getAD_Column_ID()));
        }
        this.addCleanScript(field);
    }

    void addCleanScript(GridField field) {
        int m_displayType = field.getDisplayType();
        String m_columnName = field.getColumnName();
        String defalueName = m_columnName + "F";
        String split_char = "|";
        if (m_displayType == 30 || m_displayType == 21 || m_displayType == 25 || m_displayType == 35) {
            this.script = this.script + this.getDefaultFieldInitScript(m_columnName + "D");
            this.script = this.script + this.getDefaultFieldInitScript(m_columnName + "F");
        } else if (DisplayType.isLookup(m_displayType) || m_displayType == 31) {
            this.script = this.script + this.getSelectFieldInitScript(m_columnName);
        } else if (m_displayType == 20) {
            this.script = this.script + this.getCheckFieldInitScript(defalueName);
        } else if (m_displayType == 28) {
            this.script = this.script + this.getDefaultFieldInitScript(m_columnName + "D");
            this.script = this.script + this.getDefaultFieldInitScript(m_columnName + "F");
        } else {
            this.script = DisplayType.isDate(m_displayType) ? this.script + this.getDefaultFieldInitScript(defalueName) : (DisplayType.isNumeric(m_displayType) ? this.script + this.getDefaultFieldInitScript(defalueName) : (m_displayType == 14 ? this.script + this.getDefaultFieldInitScript(defalueName) : (m_displayType == 36 ? this.script + this.getDefaultFieldInitScript(defalueName) : (m_displayType == 34 ? this.script + this.getDefaultFieldInitScript(defalueName) : this.script + this.getDefaultFieldInitScript(defalueName)))));
        }
    }

    String getDefaultFieldInitScript(String id) {
        return "document.getElementById('" + id + "').value='';";
    }

    String getSelectFieldInitScript(String id) {
        String src = "document.getElementById('" + id + "').selectedIndex = -1;";
        return src;
    }

    String getCheckFieldInitScript(String id) {
        String src = "document.getElementById('" + id + "').checked = false;";
        return src;
    }

    private static img createImage(String AD_Language, String name, String id, String js_command, boolean enabled, boolean pressed) {
        StringBuffer imgName = new StringBuffer(name);
        if (!enabled) {
            imgName.append("D");
        } else if (pressed) {
            imgName.append("X");
        }
        imgName.append("24.gif");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (enabled) {
            img2.setAlt(Msg.getMsg(AD_Language, name));
        }
        if (enabled) {
            if (!pressed) {
                img2.setClass("imgButton");
            } else {
                img2.setClass("imgButtonPressed");
            }
            img2.setOnMouseOver("btnMouseOver('" + id + "');");
            img2.setOnMouseOut("btnMouseOut('" + id + "');");
        } else {
            img2.setClass("imgButtonD");
        }
        img2.setID(id);
        img2.setStyle("");
        if (js_command == null) {
            js_command = "WForm.submit();";
            if (js_command.length() > 0 && enabled) {
                img2.setOnClick("if( submitting!=true ){ submitting=true; document.WForm.PCommand.value='" + name + "';" + js_command + "}; return false;");
            }
        } else if (js_command.length() > 0 && enabled) {
            img2.setOnClick("document.WForm.PCommand.value='" + name + "';" + js_command);
        }
        return img2;
    }

    private String addFieldCallOut(String param, tr line) {
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        try {
            StringBuffer sql = new StringBuffer("SELECT subacct.NAME, subacct.c_subacct_id");
            sql.append("  FROM c_subacct subacct");
            sql.append(" WHERE subacct.c_elementvalue_id = ?");
            CPreparedStatement prep = DB.prepareStatement(sql.toString(), null);
            prep.setString(1, param);
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(2), rs.getString(1)));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WAccount.addFieldCallOut is error ", e);
        }
        return this.createHtml(list);
    }

    private String createHtml(ArrayList<KeyNamePair> list) {
        StringBuffer str = new StringBuffer("<td valign=\"middle\" align=\"left\">");
        str.append("<select id=\"C_SubAcct_ID\" name=\"C_SubAcct_ID\">");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            KeyNamePair keyPair = list.get(i2);
            str.append("<option value='" + keyPair.getKey() + "'>");
            str.append(keyPair.getName());
            str.append("</option>");
        }
        str.append("</select>");
        str.append("</td>");
        return str.toString();
    }

    private String action_Save(HttpServletRequest request) {
        String err_msg = null;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        int m_WindowNo = ws.getCurTab().getWindowNo();
        int m_AD_Client_ID = wsc.ctx.getContextAsInt(m_WindowNo, "AD_Client_ID");
        String f_Alias = request.getParameter("Alias");
        String f_SubAcct_ID = request.getParameter("C_SubAcct_ID");
        String f_M_Product_ID = request.getParameter("M_Product_ID");
        String f_C_BPartner_ID = request.getParameter("C_BPartner_ID");
        String f_AD_OrgTrx_ID = request.getParameter("AD_OrgTrx_ID");
        String f_C_LocFrom_ID = request.getParameter("C_LocFrom_ID");
        String f_C_LocTo_ID = request.getParameter("C_LocTo_ID");
        String f_C_SalesRegion_ID = request.getParameter("C_SalesRegion_ID");
        String f_C_Project_ID = request.getParameter("C_Project_ID");
        String f_C_Campaign_ID = request.getParameter("C_Campaign_ID");
        String f_C_Activity_ID = request.getParameter("C_Activity_ID");
        String f_User1_ID = request.getParameter("User1_ID");
        String f_User2_ID = request.getParameter("User2_ID");
        String f_AD_Org_ID = request.getParameter("AD_Org_ID");
        String f_Account_ID = request.getParameter("Account_ID");
        log.info("");
        StringBuffer sb = new StringBuffer();
        StringBuffer sql = new StringBuffer("SELECT C_ValidCombination_ID, Alias FROM C_ValidCombination WHERE ");
        String value = null;
        if (this.s_AcctSchema.isHasAlias() && (value = request.getParameter("Alias")) == null) {
            sb.append(Msg.translate(wsc.ctx, "Alias")).append(", ");
        }
        MAcctSchemaElement[] elements = this.s_AcctSchema.getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MAcctSchemaElement ase = elements[i2];
            String type = ase.getElementType();
            if (type.equals("OO")) {
                value = request.getParameter("AD_Org_ID");
                sql.append("AD_Org_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("AC")) {
                value = request.getParameter("Account_ID");
                sql.append("Account_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("SA")) {
                value = request.getParameter("C_SubAcct_ID");
                sql.append("C_SubAcct_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("PR")) {
                value = request.getParameter("M_Product_ID");
                sql.append("M_Product_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("BP")) {
                value = request.getParameter("C_BPartner_ID");
                sql.append("C_BPartner_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("MC")) {
                value = request.getParameter("C_Campaign_ID");
                sql.append("C_Campaign_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("LF")) {
                value = request.getParameter("C_LocFrom_ID");
                sql.append("C_LocFrom_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("LT")) {
                value = request.getParameter("C_LocTo_ID");
                sql.append("C_LocTo_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("PJ")) {
                value = request.getParameter("C_Project_ID");
                sql.append("C_Project_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("SR")) {
                value = request.getParameter("C_SalesRegion_ID");
                sql.append("C_SalesRegion_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("OT")) {
                value = request.getParameter("AD_OrgTrx_ID");
                sql.append("AD_OrgTrx_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("AY")) {
                value = request.getParameter("C_Activity_ID");
                sql.append("C_Activity_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("U1")) {
                value = request.getParameter("User1_ID");
                sql.append("User1_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            } else if (type.equals("U2")) {
                value = request.getParameter("User2_ID");
                sql.append("User2_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append((Object)value).append(" AND ");
                }
            }
            if (!ase.isMandatory() || value != null) continue;
            sb.append(ase.getName()).append(", ");
        }
        if (sb.length() != 0) {
            err_msg = AWebUtil.info(request, "FillMandatory", sb.substring(0, sb.length() - 2));
            return err_msg;
        }
        if (StringUtils.isEmpty(request.getParameter("AD_Org_ID"))) {
            err_msg = AWebUtil.info(request, "FillMandatory", Msg.getElement(wsc.ctx, "AD_Org_ID"));
            return err_msg;
        }
        if (StringUtils.isEmpty(request.getParameter("Account_ID"))) {
            err_msg = AWebUtil.info(request, "FillMandatory", Msg.getElement(wsc.ctx, "Account_ID"));
            return err_msg;
        }
        sql.append("AD_Client_ID=? AND C_AcctSchema_ID=?");
        log.fine("Check = " + sql.toString());
        int IDvalue = 0;
        String Alias = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, m_AD_Client_ID);
            pstmt.setInt(2, this.s_AcctSchema.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                IDvalue = rs.getInt(1);
                Alias = rs.getString(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
            IDvalue = 0;
        }
        log.fine("ID=" + IDvalue + ", Alias=" + Alias);
        if (Alias == null) {
            Alias = "";
        }
        if (IDvalue != 0 && this.s_AcctSchema.isHasAlias() && !Alias.equals(f_Alias)) {
            sql = new StringBuffer("UPDATE C_ValidCombination SET Alias=");
            if (StringUtils.isEmpty(f_Alias)) {
                sql.append("NULL");
            } else {
                sql.append("'").append(f_Alias).append("'");
            }
            sql.append(" WHERE C_ValidCombination_ID=").append(IDvalue);
            int i3 = 0;
            try {
                Statement stmt = DB.createStatement();
                i3 = stmt.executeUpdate(sql.toString());
                stmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            if (i3 == 0) {
                // empty if block
            }
        }
        if (IDvalue != 0) {
            this.loadInfo(IDvalue, this.s_AcctSchema.getC_AcctSchema_ID());
            this.action_Find(request, false);
            return err_msg;
        }
        log.config("New");
        Alias = null;
        if (f_Alias != null) {
            Alias = f_Alias;
        }
        int C_SubAcct_ID = 0;
        if (!StringUtils.isEmpty(f_SubAcct_ID)) {
            C_SubAcct_ID = StringToIntConverter.StringToInt(f_SubAcct_ID);
        }
        int M_Product_ID = 0;
        if (!StringUtils.isEmpty(f_M_Product_ID)) {
            M_Product_ID = StringToIntConverter.StringToInt(f_M_Product_ID);
        }
        int C_BPartner_ID = 0;
        if (!StringUtils.isEmpty(f_C_BPartner_ID)) {
            C_BPartner_ID = StringToIntConverter.StringToInt(f_C_BPartner_ID);
        }
        int AD_OrgTrx_ID = 0;
        if (!StringUtils.isEmpty(f_AD_OrgTrx_ID)) {
            AD_OrgTrx_ID = StringToIntConverter.StringToInt(f_AD_OrgTrx_ID);
        }
        int C_LocFrom_ID = 0;
        if (!StringUtils.isEmpty(f_C_LocFrom_ID)) {
            C_LocFrom_ID = StringToIntConverter.StringToInt(f_C_LocFrom_ID);
        }
        int C_LocTo_ID = 0;
        if (!StringUtils.isEmpty(f_C_LocTo_ID)) {
            C_LocTo_ID = StringToIntConverter.StringToInt(f_C_LocTo_ID);
        }
        int C_SRegion_ID = 0;
        if (!StringUtils.isEmpty(f_C_SalesRegion_ID)) {
            C_SRegion_ID = StringToIntConverter.StringToInt(f_C_SalesRegion_ID);
        }
        int C_Project_ID = 0;
        if (!StringUtils.isEmpty(f_C_Project_ID)) {
            C_Project_ID = StringToIntConverter.StringToInt(f_C_Project_ID);
        }
        int C_Campaign_ID = 0;
        if (!StringUtils.isEmpty(f_C_Campaign_ID)) {
            C_Campaign_ID = StringToIntConverter.StringToInt(f_C_Campaign_ID);
        }
        int C_Activity_ID = 0;
        if (!StringUtils.isEmpty(f_C_Activity_ID)) {
            C_Activity_ID = StringToIntConverter.StringToInt(f_C_Activity_ID);
        }
        int User1_ID = 0;
        if (!StringUtils.isEmpty(f_User1_ID)) {
            User1_ID = StringToIntConverter.StringToInt(f_User1_ID);
        }
        int User2_ID = 0;
        if (!StringUtils.isEmpty(f_User2_ID)) {
            User2_ID = StringToIntConverter.StringToInt(f_User2_ID);
        }
        int AD_Org_ID = StringToIntConverter.StringToInt(f_AD_Org_ID);
        int Account_ID = StringToIntConverter.StringToInt(f_Account_ID);
        MAccount acct = MAccount.get(wsc.ctx, m_AD_Client_ID, AD_Org_ID, this.s_AcctSchema.getC_AcctSchema_ID(), Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, 0, 0);
        if (acct != null && acct.get_ID() == 0) {
            acct.save();
        }
        if (acct == null || acct.get_ID() == 0) {
            this.loadInfo(0, 0);
        } else {
            if (Alias != null && Alias.length() > 0) {
                acct.setAlias(Alias);
                acct.save();
            }
            this.loadInfo(acct.get_ID(), this.s_AcctSchema.getC_AcctSchema_ID());
        }
        this.action_Find(request, false);
        return err_msg;
    }

    private void loadInfo(int C_ValidCombination_ID, int C_AcctSchema_ID) {
        log.fine("C_ValidCombination_ID=" + C_ValidCombination_ID);
        String sql = "SELECT * FROM C_ValidCombination WHERE C_ValidCombination_ID=? AND C_AcctSchema_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_ValidCombination_ID);
            pstmt.setInt(2, C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                if (this.f_Alias != null) {
                    this.f_Alias = rs.getString("Alias");
                }
                this.f_Combination = rs.getString("Combination");
                this.f_AD_Org_ID = this.loadInfoOf(rs, "AD_Org_ID");
                this.f_Account_ID = this.loadInfoOf(rs, "Account_ID");
                this.f_SubAcct_ID = this.loadInfoOf(rs, "C_SubAcct_ID");
                this.f_M_Product_ID = this.loadInfoOf(rs, "M_Product_ID");
                this.f_C_BPartner_ID = this.loadInfoOf(rs, "C_BPartner_ID");
                this.f_C_Campaign_ID = this.loadInfoOf(rs, "C_Campaign_ID");
                this.f_C_LocFrom_ID = this.loadInfoOf(rs, "C_LocFrom_ID");
                this.f_C_LocTo_ID = this.loadInfoOf(rs, "C_LocTo_ID");
                this.f_C_Project_ID = this.loadInfoOf(rs, "C_Project_ID");
                this.f_C_SalesRegion_ID = this.loadInfoOf(rs, "C_SalesRegion_ID");
                this.f_AD_OrgTrx_ID = this.loadInfoOf(rs, "AD_OrgTrx_ID");
                this.f_C_Activity_ID = this.loadInfoOf(rs, "C_Activity_ID");
                this.f_User1_ID = this.loadInfoOf(rs, "User1_ID");
                this.f_User2_ID = this.loadInfoOf(rs, "User2_ID");
                this.f_Description = rs.getString("Description");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    private String loadInfoOf(ResultSet rs, String name) throws SQLException {
        String str = null;
        int intValue = rs.getInt(name);
        str = rs.wasNull() ? null : String.valueOf(intValue);
        return str;
    }

    private void action_Find(HttpServletRequest request, boolean includeAliasCombination) {
        String value;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        log.info("");
        Query query = null;
        Query m_query = (Query)session.getAttribute(M_QUERY);
        query = m_query != null ? m_query.deepCopy() : new Query();
        if (includeAliasCombination && !StringUtils.isEmpty(this.f_Alias)) {
            value = this.f_Alias.toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            query.addRestriction("UPPER(Alias)", " LIKE ", value);
        }
        if (includeAliasCombination && !StringUtils.isEmpty(this.f_Combination)) {
            value = this.f_Combination.toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            query.addRestriction("UPPER(Combination)", " LIKE ", value);
        }
        if (!StringUtils.isEmpty(this.f_AD_Org_ID)) {
            query.addRestriction("AD_Org_ID", "=", this.f_AD_Org_ID);
        }
        if (!StringUtils.isEmpty(this.f_Account_ID)) {
            query.addRestriction("Account_ID", "=", this.f_Account_ID);
        }
        if (!StringUtils.isEmpty(this.f_SubAcct_ID)) {
            query.addRestriction("C_SubAcct_ID", "=", this.f_SubAcct_ID);
        }
        if (!StringUtils.isEmpty(this.f_M_Product_ID)) {
            query.addRestriction("M_Product_ID", "=", this.f_M_Product_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_BPartner_ID)) {
            query.addRestriction("C_BPartner_ID", "=", this.f_C_BPartner_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_Campaign_ID)) {
            query.addRestriction("C_Campaign_ID", "=", this.f_C_Campaign_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_LocFrom_ID)) {
            query.addRestriction("C_LocFrom_ID", "=", this.f_C_LocFrom_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_LocTo_ID)) {
            query.addRestriction("C_LocTo_ID", "=", this.f_C_LocTo_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_Project_ID)) {
            query.addRestriction("C_Project_ID", "=", this.f_C_Project_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_SalesRegion_ID)) {
            query.addRestriction("C_SalesRegion_ID", "=", this.f_C_SalesRegion_ID);
        }
        if (!StringUtils.isEmpty(this.f_AD_OrgTrx_ID)) {
            query.addRestriction("AD_OrgTrx_ID", "=", this.f_AD_OrgTrx_ID);
        }
        if (!StringUtils.isEmpty(this.f_C_Activity_ID)) {
            query.addRestriction("C_Activity_ID", "=", this.f_C_Activity_ID);
        }
        if (!StringUtils.isEmpty(this.f_User1_ID)) {
            query.addRestriction("User1_ID", "=", this.f_User1_ID);
        }
        if (!StringUtils.isEmpty(this.f_User2_ID)) {
            query.addRestriction("User2_ID", "=", this.f_User2_ID);
        }
        this.m_mTab.setQuery(query);
        this.m_mTab.query(0);
    }

    void setParameters(HttpServletRequest request) {
        this.f_Alias = request.getParameter("Alias");
        this.f_Combination = request.getParameter("Combination");
        this.f_SubAcct_ID = request.getParameter("C_SubAcct_ID");
        this.f_M_Product_ID = request.getParameter("M_Product_ID");
        this.f_C_BPartner_ID = request.getParameter("C_BPartner_ID");
        this.f_AD_OrgTrx_ID = request.getParameter("AD_OrgTrx_ID");
        this.f_C_LocFrom_ID = request.getParameter("C_LocFrom_ID");
        this.f_C_LocTo_ID = request.getParameter("C_LocTo_ID");
        this.f_C_SalesRegion_ID = request.getParameter("C_SalesRegion_ID");
        this.f_C_Project_ID = request.getParameter("C_Project_ID");
        this.f_C_Campaign_ID = request.getParameter("C_Campaign_ID");
        this.f_C_Activity_ID = request.getParameter("C_Activity_ID");
        this.f_User1_ID = request.getParameter("User1_ID");
        this.f_User2_ID = request.getParameter("User2_ID");
        this.f_AD_Org_ID = request.getParameter("AD_Org_ID");
        this.f_Account_ID = request.getParameter("Account_ID");
    }

    Document getParamsXml(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        String param_key = request.getParameter("key");
        Document document = AmpiereUtil.CreateNewDocument(request);
        HttpSession session = request.getSession();
        MAcctSchema s_AcctSchema = (MAcctSchema)session.getAttribute(M_ACCT_SCHEMA);
        GridTab m_mTab = (GridTab)session.getAttribute("m_mTab");
        tr line = new tr();
        for (int lineNo = 0; lineNo < m_mTab.getRowCount(); ++lineNo) {
            m_mTab.navigate(lineNo);
            String oneKey = m_mTab.getField("C_ValidCombination_ID").getValue().toString();
            if (!param_key.equals(oneKey)) continue;
            for (int i2 = 0; i2 < this.searchElementList.size(); ++i2) {
                Element elm_newValue;
                Element elm_visibility;
                Element elm_lookup;
                String objId;
                Element elm_id;
                Element element;
                String searchElement = this.searchElementList.get(i2);
                String searchField = "";
                try {
                    searchField = m_mTab.getField(searchElement).getValue().toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                line.addElement((org.apache.ecs.Element)new td(searchField));
                GridField field = m_mTab.getField(searchElement);
                Element elements = (Element)document.getFirstChild();
                if (DisplayType.isLookup(field.getDisplayType()) && field.getDisplayType() != 30) {
                    Object[] list = field.getLookup().getData(true, true, false, false).toArray();
                    element = document.createElement("element");
                    document.getFirstChild().appendChild(element);
                    elm_id = document.createElement("id");
                    objId = this.getHtmlObjectName(field);
                    elm_id.appendChild(document.createTextNode(objId));
                    element.appendChild(elm_id);
                    elm_lookup = document.createElement("lookup");
                    element.appendChild(elm_lookup);
                    elm_lookup.appendChild(document.createTextNode(GET_PARAMS_ACTION));
                    elm_visibility = document.createElement("visibility");
                    element.appendChild(elm_visibility);
                    elm_visibility.appendChild(document.createTextNode(GET_PARAMS_ACTION));
                    elm_newValue = document.createElement("newValue");
                    element.appendChild(elm_newValue);
                    for (int p2 = 0; p2 < list.length; ++p2) {
                        NamePair onePair;
                        boolean isNumber;
                        String key = "";
                        String value = "";
                        if (p2 == 0) {
                            Element elm_item = document.createElement("item");
                            elm_newValue.appendChild(elm_item);
                            Element elm_key = document.createElement("key");
                            elm_item.appendChild(elm_key);
                            elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                            Element elm_value = document.createElement("value");
                            elm_item.appendChild(elm_value);
                            elm_value.appendChild(document.createTextNode(value));
                        }
                        if (isNumber = list[0] instanceof KeyNamePair) {
                            onePair = (KeyNamePair)list[p2];
                            key = String.valueOf(((KeyNamePair)onePair).getKey());
                            value = onePair.getName();
                        } else {
                            onePair = (ValueNamePair)list[p2];
                            key = ((ValueNamePair)onePair).getValue();
                            value = onePair.getName();
                        }
                        Element elm_item = document.createElement("item");
                        elm_newValue.appendChild(elm_item);
                        Element elm_key = document.createElement("key");
                        elm_item.appendChild(elm_key);
                        elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                        Element elm_value = document.createElement("value");
                        elm_item.appendChild(elm_value);
                        elm_value.appendChild(document.createTextNode(value));
                    }
                    Element elm_readonly = document.createElement("readonly");
                    element.appendChild(elm_readonly);
                    elm_readonly.appendChild(document.createTextNode("0"));
                    Element elm_type = document.createElement("type");
                    element.appendChild(elm_type);
                    elm_type.appendChild(document.createTextNode(GET_PARAMS_ACTION));
                }
                if (!field.isDisplayed(true)) continue;
                Object newValue = field.getValue();
                element = document.createElement("element");
                elements.appendChild(element);
                elm_id = document.createElement("id");
                element.appendChild(elm_id);
                objId = this.getHtmlObjectName(field);
                elm_id.appendChild(document.createTextNode(objId));
                elm_lookup = document.createElement("lookup");
                element.appendChild(elm_lookup);
                elm_lookup.appendChild(document.createTextNode("0"));
                elm_visibility = document.createElement("visibility");
                element.appendChild(elm_visibility);
                elm_visibility.appendChild(document.createTextNode(GET_PARAMS_ACTION));
                elm_newValue = document.createElement("newValue");
                element.appendChild(elm_newValue);
                String newValue_str = AWebUtil.toString(newValue, wsc, field.getDisplayType(), field.getColumnName(), field);
                elm_newValue.appendChild(document.createTextNode(newValue_str));
                Element elm_readonly = document.createElement("readonly");
                element.appendChild(elm_readonly);
                elm_readonly.appendChild(document.createTextNode("0"));
                Element elm_type = document.createElement("type");
                element.appendChild(elm_type);
                if (field.getDisplayType() == 20) {
                    elm_type.appendChild(document.createTextNode("0"));
                } else {
                    elm_type.appendChild(document.createTextNode(GET_PARAMS_ACTION));
                }
                if (field.getDisplayType() != 30 && field.getDisplayType() != 21 && field.getDisplayType() != 25) continue;
                objId = field.getColumnName() + "F";
                AWebUtil.createDisplayElement(document, elements, objId, field, "0", true);
                objId = field.getColumnName() + "B";
                AWebUtil.createDisplayElement(document, elements, objId, field, "0", true);
            }
        }
        return document;
    }

    private String getHtmlObjectName(GridField field) {
        int m_displayType = field.getDisplayType();
        String m_columnName = field.getColumnName();
        String htmlObjId = "";
        htmlObjId = m_displayType == 30 || m_displayType == 21 || m_displayType == 25 || m_displayType == 35 ? m_columnName + "D" : (DisplayType.isLookup(m_displayType) || m_displayType == 31 ? m_columnName : (m_displayType == 20 ? m_columnName + "F" : (m_displayType == 28 ? m_columnName : (DisplayType.isDate(m_displayType) ? m_columnName + "F" : (DisplayType.isNumeric(m_displayType) ? m_columnName + "F" : (m_displayType == 14 ? m_columnName + "F" : (m_displayType == 36 ? m_columnName + "F" : (m_displayType == 34 ? m_columnName + "F" : m_columnName + "F"))))))));
        return htmlObjId;
    }
}

