/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.qoppa.pdf.Document;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.Compiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.util.ZipUtil;

public class WAbout
extends HttpServlet {
    private static final long serialVersionUID = -8195647187230888285L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final int WINDOW_WIDTH = 420;
    public static final int WINDOW_HEIGHT = 580;
    public static final String WEB_NL = "<br>";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAbout.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = WebDoc.createPopup(Msg.translate(wsc.ctx, "About"));
        table info = new table();
        info.setStyle("margin:10px 10px 10px 10px;");
        info.setAlign("center");
        tr line = new tr();
        td item = new td();
        item.setStyle("text-align:center;");
        item.addElement((Element)new img(WebEnv.getImageDirectory("Compiere120x30.png"), ""));
        item.addElement((Element)new br());
        font f = new font();
        f.setColor("#0000FF");
        f.addElement((Element)new i(Compiere.getSubtitle()));
        item.addElement((Element)f);
        line.addElement((Element)item);
        item = new td();
        item.setStyle("text-align:center");
        item.addElement(" Smart ERP & CRM Business Solution ");
        item.addElement((Element)new br());
        item.addElement("\u00a9 1999-2007 Compiere \u00ae");
        item.addElement((Element)new br());
        item.addElement("Release J3.0.0_A03 @ 2010-06-18");
        item.addElement((Element)new br());
        f = new font();
        f.setColor("#0000FF");
        f.addElement(Compiere.getURL());
        a link2 = new a(Compiere.getURL(), (Element)f);
        link2.setTarget("_blank");
        item.addElement((Element)link2);
        item.addElement((Element)new br());
        item.addElement((Element)new br());
        line.addElement((Element)item);
        info.addElement((Element)line);
        line = new tr();
        item = new td();
        item.setColSpan(2);
        item.setStyle("background-color:#aaaaaa");
        div layout = new div();
        layout.setStyle("overflow:auto;");
        layout.addElement(WAbout.getInfo(wsc.ctx, null, true).toString());
        item.addElement((Element)layout);
        line.addElement((Element)item);
        info.addElement((Element)line);
        doc.getTable().addElement((Element)info);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDoc doc = WebDoc.create("About - Post - Not Implemented");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public static StringBuffer getInfo(Ctx ctx, StringBuffer sb, boolean isWeb) {
        Attributes atts;
        String NL = Env.NL;
        if (isWeb) {
            NL = WEB_NL;
        }
        if (sb == null) {
            sb = new StringBuffer();
        }
        String eq = " = ";
        sb.append(Msg.translate(ctx, "Compiere\u00ae")).append(" ").append("Release J3.0.0_A03").append("_").append("2010-06-18").append(Msg.translate(ctx, "Implementation") + ":").append(Compiere.getImplementationVersion()).append(NL);
        sb.append(Msg.translate(ctx, "Host")).append(" = ").append(WAbout.getServerInfo(ctx)).append(NL);
        sb.append(Msg.translate(ctx, "Database")).append(" = ").append(WAbout.getDatabaseInfo(ctx)).append(NL);
        sb.append(Msg.translate(ctx, "Schema")).append(" = ").append(CConnection.get().getDbUid()).append(NL);
        sb.append(Msg.translate(ctx, "AD_User_ID")).append(" = ").append(ctx.getContext("#AD_User_Name")).append(NL);
        sb.append(Msg.translate(ctx, "AD_Role_ID")).append(" = ").append(ctx.getContext("#AD_Role_Name")).append(NL);
        sb.append(Msg.translate(ctx, "AD_Client_ID")).append(" = ").append(ctx.getContext("#AD_Client_Name")).append(NL);
        sb.append(Msg.translate(ctx, "AD_Org_ID")).append(" = ").append(ctx.getContext("#AD_Org_Name")).append(NL);
        sb.append(Msg.translate(ctx, "Date")).append(" = ").append(ctx.getContext("#Date")).append(NL);
        sb.append(Msg.translate(ctx, "Printer")).append(" = ").append(ctx.getPrinterName()).append(NL);
        Manifest mf = ZipUtil.getManifest("CClient.jar");
        if (mf == null) {
            mf = ZipUtil.getManifest("CTools.jar");
        }
        if (mf != null && (atts = mf.getMainAttributes()) != null) {
            for (Object key : atts.keySet()) {
                if (!key.toString().startsWith("Impl") && !key.toString().startsWith("Spec")) continue;
                sb.append(key).append(" = ").append(atts.get(key)).append(NL);
            }
        }
        sb.append(Msg.translate(ctx, "CompiereHome") + " = ").append(Compiere.getCompiereHome()).append(NL);
        sb.append(Env.getLanguage(ctx)).append(NL);
        MClient client = MClient.get(ctx);
        sb.append(client).append(NL);
        sb.append(Msg.translate(ctx, "IsMultiLingualDocument")).append(" = ").append(client.isMultiLingualDocument()).append(NL);
        sb.append(Msg.translate(ctx, "BaseLanguage") + " = ").append(Env.isBaseLanguage(ctx, "AD_Window")).append("/").append(Env.isBaseLanguage(ctx, "C_UOM")).append(NL);
        sb.append("PDF " + Msg.translate(ctx, "License") + "=").append(Document.isLicensed()).append(NL);
        sb.append(Compiere.getJavaInfo()).append(NL);
        sb.append(Compiere.getOSInfo());
        return sb;
    }

    private static String getServerInfo(Ctx ctx) {
        StringBuffer sb = new StringBuffer();
        CConnection cc = CConnection.get();
        sb.append(cc.getAppsHost()).append(" : ").append(cc.getAppsPort()).append(" (");
        if (cc.isAppsServerOK(false)) {
            sb.append(CConnection.get().getServerVersion());
        } else {
            sb.append(Msg.translate(ctx, "NotActive"));
        }
        sb.append(")\n  ");
        boolean remoteObjects = DB.isRemoteObjects();
        boolean remoteProcess = DB.isRemoteProcess();
        String realCP = "L";
        if (cc.isRMIoverHTTP() && cc.isAppsServerOK(false)) {
            realCP = "W";
        } else if (remoteObjects && remoteProcess) {
            realCP = "V";
        } else if (remoteProcess) {
            realCP = "T";
        }
        sb.append(cc.getConnectionProfileText(realCP));
        sb.append(": Tunnel=").append(cc.isRMIoverHTTP() && cc.isAppsServerOK(false)).append(", Objects=").append(remoteObjects).append(", Process=").append(remoteProcess);
        return sb.toString();
    }

    private static String getDatabaseInfo(Ctx ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(CConnection.get().getDbHost()).append(" : ").append(CConnection.get().getDbPort()).append(" / ").append(CConnection.get().getDbName());
        if (CConnection.get().isViaFirewall()) {
            sb.append(Msg.translate(ctx, "via")).append(" ").append(CConnection.get().getFwHost()).append(" : ").append(CConnection.get().getFwPort());
        }
        return sb.toString();
    }

    public static StringBuffer getBrowserInfo(HttpServletRequest request, StringBuffer sb, boolean isWeb) {
        String name;
        String NL = Env.NL;
        if (isWeb) {
            NL = WEB_NL;
        }
        if (sb == null) {
            sb = new StringBuffer();
        }
        String eq = " = ";
        sb.append("Character Encoding  = " + request.getCharacterEncoding() + NL);
        sb.append("Request URI  = " + request.getRequestURI() + NL);
        sb.append("Servlet Path  = " + request.getServletPath() + NL);
        sb.append("Path Info  = " + request.getPathInfo() + NL);
        sb.append("Method  = " + request.getMethod() + NL);
        sb.append("Path Translate  = " + request.getPathTranslated() + NL);
        sb.append("Query String  = " + request.getQueryString() + NL);
        sb.append("Remote Address  = " + request.getRemoteAddr() + NL);
        sb.append("Remote Host  = " + request.getRemoteHost() + NL);
        sb.append("Remote User  = " + request.getRemoteUser() + NL);
        sb.append("Session ID  = " + request.getRequestedSessionId() + NL);
        sb.append("Scheme  = " + request.getScheme() + NL);
        sb.append("Server Name  = " + request.getServerName() + NL);
        sb.append("Server Port  = " + String.valueOf(request.getServerPort()) + NL);
        sb.append("Secure  = " + request.isSecure() + NL);
        sb.append("UserPrincipal  = " + request.getUserPrincipal() + NL);
        sb.append("AuthType  = " + request.getAuthType() + NL);
        sb.append("Locale  = " + request.getLocale().toString() + NL);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append(name + " = " + request.getHeader(name) + NL);
        }
        names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append(name + " = " + request.getHeader(name) + NL);
        }
        names = request.getParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append(name + " = " + request.getHeader(name) + NL);
        }
        names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append(name + " = " + request.getHeader(name) + NL);
        }
        Cookie[] ccc = request.getCookies();
        if (ccc != null) {
            sb.append("Cookies:" + NL);
            for (int i2 = 0; i2 < ccc.length; ++i2) {
                sb.append("\tName = " + ccc[i2].getName() + NL);
                sb.append("\tValue = " + ccc[i2].getValue() + NL);
                sb.append("\tDomain = " + ccc[i2].getDomain() + NL);
                sb.append("\tPath = " + ccc[i2].getPath() + NL);
                sb.append("\tMaxAge = " + ccc[i2].getMaxAge() + NL);
            }
        }
        names = request.getLocales();
        while (names.hasMoreElements()) {
            sb.append("Local = " + names.nextElement() + NL);
        }
        return sb;
    }
}

