/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.util.WZoomTarget;
import com.ampiere.web.servlet.WWindowStatus;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WZoomAcross {
    private Query m_query;
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private static CLogger log = CLogger.getCLogger(WZoomAcross.class);

    public WZoomAcross(String tableName, Query query, int curWindow_ID, WWindowStatus ws) {
        log.config("TableName=" + tableName + " - " + query);
        this.m_query = query;
        this.getZoomTargets(tableName, curWindow_ID, ws);
        this.m_query.setRecordCount(1);
    }

    private void getZoomTargets(String tableName, int curWindow_ID, WWindowStatus ws) {
        String sql = "SELECT DISTINCT t.AD_Table_ID, t.TableName FROM AD_Table t WHERE EXISTS (SELECT 1 FROM AD_Tab tt WHERE tt.AD_Table_ID = t.AD_Table_ID AND tt.SeqNo=10)  AND t.AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName=?) AND TableName NOT LIKE 'I%'AND TableName NOT LIKE ? ORDER BY 1";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            int index = 1;
            pstmt.setString(index++, tableName + "_ID");
            pstmt.setString(index++, tableName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ArrayList<Object> zoomList = new ArrayList();
                String targetTableName = rs.getString(2);
                zoomList = WZoomTarget.getZoomTargets(targetTableName, curWindow_ID, this.m_query.getWhereClause(), ws);
                if (zoomList == null) continue;
                for (int i = 0; i < zoomList.size(); ++i) {
                    KeyNamePair pp = (KeyNamePair)zoomList.get(i);
                    if (this.m_list.contains(pp)) continue;
                    this.m_list.add(pp);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.m_list.size() == 0) {
            // empty if block
        }
    }

    public static ArrayList<KeyNamePair> cmd_zoomAcross(WWindowStatus ws) {
        int record_ID = ws.getCurTab().getRecord_ID();
        log.info("ID=" + record_ID);
        if (record_ID <= 0) {
            return null;
        }
        Query query = new Query();
        String link2 = ws.getCurTab().getKeyColumnName();
        if (link2.length() == 0) {
            link2 = ws.getCurTab().getLinkColumnName();
        }
        if (link2.length() != 0) {
            if (link2.endsWith("_ID")) {
                query.addRestriction(link2, "=", new Integer(ws.ctx.getContextAsInt(ws.getCurTab().getWindowNo(), link2)));
            } else {
                query.addRestriction(link2, "=", ws.ctx.getContext(ws.getCurTab().getWindowNo(), link2));
            }
        }
        WZoomAcross zoom = new WZoomAcross(ws.getCurTab().getTableName(), query, ws.getCurTab().getAD_Window_ID(), ws);
        return zoom.m_list;
    }
}

