/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import com.jware.util.StringToIntConverter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebSessionCtx;

public class InfoInvoice
extends Info {
    private Info_Column[] s_invoiceLayout = null;
    String fDocumentNo = null;
    String fDescription = null;
    String fPOReference = null;
    String fBPartner_ID = null;
    String fOrder_ID = null;
    String fDateFrom = null;
    String fDateTo = null;
    String fAmtFrom = null;
    String fAmtTo = null;
    String fIsSOTrx = null;
    String fIsPaid = null;
    WebSessionCtx wsc = null;

    public InfoInvoice(int WindowNo, String value, boolean multiSelection, String whereClause, Ctx ctx) {
        super(WindowNo, "i", "C_Invoice_ID", multiSelection, whereClause, ctx);
        this.title = Msg.translate(ctx, "InfoInvoice");
        int i = 0;
        this.s_invoiceLayout = new Info_Column[13];
        this.columnAttrList = new ArrayList();
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "Select"), "i.C_Invoice_ID", IDColumn.class);
        this.columnAttrList.add(1);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class);
        this.columnAttrList.add(1);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "DateInvoiced"), "i.DateInvoiced", Timestamp.class);
        this.columnAttrList.add(1);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "DocumentNo"), "i.DocumentNo", String.class);
        this.columnAttrList.add(1);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=i.C_Currency_ID)", String.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "GrandTotal"), "i.GrandTotal", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "ConvertedAmount"), "currencyBase(i.GrandTotal, i.C_Currency_ID, i.DateAcct, i.AD_Client_ID, i.AD_Org_ID)", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "OpenAmt"), "invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID)", BigDecimal.class, true, true, null);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "IsPaid"), "i.IsPaid", Boolean.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "IsSOTrx"), "i.IsSOTrx", Boolean.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "Description"), "i.Description", String.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column(Msg.translate(ctx, "POReference"), "i.POReference", String.class);
        this.columnAttrList.add(0);
        this.s_invoiceLayout[i++] = new Info_Column("", "''", KeyNamePair.class, "i.C_InvoicePaySchedule_ID");
        this.columnAttrList.add(0);
        this.m_keyColumnIndex = 0;
        try {
            String s = "";
            if (value != null && value.length() > 0) {
                s = value;
            }
            this.statInit(ctx, s);
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
    }

    private void statInit(Ctx ctx, String value) throws Exception {
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DocumentNo"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DocumentNo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, value, "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "BPartner"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_BPartner_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("C_BPartner_ID", 7, "", "left", "middle", "", 198));
        String isSOTrx = "N".equals(ctx.getContext(this.p_WindowNo, "IsSOTrx")) ? "N" : "Y";
        this.componentMapping.put("IsSOTrx", new Integer(this.componentList.size()));
        ComponentBean bean = new ComponentBean(Msg.translate(ctx, "IsSOTrx"), 6, isSOTrx, "left", "middle", "", 0);
        bean.setColSpan(2);
        this.componentList.add(bean);
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "Description"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("Description", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateOrdered"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("DateTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "C_Order_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_Order_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "GrandTotal"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("AmtFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "AmtFrom"), 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("AmtTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "AmtTo"), 3, "", "left", "middle", "", 220));
    }

    private boolean initInfo() {
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_Invoice.", "i."));
        }
        this.prepareTable(this.s_invoiceLayout, " C_Invoice_v i", where.toString(), "2,3,4");
        return true;
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "DocumentNo");
        if (s != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(i.DocumentNo) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "Description")) != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(i.Description) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_BPartner_ID")) != null) {
            sql.append(" AND i.C_BPartner_ID=");
            sql.append(Integer.parseInt(s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_Order_ID")) != null) {
            sql.append(" AND i.C_Order_ID=");
            sql.append(Integer.parseInt(s));
        }
        String from = this.getComponetValue(valueMapping, "DateFrom");
        String to = this.getComponetValue(valueMapping, "DateTo");
        if (from != null || to != null) {
            Timestamp fromT = null;
            Timestamp toT = null;
            try {
                Date d;
                if (from != null) {
                    d = dateFormat.parse(from);
                    fromT = new Timestamp(d.getTime());
                }
                if (to != null) {
                    d = dateFormat.parse(to);
                    toT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoInvoice : createQuery : Date convert error ", e);
            }
            if (fromT == null && toT != null) {
                sql.append(" AND TRUNC(i.DateInvoiced) <= ");
                sql.append(DB.TO_DATE(toT, true));
            } else if (fromT != null && toT == null) {
                sql.append(" AND TRUNC(i.DateInvoiced) >= ");
                sql.append(DB.TO_DATE(fromT, true));
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.DateInvoiced) BETWEEN ");
                sql.append(DB.TO_DATE(fromT, true));
                sql.append(" AND ");
                sql.append(DB.TO_DATE(toT, true));
            }
        }
        from = this.getComponetValue(valueMapping, "AmtFrom");
        to = this.getComponetValue(valueMapping, "AmtTo");
        if (from != null || to != null) {
            BigDecimal fromB = null;
            BigDecimal toB = null;
            try {
                fromB = new BigDecimal(from);
                toB = new BigDecimal(to);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoInvoice : createQuery : To BigDecimal ", e);
            }
            if (fromB == null && toB != null) {
                sql.append(" AND i.GrandTotal <= ");
                sql.append(toB);
            } else if (from != null && to == null) {
                sql.append(" AND i.GrandTotal >= ");
                sql.append(fromB);
            } else if (from != null && to != null) {
                sql.append(" AND i.GrandTotal BETWEEN ");
                sql.append(fromB);
                sql.append(" AND ");
                sql.append(toB);
            }
        }
        if ((s = this.getComponetValue(valueMapping, "IsPaid")) != null) {
            s = s.toUpperCase();
            sql.append(" AND i.IsPaid=");
            sql.append("'" + s + "'");
        }
        if ((s = this.getComponetValue(valueMapping, "IsSOTrx")) != null) {
            s = s.toUpperCase();
            sql.append(" AND i.IsSOTrx=");
            sql.append("'" + s + "'");
        }
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (!StringUtils.isEmpty(this.fDocumentNo)) {
            pstmt.setString(index++, this.getSQLText(this.fDocumentNo));
        }
        if (!StringUtils.isEmpty(this.fDescription)) {
            pstmt.setString(index++, this.getSQLText(this.fDescription));
        }
        if (!StringUtils.isEmpty(this.fPOReference)) {
            pstmt.setString(index++, this.getSQLText(this.fPOReference));
        }
        if (!StringUtils.isEmpty(this.fBPartner_ID)) {
            Integer bp = StringToIntConverter.StringToInt(this.fBPartner_ID);
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (!StringUtils.isEmpty(this.fDateFrom) || !StringUtils.isEmpty(this.fDateTo)) {
            try {
                from = null;
                to = null;
                try {
                    from = new Timestamp(this.wsc.dateFormat.parse(this.fDateFrom).getTime());
                }
                catch (Exception e) {
                    from = null;
                }
                try {
                    to = new Timestamp(this.wsc.dateFormat.parse(this.fDateTo).getTime());
                }
                catch (Exception e) {
                    to = null;
                }
                this.log.fine("Date From=" + from + ", To=" + to);
                if (from == null && to != null) {
                    pstmt.setTimestamp(index++, (Timestamp)to);
                } else if (from != null && to == null) {
                    pstmt.setTimestamp(index++, (Timestamp)from);
                } else if (from != null && to != null) {
                    pstmt.setTimestamp(index++, (Timestamp)from);
                    pstmt.setTimestamp(index++, (Timestamp)to);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(this.fAmtFrom) || !StringUtils.isEmpty(this.fAmtTo)) {
            from = null;
            to = null;
            try {
                from = new BigDecimal(this.fAmtFrom);
            }
            catch (Exception e) {
                from = null;
            }
            try {
                to = new BigDecimal(this.fAmtTo);
            }
            catch (Exception e) {
                to = null;
            }
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, "1".equals(this.fIsPaid) ? "Y" : "N");
        pstmt.setString(index++, "1".equals(this.fIsSOTrx) ? "Y" : "N");
    }

    private String getSQLText(String f) {
        String s = f.toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (!StringUtils.isEmpty(this.fDocumentNo)) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (!StringUtils.isEmpty(this.fDescription)) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (!StringUtils.isEmpty(this.fBPartner_ID)) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (!StringUtils.isEmpty(this.fOrder_ID)) {
            sql.append(" AND i.C_Order_ID=?");
        }
        if (!StringUtils.isEmpty(this.fDateFrom) || !StringUtils.isEmpty(this.fDateTo)) {
            try {
                from = null;
                to = null;
                try {
                    from = new Timestamp(this.wsc.dateFormat.parse(this.fDateFrom).getTime());
                }
                catch (Exception e) {
                    from = null;
                }
                try {
                    to = new Timestamp(this.wsc.dateFormat.parse(this.fDateTo).getTime());
                }
                catch (Exception e) {
                    to = null;
                }
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(i.DateOrdered,'DD') <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(i.DateOrdered,'DD') >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(i.DateOrdered,'DD') BETWEEN ? AND ?");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(this.fAmtFrom) || !StringUtils.isEmpty(this.fAmtTo)) {
            from = null;
            to = null;
            try {
                from = new BigDecimal(this.fAmtFrom);
            }
            catch (Exception e) {
                from = null;
            }
            try {
                to = new BigDecimal(this.fAmtTo);
            }
            catch (Exception e) {
                to = null;
            }
            if (from == null && to != null) {
                sql.append(" AND i.GrandTotal <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND i.GrandTotal >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND i.GrandTotal BETWEEN ? AND ?");
            }
        }
        sql.append(" AND i.IsPaid=? AND i.IsSOTrx=?");
        return sql.toString();
    }

    public void setQueryParas(WebSessionCtx wsc1, HttpServletRequest request) {
        this.fDocumentNo = request.getParameter("documentNo");
        this.fDescription = request.getParameter("description");
        this.fPOReference = request.getParameter("poReference");
        this.fBPartner_ID = request.getParameter("cbpartnerId");
        this.fDateFrom = request.getParameter("dateFrom");
        this.fDateTo = request.getParameter("dateTo");
        this.fAmtFrom = request.getParameter("amountFrom");
        this.fAmtTo = request.getParameter("amountTo");
        this.wsc = wsc1;
        this.fIsSOTrx = wsc1.ctx.isSOTrx(this.p_WindowNo) ? "1" : "0";
        this.fIsPaid = "on".equals(request.getParameter("isPaid")) ? "1" : "0";
        this.fOrder_ID = request.getParameter("orderId");
    }
}

