/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class InfoGeneral
extends Info {
    private Info_Column[] m_generalLayout;
    private ArrayList<String> m_queryColumns = new ArrayList();

    protected InfoGeneral(int WindowNo, String value, String tableName, String keyColumn, boolean multiSelection, String whereClause, Ctx ctx) {
        super(WindowNo, tableName, keyColumn, multiSelection, whereClause, ctx);
        this.log.info(tableName + " - " + keyColumn + " - " + whereClause);
        this.title = Msg.translate(ctx, "Info");
        this.statInit(ctx);
        String s = "";
        if (value != null && value.length() > 0) {
            s = value;
        }
        this.p_loadedOK = this.initInfo(ctx, s);
    }

    private void statInit(Ctx ctx) {
    }

    private boolean initInfo(Ctx ctx, String value) {
        if (!this.initInfoTable(ctx)) {
            return false;
        }
        StringBuffer where = new StringBuffer("IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(this.p_whereClause);
        }
        this.prepareTable(this.m_generalLayout, this.p_tableName, where.toString(), "2");
        this.componentList.add(new ComponentBean(Msg.translate(ctx, this.m_queryColumns.get(0).toString()), 1, "", "right", "middle", "", 0));
        this.componentMapping.put(this.m_queryColumns.get(0).toString(), new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, value, "left", "middle", "", 220));
        if (this.m_queryColumns.size() > 1) {
            this.componentList.add(new ComponentBean(Msg.translate(ctx, this.m_queryColumns.get(1).toString()), 1, "", "right", "middle", "", 0));
            this.componentMapping.put(this.m_queryColumns.get(1).toString(), new Integer(this.componentList.size()));
            this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        }
        this.componentList.add(new ComponentBean(0));
        if (this.m_queryColumns.size() > 2) {
            this.componentList.add(new ComponentBean(Msg.translate(ctx, this.m_queryColumns.get(2).toString()), 1, "", "right", "middle", "", 0));
            this.componentMapping.put(this.m_queryColumns.get(2).toString(), new Integer(this.componentList.size()));
            this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        }
        if (this.m_queryColumns.size() > 3) {
            this.componentList.add(new ComponentBean(Msg.translate(ctx, this.m_queryColumns.get(3).toString()), 1, "", "right", "middle", "", 0));
            this.componentMapping.put(this.m_queryColumns.get(3).toString(), new Integer(this.componentList.size()));
            this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        }
        return true;
    }

    private boolean initInfoTable(Ctx ctx) {
        String sql = "SELECT c.ColumnName, t.AD_Table_ID, t.TableName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID)WHERE c.AD_Reference_ID=10 AND t.TableName=? AND EXISTS (SELECT * FROM AD_Field f WHERE f.AD_Column_ID=c.AD_Column_ID AND f.IsDisplayed='Y' AND f.IsEncrypted='N' AND f.ObscureType IS NULL) ORDER BY c.IsIdentifier DESC, c.SeqNo";
        int AD_Table_ID = 0;
        String tableName = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, this.p_tableName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_queryColumns.add(rs.getString(1));
                if (AD_Table_ID != 0) continue;
                AD_Table_ID = rs.getInt(2);
                tableName = rs.getString(3);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return false;
        }
        if (this.m_queryColumns.size() == 0) {
            this.log.log(Level.SEVERE, "No query columns found");
            return false;
        }
        this.log.finest("Table " + tableName + ", ID=" + AD_Table_ID + ", QueryColumns #" + this.m_queryColumns.size());
        while (this.m_queryColumns.size() > 4) {
            this.m_queryColumns.remove(this.m_queryColumns.size() - 1);
        }
        String title = Msg.translate(ctx, tableName + "_ID");
        if (title.endsWith("_ID")) {
            title = Msg.translate(ctx, tableName);
        }
        this.title = this.title + " " + title;
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        sql = "SELECT c.ColumnName, c.AD_Reference_ID, c.IsKey, f.IsDisplayed, c.AD_Reference_Value_ID FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Tab tab ON (t.AD_Window_ID=tab.AD_Window_ID) INNER JOIN AD_Field f ON (tab.AD_Tab_ID=f.AD_Tab_ID AND f.AD_Column_ID=c.AD_Column_ID) WHERE t.AD_Table_ID=?  AND (c.IsKey='Y' OR  (f.IsEncrypted='N' AND f.ObscureType IS NULL)) ORDER BY c.IsKey DESC, f.SeqNo";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                int displayType = rs.getInt(2);
                boolean isKey = rs.getString(3).equals("Y");
                boolean isDisplayed = rs.getString(4).equals("Y");
                int AD_Reference_Value_ID = rs.getInt(5);
                StringBuffer colSql = new StringBuffer(columnName);
                Class colClass = null;
                if (isKey) {
                    colClass = IDColumn.class;
                } else if (isDisplayed) {
                    if (displayType == 20) {
                        colClass = Boolean.class;
                    } else if (displayType == 12) {
                        colClass = BigDecimal.class;
                    } else if (displayType == 22 || displayType == 29) {
                        colClass = Double.class;
                    } else if (displayType == 11) {
                        colClass = Integer.class;
                    } else if (displayType == 10 || displayType == 14 || displayType == 34) {
                        colClass = String.class;
                    } else if (DisplayType.isDate(displayType)) {
                        colClass = Timestamp.class;
                    } else if (displayType == 17) {
                        colSql = Env.isBaseLanguage(ctx, "AD_Ref_List") ? new StringBuffer("(SELECT l.Name FROM AD_Ref_List l WHERE l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value='").append(columnName).append("') AS ").append(columnName) : new StringBuffer("(SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value='").append(columnName).append("' AND t.AD_Language='").append(Env.getAD_Language(ctx)).append("') AS ").append(columnName);
                        colClass = String.class;
                    }
                }
                if (colClass != null) {
                    if (isKey) {
                        list.add(new Info_Column(Msg.translate(ctx, "Select"), colSql.toString(), colClass));
                    } else {
                        list.add(new Info_Column(Msg.translate(ctx, columnName), colSql.toString(), colClass));
                    }
                    this.log.finest("Added Column=" + columnName);
                    continue;
                }
                this.log.finest("Not Added Column=" + columnName);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return false;
        }
        if (list.size() == 0) {
            this.log.log(Level.SEVERE, "No Info for AD_Table_ID=" + AD_Table_ID + " - " + sql);
            return false;
        }
        this.log.finest("InfoColumns #" + list.size());
        this.m_generalLayout = new Info_Column[list.size()];
        list.toArray(this.m_generalLayout);
        this.columnAttrList = new ArrayList();
        this.columnAttrList.add(1);
        this.columnAttrList.add(1);
        for (int ii = 2; ii < this.m_generalLayout.length; ++ii) {
            this.columnAttrList.add(0);
        }
        return true;
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, this.m_queryColumns.get(0).toString());
        if (s != null) {
            this.addSQLWhere(sql, 0, s.toUpperCase());
        }
        if (this.m_queryColumns.size() > 1 && (s = this.getComponetValue(valueMapping, this.m_queryColumns.get(1).toString())) != null) {
            this.addSQLWhere(sql, 1, s.toUpperCase());
        }
        if (this.m_queryColumns.size() > 2 && (s = this.getComponetValue(valueMapping, this.m_queryColumns.get(2).toString())) != null) {
            this.addSQLWhere(sql, 2, s.toUpperCase());
        }
        if (this.m_queryColumns.size() > 3 && (s = this.getComponetValue(valueMapping, this.m_queryColumns.get(3).toString())) != null) {
            this.addSQLWhere(sql, 3, s.toUpperCase());
        }
        return sql.toString();
    }

    private void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && !value.equals("%") && index < this.m_queryColumns.size()) {
            sql.append(" AND UPPER(").append(this.m_queryColumns.get(index).toString()).append(") LIKE '");
            sql.append(value);
            if (value.endsWith("%")) {
                sql.append("'");
            } else {
                sql.append("%'");
            }
        }
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    protected String getSQLWhere() {
        if (this.p_sqlWhere != null && this.p_sqlWhere.length() > 0) {
            return this.p_sqlWhere;
        }
        return "";
    }

    public void setQueryParas(WebSessionCtx wsc1, HttpServletRequest request) {
    }
}

