/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;

class NTFListener
extends Thread {
    private NTFConnection[] connections = null;
    private int nbOfConnections = 0;
    private boolean needsToBeClosed = false;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:11_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    NTFListener(NTFManager nTFManager, ServerSocketChannel serverSocketChannel, int n2) {
        this.dcnManager = nTFManager;
        this.connections = new NTFConnection[10];
        this.ssChannel = serverSocketChannel;
        this.tcpport = n2;
    }

    public void run() {
        try {
            Selector selector = Selector.open();
            this.ssChannel.register(selector, 16);
            block2: while (true) {
                selector.select();
                if (this.needsToBeClosed) break;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    SelectionKey selectionKey = iterator.next();
                    if ((selectionKey.readyOps() & 0x10) != 16) continue;
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    NTFConnection nTFConnection = new NTFConnection(this.dcnManager, socketChannel);
                    if (this.connections.length == this.nbOfConnections) {
                        NTFConnection[] nTFConnectionArray = new NTFConnection[this.connections.length * 2];
                        System.arraycopy(this.connections, 0, nTFConnectionArray, 0, this.connections.length);
                        this.connections = nTFConnectionArray;
                    }
                    this.connections[this.nbOfConnections++] = nTFConnection;
                    nTFConnection.start();
                    iterator.remove();
                }
                break;
            }
            selector.close();
            this.ssChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void closeThisListener() {
        for (int i2 = 0; i2 < this.nbOfConnections; ++i2) {
            this.connections[i2].closeThisConnection();
            this.connections[i2].interrupt();
        }
        this.needsToBeClosed = true;
    }
}

