/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.Writer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.taglibs.standard.tag.el.core.ExpressionUtil;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.HtmlCode;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wstore.JSPEnv;

public class LocationTag
extends TagSupport {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private String m_countryID_el;
    private String m_regionID_el;
    private String m_regionName_el;
    private String m_city_el;
    private String m_postal_el;
    private MCountry m_country;
    private static final String C_MANDATORY = "mandatory";
    private static final String C_ERROR = "error";

    public void setCountryID(String info_el) {
        this.m_countryID_el = info_el;
    }

    public void setRegionID(String info_el) {
        this.m_regionID_el = info_el;
    }

    public void setRegionName(String info_el) {
        this.m_regionName_el = info_el;
    }

    public void setCity(String info_el) {
        this.m_city_el = info_el;
    }

    public void setPostal(String info_el) {
        this.m_postal_el = info_el;
    }

    private int getCountryID(MLocation loc) {
        int C_Country_ID = 0;
        try {
            String info = (String)ExpressionUtil.evalNotNull((String)"location", (String)"countryID", (String)this.m_countryID_el, String.class, (Tag)this, (PageContext)this.pageContext);
            if (info != null && info.length() != 0) {
                C_Country_ID = Integer.parseInt(info);
            }
        }
        catch (Exception e) {
            this.log.severe("Country - " + e);
        }
        if (C_Country_ID == 0) {
            C_Country_ID = loc.getC_Country_ID();
        }
        return C_Country_ID;
    }

    private int getRegionID(MLocation loc) {
        int C_Region_ID = 0;
        try {
            String info = (String)ExpressionUtil.evalNotNull((String)"location", (String)"regionID", (String)this.m_regionID_el, String.class, (Tag)this, (PageContext)this.pageContext);
            if (info != null && info.length() != 0) {
                C_Region_ID = Integer.parseInt(info);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "RegionID - " + e);
        }
        if (C_Region_ID == 0) {
            C_Region_ID = loc.getC_Region_ID();
        }
        return C_Region_ID;
    }

    public int doStartTag() throws JspException {
        Ctx ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        MLocation loc = new MLocation(ctx, 0, null);
        HtmlCode html = new HtmlCode();
        int C_Country_ID = this.getCountryID(loc);
        int C_Region_ID = this.getRegionID(loc);
        option[] countries = this.getCountries(loc, C_Country_ID);
        String name = null;
        label lbl = null;
        input field = null;
        select sel = null;
        name = "City";
        String city = (String)ExpressionUtil.evalNotNull((String)"location", (String)"city", (String)this.m_city_el, String.class, (Tag)this, (PageContext)this.pageContext);
        lbl = new label();
        lbl.setFor(name);
        lbl.setID("LBL_" + name);
        lbl.addElement(Msg.translate(ctx, name));
        html.addElement((Element)lbl);
        field = new input("text", name, city);
        field.setSize(40).setMaxlength(60).setID("ID_" + name);
        field.setClass(C_MANDATORY);
        html.addElement((Element)field);
        html.addElement((Element)new br());
        name = "Postal";
        String postal = (String)ExpressionUtil.evalNotNull((String)"location", (String)"postal", (String)this.m_postal_el, String.class, (Tag)this, (PageContext)this.pageContext);
        lbl = new label();
        lbl.setFor(name);
        lbl.setID("LBL_" + name);
        lbl.addElement(Msg.translate(ctx, name));
        html.addElement((Element)lbl);
        field = new input("text", name, postal);
        field.setSize(10).setMaxlength(10).setID("ID_" + name);
        field.setClass(C_MANDATORY);
        html.addElement((Element)field);
        html.addElement((Element)new br());
        name = "C_Region_ID";
        lbl = new label();
        lbl.setFor(name);
        lbl.setID("LBL_" + name);
        String regionName = (String)ExpressionUtil.evalNotNull((String)"location", (String)"regionName", (String)this.m_regionName_el, String.class, (Tag)this, (PageContext)this.pageContext);
        field = new input("text", "RegionName", regionName);
        field.setSize(40).setMaxlength(60).setID("ID_RegionName");
        if (this.m_country != null && this.m_country.isHasRegion()) {
            sel = new select(name, this.getRegions(loc, C_Country_ID, C_Region_ID));
            sel.setID("ID_" + name);
            lbl.addElement(Msg.translate(ctx, this.m_country.getRegionName()));
            html.addElement((Element)lbl);
            html.addElement((Element)sel);
            html.addElement((Element)new span(" - "));
            html.addElement((Element)field);
        } else {
            lbl.addElement(Msg.translate(ctx, name));
            html.addElement((Element)lbl);
            html.addElement((Element)field);
        }
        html.addElement((Element)new br());
        name = "C_Country_ID";
        lbl = new label();
        lbl.setFor(name);
        lbl.setID("LBL_" + name);
        lbl.addElement(Msg.translate(ctx, name));
        html.addElement((Element)lbl);
        sel = new select(name, countries);
        sel.setID("ID_" + name);
        sel.setClass(C_MANDATORY);
        sel.setOnChange("changeCountry('ID_" + name + "');");
        html.addElement((Element)sel);
        html.addElement((Element)new br());
        this.log.fine("C_Country_ID=" + C_Country_ID + ", C_Region_ID=" + C_Region_ID + ", RegionName=" + regionName + ", City=" + city + ", Postal=" + postal);
        JspWriter out = this.pageContext.getOut();
        html.output((Writer)out);
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    private option[] getCountries(MLocation loc, int C_Country_ID) {
        MCountry[] countries = MCountry.getCountries(loc.getCtx());
        option[] options = new option[countries.length];
        this.m_country = null;
        for (int i = 0; i < countries.length; ++i) {
            options[i] = new option(String.valueOf(countries[i].getC_Country_ID()));
            options[i].addElement(Util.maskHTML(countries[i].getName()));
            if (countries[i].getC_Country_ID() != C_Country_ID) continue;
            this.m_country = countries[i];
            options[i].setSelected(true);
        }
        return options;
    }

    private option[] getRegions(MLocation loc, int C_Country_ID, int C_Region_ID) {
        MRegion[] regions = MRegion.getRegions(loc.getCtx(), C_Country_ID);
        option[] options = new option[regions.length + 1];
        options[0] = new option("0");
        options[0].addElement(" ");
        for (int i = 0; i < regions.length; ++i) {
            options[i + 1] = new option(String.valueOf(regions[i].getC_Region_ID()));
            options[i + 1].addElement(regions[i].getName());
            if (regions[i].getC_Region_ID() != C_Region_ID) continue;
            options[i + 1].setSelected(true);
        }
        return options;
    }
}

