/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.udf;

import COM.ibm.db2.app.UDF;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Compiere
extends UDF
implements Serializable {
    private static Compiere cInst = null;
    public static final String TYPE_ORACLE = "oracle";
    public static final String TYPE_DB2 = "db2";
    public static String s_type = "db2";
    protected static String s_url = null;
    protected static String s_uid = null;
    protected static String s_pwd = null;
    private Connection s_conn = null;
    private Connection s_conn1 = null;
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    public static final BigDecimal ONE = new BigDecimal(1.0);
    public static final BigDecimal HUNDRED = new BigDecimal(100.0);
    public static final String TRUNC_DAY = "DD";
    public static final String TRUNC_WEEK = "DY";
    public static final String TRUNC_MONTH = "MM";
    public static final String TRUNC_QUARTER = "Q";
    public static final String TRUNC_YEAR = "Y";

    public static Compiere getInstance() {
        return new Compiere();
    }

    public static String getVersion() {
        return "Compiere SQLJ 1.0";
    }

    public static String getProperties() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = ((Hashtable)System.getProperties()).keys();
        while (en.hasMoreElements()) {
            if (sb.length() != 0) {
                sb.append(" - ");
            }
            String key = (String)en.nextElement();
            String value = System.getProperty(key);
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getProperty(String key) throws SQLException {
        if (key == null || key.length() == 0) {
            return "null";
        }
        return System.getProperty(key, "NotFound");
    }

    public static String getServerType() {
        if (s_type == null) {
            String vendor = System.getProperty("java.vendor");
            s_type = vendor.startsWith("Oracle") ? TYPE_ORACLE : (vendor.startsWith("IBM") ? TYPE_DB2 : "??");
        }
        return s_type;
    }

    static boolean isOracle() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_ORACLE.equals(s_type);
        }
        return false;
    }

    static boolean isDB2() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_DB2.equals(s_type);
        }
        return false;
    }

    static String getConnectionURL() {
        if (s_url != null) {
            return s_url;
        }
        s_url = "jdbc:default:connection:";
        if (Compiere.isDB2()) {
            s_url = "jdbc:default:connection";
        }
        return s_url;
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetCurrency) throws SQLException {
        BigDecimal bigDecimal = ONE;
        synchronized (bigDecimal) {
            try {
                if (this.s_conn == null) {
                    this.s_conn = this.getConnection();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (this.s_conn != null) {
                PreparedStatement ps = this.s_conn.prepareStatement(sql, resultSetType, resultSetCurrency);
                this.s_conn1 = null;
                return ps;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        bigDecimal = ONE;
        synchronized (bigDecimal) {
            if (this.s_conn1 != null) {
                this.s_conn = this.s_conn1;
                this.s_conn1 = null;
            } else {
                try {
                    this.s_conn = this.getConnection();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return this.s_conn.prepareStatement(sql);
    }

    int getSQLValue(String sql, int param1) throws SQLException {
        int retValue = -1;
        PreparedStatement pstmt = this.prepareStatement(sql);
        pstmt.setInt(1, param1);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            retValue = rs.getInt(1);
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public static void setConnection(Connection conn) {
        Compiere c = Compiere.getInstance();
        c.setConnection(conn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(Connection conn, int sig) {
        if (!(conn instanceof Connection)) {
            return;
        }
        BigDecimal bigDecimal = ONE;
        synchronized (bigDecimal) {
            if (this.s_conn != null) {
                if (this.s_conn == conn) {
                    return;
                }
                if (this.s_conn1 == null) {
                    this.s_conn1 = conn;
                }
            } else {
                this.s_conn = conn;
            }
        }
    }

    public static Timestamp trunc(Timestamp dayTime, String trunc) {
        if (dayTime == null) {
            dayTime = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(dayTime.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        if (trunc == null || trunc.equals(TRUNC_DAY)) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals(TRUNC_WEEK)) {
            cal.set(7, cal.getFirstDayOfWeek());
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(5, 1);
        if (trunc.equals(TRUNC_MONTH)) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals(TRUNC_QUARTER)) {
            int mm = cal.get(2);
            mm = mm < 4 ? 1 : (mm < 7 ? 4 : (mm < 10 ? 7 : 10));
            cal.set(2, mm);
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(6, 1);
        return new Timestamp(cal.getTimeInMillis());
    }

    protected static Timestamp trunc(Timestamp t) {
        return Compiere.trunc(t, TRUNC_DAY);
    }

    public static Timestamp firstOf(Timestamp p_dateTime, String XX) {
        Timestamp time = p_dateTime;
        if (time == null) {
            time = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (TRUNC_MONTH.equals(XX)) {
            cal.set(5, 1);
        } else if (TRUNC_WEEK.equals(XX)) {
            cal.set(7, 1);
        } else if (TRUNC_QUARTER.equals(XX)) {
            cal.set(5, 1);
            int mm = cal.get(2);
            if (mm < 3) {
                cal.set(2, 0);
            } else if (mm < 6) {
                cal.set(2, 3);
            } else if (mm < 9) {
                cal.set(2, 6);
            } else {
                cal.set(2, 9);
            }
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static int getDaysBetween(Timestamp start, Timestamp end) {
        boolean negative = false;
        if (start == null && end == null) {
            return 0;
        }
        if (start == null) {
            start = new Timestamp(new Date().getTime());
        }
        if (end == null) {
            end = new Timestamp(new Date().getTime());
        }
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(6) - cal.get(6)) * -1;
            }
            return calEnd.get(6) - cal.get(6);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(6, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public static Timestamp addDays(Timestamp day, int offset) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset != 0) {
            cal.add(6, offset);
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static Timestamp nextBusinessDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dow = cal.get(7);
        if (dow == 7) {
            cal.add(6, 2);
        } else if (dow == 1) {
            cal.add(6, 1);
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static String charAt(String source, int posIndex) {
        if (source == null || source.length() == 0 || posIndex < 0 || posIndex >= source.length()) {
            return null;
        }
        try {
            return source.substring(posIndex + 1, posIndex + 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int nextID(int AD_Sequence_ID, String System2) throws SQLException, Exception {
        boolean isSystem = System2 != null && TRUNC_YEAR.equals(System2);
        int retValue = -1;
        StringBuffer sql = new StringBuffer("SELECT CurrentNext");
        if (isSystem) {
            sql.append("Sys");
        }
        sql.append(",IncrementNo FROM AD_Sequence WHERE AD_Sequence_ID=? FOR UPDATE");
        PreparedStatement pstmt = this.prepareStatement(sql.toString(), 1003, 1008);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            retValue = rs.getInt(1);
            int incrementNo = rs.getInt(2);
            rs.updateInt(2, retValue += incrementNo);
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public void ProcNextID(int AD_Sequence_ID, String System2, int[] retVal) throws SQLException, Exception {
        retVal[0] = this.nextID(AD_Sequence_ID, System2);
    }

    public static Timestamp getDate() {
        return new Timestamp(new Date().getTime());
    }

    public static String getChars(BigDecimal d) {
        if (d == null) {
            return "0";
        }
        String s = d.toString();
        int i = s.indexOf(46);
        boolean non0 = false;
        if (i != -1) {
            for (int j = i + 1; j < s.length(); ++j) {
                if (s.charAt(j) == '0') continue;
                non0 = true;
                break;
            }
        }
        if (!non0) {
            s = s.substring(0, i);
        }
        if (s == null || s.length() == 0) {
            return "0";
        }
        return s;
    }

    public static String Time2Chars(Timestamp t) {
        if (t == null) {
            return "";
        }
        return t.toString();
    }
}

