/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmTable;
import org.jboss.monitor.alarm.AlarmTableNotification;
import org.jboss.monitor.alarm.MBeanImplAccess;
import org.jboss.monitor.services.ActiveAlarmTableMBean;
import org.jboss.system.ListenerServiceMBeanSupport;

public class ActiveAlarmTable
extends ListenerServiceMBeanSupport
implements ActiveAlarmTableMBean {
    private SynchronizedLong notificationCount;
    AlarmTable almtab = new AlarmTable(new MBeanImplAccess(){

        public ObjectName getMBeanName() {
            return ActiveAlarmTable.this.getServiceName();
        }

        public long getSequenceNumber() {
            return ActiveAlarmTable.this.getNextNotificationSequenceNumber();
        }

        public void emitNotification(Notification n) {
            ActiveAlarmTable.this.sendNotification(n);
        }
    });

    public ActiveAlarmTable() {
        this.notificationCount = new SynchronizedLong(0L);
        this.almtab.setServerId("jboss");
    }

    public long getNotificationsProcessed() {
        return this.notificationCount.get();
    }

    public void setServerId(String serverId) {
        if (serverId != null) {
            this.almtab.setServerId(serverId);
        }
    }

    public String getServerId() {
        return this.almtab.getServerId();
    }

    public int acknowledgeAll(String user, String system) {
        AlarmTableNotification[] atns = this.almtab.getAlarmTable();
        int acked = 0;
        for (int i = 0; i < atns.length; ++i) {
            AlarmTableNotification atn = atns[i];
            if (!this.almtab.acknowledge(atn.createKey(), user, system)) continue;
            ++acked;
        }
        return acked;
    }

    public int unacknowledgeAll(String user, String system) {
        AlarmTableNotification[] atns = this.almtab.getAlarmTable();
        int unacked = 0;
        for (int i = 0; i < atns.length; ++i) {
            AlarmTableNotification atn = atns[i];
            if (!this.almtab.unacknowledge(atn.createKey(), user, system)) continue;
            ++unacked;
        }
        return unacked;
    }

    public boolean acknowledge(String serverId, String source, String type, String user, String system) {
        return this.almtab.acknowledge(serverId, source, type, user, system);
    }

    public boolean unacknowledge(String serverId, String source, String type, String user, String system) {
        return this.almtab.unacknowledge(serverId, source, type, user, system);
    }

    public AlarmTableNotification[] fetchAlarmTable() {
        return this.almtab.getAlarmTable();
    }

    public String fetchAlarmTableAsHtml() {
        AlarmTableNotification[] tab = this.almtab.getAlarmTable();
        StringBuffer sbuf = new StringBuffer(8192);
        sbuf.append("<table border=\"1\">").append("\n");
        sbuf.append("<tr>");
        sbuf.append("<td></td>");
        sbuf.append("<td>serverId</td>");
        sbuf.append("<td>source</td>");
        sbuf.append("<td>type</td>");
        sbuf.append("<td>alarmState</td>");
        sbuf.append("<td>severity</td>");
        sbuf.append("<td>timeStamp</td>");
        sbuf.append("<td>sequenceNumber</td>");
        sbuf.append("<td>message</td>");
        sbuf.append("<td>userData</td>");
        sbuf.append("<td>ackState</td>");
        sbuf.append("<td>ackTime</td>");
        sbuf.append("<td>ackUser</td>");
        sbuf.append("<td>ackSystem</td");
        sbuf.append("</tr>").append("\n");
        for (int i = 0; i < tab.length; ++i) {
            AlarmTableNotification atn = tab[i];
            Notification n = (Notification)atn.getUserData();
            sbuf.append("<tr>");
            sbuf.append("<td>").append(i).append("</td>");
            sbuf.append("<td>").append(atn.getServerId()).append("</td>");
            sbuf.append("<td>").append(n.getSource()).append("</td>");
            sbuf.append("<td>").append(n.getType()).append("</td>");
            sbuf.append("<td>").append(Alarm.STATE_STRINGS[atn.getAlarmState()]).append("</td>");
            sbuf.append("<td>").append(Alarm.SEVERITY_STRINGS[atn.getSeverity()]).append("</td>");
            sbuf.append("<td>").append(n.getTimeStamp()).append("</td>");
            sbuf.append("<td>").append(n.getSequenceNumber()).append("</td>");
            sbuf.append("<td>").append(n.getMessage()).append("</td>");
            sbuf.append("<td>").append(n.getUserData()).append("</td>");
            sbuf.append("<td>").append(atn.getAckState()).append("</td>");
            sbuf.append("<td>").append(atn.getAckTime()).append("</td>");
            sbuf.append("<td>").append(atn.getAckUser()).append("</td>");
            sbuf.append("<td>").append(atn.getAckSystem()).append("</td");
            sbuf.append("</tr>").append("\n");
        }
        sbuf.append("</table>").append("\n");
        return sbuf.toString();
    }

    public void startService() throws Exception {
        super.subscribe(true);
    }

    public void stopService() throws Exception {
        super.unsubscribe();
    }

    public void handleNotification2(Notification notification, Object handback) {
        this.log.info((Object)("Got notification (#" + Long.toString(this.notificationCount.increment()) + "): " + notification + ", handback: " + handback));
        this.almtab.update(notification);
    }
}

