/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import javax.management.Notification;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmKey;
import org.jboss.monitor.alarm.AlarmNotification;

public class AlarmTableNotification
extends AlarmNotification {
    public static final String ALARM_TABLE_UPDATE = "jboss.alarm.table.update";
    private String serverId;
    private boolean ackState;
    private long ackTime;
    private String ackUser;
    private String ackSystem;
    static /* synthetic */ Class class$org$jboss$monitor$alarm$AlarmTableNotification;

    public AlarmTableNotification(String type, Object source, long sequenceNumber, long timeStamp, String message, int alarmState, int severity, String serverId) {
        super(type, source, sequenceNumber, timeStamp, message, alarmState, severity);
        this.serverId = serverId;
    }

    public AlarmTableNotification(AlarmTableNotification atn) {
        super(atn.getType(), atn.getSource(), atn.getSequenceNumber(), atn.getTimeStamp(), atn.getMessage(), atn.getAlarmState(), atn.getSeverity());
        this.setUserData(atn.getUserData());
        this.serverId = atn.serverId;
        this.ackState = atn.ackState;
        this.ackTime = atn.ackTime;
        this.ackUser = atn.ackUser;
        this.ackSystem = atn.ackSystem;
    }

    public String getServerId() {
        return this.serverId;
    }

    public boolean getAckState() {
        return this.ackState;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public String getAckUser() {
        return this.ackUser;
    }

    public String getAckSystem() {
        return this.ackSystem;
    }

    public void setAckParams(boolean ackState, long ackTime, String ackUser, String ackSystem) {
        this.ackState = ackState;
        this.ackTime = ackTime;
        this.ackUser = ackUser;
        this.ackSystem = ackSystem;
    }

    public Object createKey() {
        Notification n = (Notification)this.getUserData();
        return AlarmKey.createKey(this.serverId, n.getSource(), n.getType());
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append((class$org$jboss$monitor$alarm$AlarmTableNotification == null ? (class$org$jboss$monitor$alarm$AlarmTableNotification = AlarmTableNotification.class$("org.jboss.monitor.alarm.AlarmTableNotification")) : class$org$jboss$monitor$alarm$AlarmTableNotification).getName());
        sbuf.append(" [ source=").append(this.getSource());
        sbuf.append(", type=").append(this.getType());
        sbuf.append(", sequenceNumber=").append(this.getSequenceNumber());
        sbuf.append(", timeStamp=").append(this.getTimeStamp());
        sbuf.append(", message=").append(this.getMessage());
        sbuf.append(", userData={").append(this.getUserData());
        sbuf.append("}, alarmState=").append(Alarm.STATE_STRINGS[this.getAlarmState()]);
        sbuf.append(", severity=").append(Alarm.SEVERITY_STRINGS[this.getSeverity()]);
        sbuf.append(", serverId=").append(this.serverId);
        sbuf.append(", ackState=").append(this.ackState);
        sbuf.append(", ackTime=").append(this.ackTime);
        sbuf.append(", ackUser=").append(this.ackUser);
        sbuf.append(", ackSystem=").append(this.ackSystem);
        sbuf.append(" ]");
        return sbuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

