/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.monitor;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.monitor.ThresholdMonitor;
import org.jboss.mx.util.MBeanServerLocator;

public class CreateThresholdMonitorServlet
extends HttpServlet {
    static final long serialVersionUID = -6186767543219177309L;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$console$plugins$monitor$CreateThresholdMonitorServlet == null ? (class$org$jboss$console$plugins$monitor$CreateThresholdMonitorServlet = CreateThresholdMonitorServlet.class$("org.jboss.console.plugins.monitor.CreateThresholdMonitorServlet")) : class$org$jboss$console$plugins$monitor$CreateThresholdMonitorServlet));
    static /* synthetic */ Class class$org$jboss$console$plugins$monitor$CreateThresholdMonitorServlet;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void error(String msg, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("error", (Object)("Error: " + msg));
        req.getRequestDispatcher("/createThresholdMonitor.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doit(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String monitorName = req.getParameter("monitorName").trim();
        log.debug((Object)monitorName);
        String objectName = req.getParameter("objectName").trim();
        log.debug((Object)objectName);
        MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
        ObjectName oname = null;
        try {
            oname = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            this.error("Malformed ObjectName ", req, resp);
            return;
        }
        String attribute = req.getParameter("attribute").trim();
        log.debug((Object)attribute);
        Object val = null;
        try {
            val = mbeanServer.getAttribute(oname, attribute);
        }
        catch (Exception e) {
            this.error("Unable to pull attribute value from MBean, does the attribute exist? ", req, resp);
            return;
        }
        String threshold = req.getParameter("threshold").trim();
        log.debug((Object)threshold);
        boolean enabled = req.getParameter("enabled") != null;
        log.debug((Object)("Enabled: " + enabled));
        boolean persisted = req.getParameter("persisted") != null;
        log.debug((Object)("Persisted: " + persisted));
        String period = req.getParameter("period").trim();
        log.debug((Object)period);
        long timePeriod = 0L;
        try {
            timePeriod = Long.parseLong(period);
        }
        catch (NumberFormatException e) {
            this.error("Illegal format for watch period.", req, resp);
            return;
        }
        String compare = req.getParameter("compare").trim();
        log.debug((Object)compare);
        String[] alerts = req.getParameterValues("alerts");
        if (alerts == null) {
            this.error("you must select at least one alert listener", req, resp);
            return;
        }
        int compareTo = 0;
        if ("gt".equals(compare)) {
            compareTo = -1;
        } else if ("lt".equals(compare)) {
            compareTo = 1;
        } else if ("eq".equals(compare)) {
            compareTo = 0;
        }
        if (persisted) {
            try {
                Object[] args = new Object[]{"monitors", monitorName, "-service.xml"};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                Object rtn = mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "isStored", args, signature);
                if (((Boolean)rtn).booleanValue()) {
                    this.error("Monitor with this name already exists", req, resp);
                    return;
                }
            }
            catch (Exception ex) {
                this.error("Failed to determine if monitor with that name already exists: " + ex.toString(), req, resp);
                return;
            }
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xml.append("<server>\n");
            xml.append("<mbean code=\"org.jboss.monitor.ThresholdMonitor\"\n");
            xml.append("       name=\"jboss.monitor:service=" + monitorName.replace(' ', '_') + "\">\n");
            xml.append("  <attribute name=\"MonitorName\">" + monitorName + "</attribute>\n");
            try {
                if (mbeanServer.isInstanceOf(oname, "org.jboss.system.ServiceMBean")) {
                    xml.append("  <depends optional-attribute-name=\"ObservedObject\">" + objectName + "</depends>\n");
                } else {
                    xml.append("  <attribute name=\"ObservedObject\">" + objectName + "</attribute>\n");
                }
            }
            catch (Exception ex) {
                this.error("failed creating service: " + ex.toString(), req, resp);
                return;
            }
            xml.append("  <attribute name=\"ObservedAttribute\">" + attribute + "</attribute>\n");
            xml.append("  <depends-list optional-attribute-name=\"AlertListeners\">\n");
            for (int i = 0; i < alerts.length; ++i) {
                xml.append("      <depends-list-element>");
                xml.append(alerts[i].trim());
                xml.append("      </depends-list-element>\n");
            }
            xml.append("  </depends-list>\n");
            xml.append("  <attribute name=\"Threshold\">" + threshold + "</attribute>\n");
            xml.append("  <attribute name=\"Period\">" + timePeriod + "</attribute>\n");
            xml.append("  <attribute name=\"CompareTo\">" + compareTo + "</attribute>\n");
            xml.append("  <attribute name=\"Enabled\">" + enabled + "</attribute>\n");
            xml.append("</mbean>\n</server>");
            try {
                Object[] args = new Object[]{"monitors", monitorName, "-service.xml", xml.toString(), Boolean.TRUE};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "boolean"};
                mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "store", args, signature);
            }
            catch (Exception ex) {
                this.error("Failed to create persisted file: " + ex.toString(), req, resp);
                return;
            }
        }
        try {
            ThresholdMonitor monitor = new ThresholdMonitor();
            monitor.setMonitorName(monitorName);
            monitor.setObservedObject(oname);
            monitor.setObservedAttribute(attribute);
            monitor.setThreshold(threshold);
            monitor.setEnabled(new Boolean(enabled).booleanValue());
            monitor.setPeriod(timePeriod);
            monitor.setCompareTo(compareTo);
            ArrayList<ObjectName> list = new ArrayList<ObjectName>();
            for (int i = 0; i < alerts.length; ++i) {
                list.add(new ObjectName(alerts[i]));
            }
            monitor.setAlertListeners(list);
            mbeanServer.registerMBean(monitor, new ObjectName("jboss.monitor:name=" + monitorName));
            monitor.create();
            monitor.start();
        }
        catch (Exception ex) {
            this.error("Failed to create non-persisted monitor: " + ex.toString(), req, resp);
        }
        req.getRequestDispatcher("/createThresholdMonitorSummary.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

