/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class SimpleLookupTable
implements Cloneable {
    public Object[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    public int threshold;

    public SimpleLookupTable() {
        this(13);
    }

    public SimpleLookupTable(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.5f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new Object[extraRoom];
        this.valueTable = new Object[extraRoom];
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLookupTable result = (SimpleLookupTable)super.clone();
        result.elementSize = this.elementSize;
        result.threshold = this.threshold;
        int length = this.keyTable.length;
        result.keyTable = new Object[length];
        System.arraycopy(this.keyTable, 0, result.keyTable, 0, length);
        length = this.valueTable.length;
        result.valueTable = new Object[length];
        System.arraycopy(this.valueTable, 0, result.valueTable, 0, length);
        return result;
    }

    public boolean containsKey(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                return true;
            }
            if (++index != length) continue;
            index = 0;
        }
        return false;
    }

    public Object get(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    public Object keyForValue(Object valueToMatch) {
        if (valueToMatch != null) {
            int i2 = 0;
            int l = this.keyTable.length;
            while (i2 < l) {
                if (this.keyTable[i2] != null && valueToMatch.equals(this.valueTable[i2])) {
                    return this.keyTable[i2];
                }
                ++i2;
            }
        }
        return null;
    }

    public Object put(Object key, Object value) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    public Object removeKey(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                --this.elementSize;
                Object oldValue = this.valueTable[index];
                this.keyTable[index] = null;
                this.valueTable[index] = null;
                if (this.keyTable[index + 1 == length ? 0 : index + 1] != null) {
                    this.rehash();
                }
                return oldValue;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    public void removeValue(Object valueToRemove) {
        boolean rehash = false;
        int i2 = 0;
        int l = this.valueTable.length;
        while (i2 < l) {
            Object value = this.valueTable[i2];
            if (value != null && value.equals(valueToRemove)) {
                --this.elementSize;
                this.keyTable[i2] = null;
                this.valueTable[i2] = null;
                if (!rehash && this.keyTable[i2 + 1 == l ? 0 : i2 + 1] != null) {
                    rehash = true;
                }
            }
            ++i2;
        }
        if (rehash) {
            this.rehash();
        }
    }

    private void rehash() {
        SimpleLookupTable newLookupTable = new SimpleLookupTable(this.elementSize * 2);
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            Object currentKey = this.keyTable[i2];
            if (currentKey == null) continue;
            newLookupTable.put(currentKey, this.valueTable[i2]);
        }
        this.keyTable = newLookupTable.keyTable;
        this.valueTable = newLookupTable.valueTable;
        this.elementSize = newLookupTable.elementSize;
        this.threshold = newLookupTable.threshold;
    }

    public String toString() {
        String s2 = "";
        int i2 = 0;
        int l = this.valueTable.length;
        while (i2 < l) {
            Object object2 = this.valueTable[i2];
            if (object2 != null) {
                s2 = String.valueOf(s2) + this.keyTable[i2].toString() + " -> " + object2.toString() + "\n";
            }
            ++i2;
        }
        return s2;
    }
}

