/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class ProblemHandler
implements ProblemSeverities {
    public static final String[] NoArgument = new String[0];
    public final IErrorHandlingPolicy policy;
    public final IProblemFactory problemFactory;
    public final CompilerOptions options;

    public ProblemHandler(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        this.policy = policy;
        this.problemFactory = problemFactory;
        this.options = options;
    }

    public int computeSeverity(int problemId) {
        return 1;
    }

    public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber) {
        return this.problemFactory.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        if (severity == -1) {
            return;
        }
        if (referenceContext == null) {
            if ((severity & 1) != 0) {
                IProblem problem = this.createProblem(null, problemId, problemArguments, messageArguments, severity, 0, 0, 0);
                throw new AbortCompilation(null, problem);
            }
            return;
        }
        IProblem problem = this.createProblem(unitResult.getFileName(), problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, problemStartPosition >= 0 ? ProblemHandler.searchLineNumber(unitResult.lineSeparatorPositions, problemStartPosition) : 0);
        if (problem == null) {
            return;
        }
        switch (severity & 1) {
            case 1: {
                this.record(problem, unitResult, referenceContext);
                referenceContext.tagAsHavingErrors();
                int abortLevel = this.policy.stopOnFirstError() ? 2 : severity & 0x1E;
                if (abortLevel == 0) break;
                referenceContext.abort(abortLevel, problem);
                break;
            }
            case 0: {
                this.record(problem, unitResult, referenceContext);
            }
        }
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        this.handle(problemId, problemArguments, messageArguments, this.computeSeverity(problemId), problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }

    public void record(IProblem problem, CompilationResult unitResult, ReferenceContext referenceContext) {
        unitResult.record(problem, referenceContext);
    }

    public static final int searchLineNumber(int[] startLineIndexes, int position) {
        if (startLineIndexes == null) {
            return 1;
        }
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g2 = 0;
        int d2 = length - 1;
        int m = 0;
        while (g2 <= d2) {
            m = (g2 + d2) / 2;
            if (position < startLineIndexes[m]) {
                d2 = m - 1;
                continue;
            }
            if (position > startLineIndexes[m]) {
                g2 = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }
}

