/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    ReferenceBinding genericType;
    int rank;
    public TypeBinding bound;
    public TypeBinding[] otherBounds;
    char[] genericSignature;
    public int boundKind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;

    public WildcardBinding(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind, LookupEnvironment environment) {
        this.genericType = genericType;
        this.rank = rank;
        this.boundKind = boundKind;
        this.modifiers = 0x40000001;
        this.environment = environment;
        this.initialize(genericType, bound, otherBounds);
        if (genericType instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)genericType).addWrapper(this);
        }
        if (bound instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)bound).addWrapper(this);
        }
        this.tagBits |= 0x1000000L;
    }

    public int kind() {
        return 516;
    }

    public boolean boundCheck(TypeBinding argumentType) {
        switch (this.boundKind) {
            case 0: {
                return true;
            }
            case 1: {
                if (argumentType.isCompatibleWith(this.bound)) {
                    return true;
                }
                int i2 = 0;
                int length = this.otherBounds == null ? 0 : this.otherBounds.length;
                while (i2 < length) {
                    if (argumentType.isCompatibleWith(this.otherBounds[i2])) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
        }
        return argumentType.isCompatibleWith(this.bound);
    }

    public boolean canBeInstantiated() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectSubstitutes(Scope scope, TypeBinding otherType, Map substitutes, int constraint) {
        block61: {
            if ((this.tagBits & 0x20000000L) == 0L) {
                return;
            }
            if (otherType == NullBinding) {
                return;
            }
            if (otherType.isCapture()) {
                CaptureBinding capture = (CaptureBinding)otherType;
                otherType = capture.wildcard;
            }
            block0 : switch (constraint) {
                case 1: {
                    WildcardBinding otherWildcard;
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (otherType.isWildcard()) {
                                otherWildcard = (WildcardBinding)otherType;
                                switch (otherWildcard.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 1);
                                        int i2 = 0;
                                        int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                        while (i2 < length) {
                                            this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i2], substitutes, 1);
                                            ++i2;
                                        }
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                            this.bound.collectSubstitutes(scope, otherType, substitutes, 1);
                            return;
                        }
                        case 2: {
                            if (otherType.isWildcard()) {
                                otherWildcard = (WildcardBinding)otherType;
                                switch (otherWildcard.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        return;
                                    }
                                    case 2: {
                                        this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 2);
                                        int i3 = 0;
                                        int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                        while (i3 < length) {
                                            this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i3], substitutes, 2);
                                            ++i3;
                                        }
                                        return;
                                    }
                                }
                                return;
                            }
                            this.bound.collectSubstitutes(scope, otherType, substitutes, 2);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 0: {
                    WildcardBinding otherWildcard;
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (!otherType.isWildcard()) return;
                            otherWildcard = (WildcardBinding)otherType;
                            switch (otherWildcard.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 0);
                                    int i4 = 0;
                                    int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                    while (i4 < length) {
                                        this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i4], substitutes, 0);
                                        ++i4;
                                    }
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        case 2: {
                            if (!otherType.isWildcard()) return;
                            otherWildcard = (WildcardBinding)otherType;
                            switch (otherWildcard.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 0);
                                    int i5 = 0;
                                    int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                    while (i5 < length) {
                                        this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i5], substitutes, 0);
                                        ++i5;
                                    }
                                    break;
                                }
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    WildcardBinding otherWildcard;
                    switch (this.boundKind) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (!otherType.isWildcard()) return;
                            otherWildcard = (WildcardBinding)otherType;
                            switch (otherWildcard.boundKind) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 2);
                                    int i6 = 0;
                                    int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                    while (i6 < length) {
                                        this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i6], substitutes, 2);
                                        ++i6;
                                    }
                                    break block61;
                                }
                                default: {
                                    break;
                                }
                            }
                            break block61;
                        }
                        case 2: {
                            if (!otherType.isWildcard()) return;
                            otherWildcard = (WildcardBinding)otherType;
                            switch (otherWildcard.boundKind) {
                                case 0: {
                                    break block0;
                                }
                                case 1: {
                                    break block0;
                                }
                                case 2: {
                                    this.bound.collectSubstitutes(scope, otherWildcard.bound, substitutes, 2);
                                    int i7 = 0;
                                    int length = otherWildcard.otherBounds == null ? 0 : otherWildcard.otherBounds.length;
                                    while (i7 < length) {
                                        this.bound.collectSubstitutes(scope, otherWildcard.otherBounds[i7], substitutes, 2);
                                        ++i7;
                                    }
                                    break block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] wildCardKey;
        char[] genericTypeKey = this.genericType.computeUniqueKey(false);
        switch (this.boundKind) {
            case 0: {
                wildCardKey = WILDCARD_STAR;
                break;
            }
            case 1: {
                wildCardKey = CharOperation.concat(WILDCARD_PLUS, this.bound.computeUniqueKey(false));
                break;
            }
            default: {
                wildCardKey = CharOperation.concat(WILDCARD_MINUS, this.bound.computeUniqueKey(false));
            }
        }
        return CharOperation.concat(genericTypeKey, wildCardKey);
    }

    public String debugName() {
        return this.toString();
    }

    public TypeBinding erasure() {
        if (this.boundKind == 1) {
            return this.bound.erasure();
        }
        return this.typeVariable().erasure();
    }

    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.boundKind) {
                case 0: {
                    this.genericSignature = WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    void initialize(ReferenceBinding someGenericType, TypeBinding someBound, TypeBinding[] someOtherBounds) {
        this.genericType = someGenericType;
        this.bound = someBound;
        this.otherBounds = someOtherBounds;
        if (someGenericType != null) {
            this.fPackage = someGenericType.getPackage();
        }
        if (someBound != null) {
            this.tagBits |= someBound.tagBits & 0x20000000L;
        }
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        if (this.boundKind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(otherType);
            }
            return otherType.id == 1;
        }
        return false;
    }

    public boolean isIntersectionType() {
        return this.otherBounds != null;
    }

    public boolean isUnboundWildcard() {
        return this.boundKind == 0;
    }

    public boolean isWildcard() {
        return true;
    }

    public char[] readableName() {
        switch (this.boundKind) {
            case 0: {
                return WILDCARD_NAME;
            }
            case 1: {
                if (this.otherBounds == null) {
                    return CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, this.bound.readableName());
                }
                StringBuffer buffer = new StringBuffer(10);
                buffer.append(this.bound.readableName());
                int i2 = 0;
                int length = this.otherBounds.length;
                while (i2 < length) {
                    buffer.append('&').append(this.otherBounds[i2].readableName());
                    ++i2;
                }
                int length2 = buffer.length();
                char[] result = new char[length2];
                buffer.getChars(0, length2, result, 0);
                return result;
            }
        }
        return CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, this.bound.readableName());
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        BinaryTypeBinding.resolveType(this.genericType, this.environment, null, 0);
        switch (this.boundKind) {
            case 1: 
            case 2: {
                BinaryTypeBinding.resolveType(this.bound, this.environment, null, 0);
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        switch (this.boundKind) {
            case 0: {
                return WILDCARD_NAME;
            }
            case 1: {
                if (this.otherBounds == null) {
                    return CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, this.bound.shortReadableName());
                }
                StringBuffer buffer = new StringBuffer(10);
                buffer.append(this.bound.shortReadableName());
                int i2 = 0;
                int length = this.otherBounds.length;
                while (i2 < length) {
                    buffer.append('&').append(this.otherBounds[i2].shortReadableName());
                    ++i2;
                }
                int length2 = buffer.length();
                char[] result = new char[length2];
                buffer.getChars(0, length2, result, 0);
                return result;
            }
        }
        return CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, this.bound.shortReadableName());
    }

    public char[] signature() {
        if (this.signature == null) {
            switch (this.boundKind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    public char[] sourceName() {
        switch (this.boundKind) {
            case 0: {
                return WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, this.bound.sourceName());
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding superType = null;
            if (this.boundKind == 1 && !this.bound.isInterface()) {
                superType = this.bound;
            } else {
                TypeVariableBinding variable = this.typeVariable();
                if (variable != null) {
                    superType = variable.firstBound;
                }
            }
            this.superclass = superType instanceof ReferenceBinding && !superType.isInterface() ? (ReferenceBinding)superType : this.environment.getType(JAVA_LANG_OBJECT);
        }
        return this.superclass;
    }

    public ReferenceBinding superclass2() {
        if (this.superclass == null) {
            TypeBinding superType = this.boundKind == 1 && !this.bound.isInterface() ? this.bound : null;
            this.superclass = superType instanceof ReferenceBinding && !superType.isInterface() ? (ReferenceBinding)superType : this.environment.getType(JAVA_LANG_OBJECT);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : NoSuperInterfaces;
            if (this.boundKind == 1) {
                int length;
                if (this.bound.isInterface()) {
                    length = this.superInterfaces.length;
                    this.superInterfaces = new ReferenceBinding[length + 1];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, length);
                    this.superInterfaces[0] = (ReferenceBinding)this.bound;
                }
                if (this.otherBounds != null) {
                    length = this.superInterfaces.length;
                    int otherLength = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[length + otherLength];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, length);
                    int i2 = 0;
                    while (i2 < otherLength) {
                        this.superInterfaces[length + i2] = (ReferenceBinding)this.otherBounds[i2];
                        ++i2;
                    }
                }
            }
        }
        return this.superInterfaces;
    }

    public ReferenceBinding[] superInterfaces2() {
        if (this.superInterfaces == null) {
            if (this.boundKind == 1) {
                if (this.bound.isInterface()) {
                    if (this.otherBounds != null) {
                        int otherLength = this.otherBounds.length;
                        this.superInterfaces = new ReferenceBinding[otherLength + 1];
                        System.arraycopy(this.otherBounds, 0, this.superInterfaces, 1, otherLength);
                        this.superInterfaces[0] = (ReferenceBinding)this.bound;
                    } else {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)this.bound};
                    }
                } else if (this.otherBounds != null) {
                    int otherLength = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[otherLength];
                    System.arraycopy(this.otherBounds, 0, this.superInterfaces, 0, otherLength);
                } else {
                    this.superInterfaces = NoSuperInterfaces;
                }
            } else {
                this.superInterfaces = NoSuperInterfaces;
            }
        }
        return this.superInterfaces;
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment env) {
        boolean affected = false;
        if (this.genericType == unresolvedType) {
            this.genericType = resolvedType;
            affected = true;
        } else if (this.bound == unresolvedType) {
            this.bound = env.convertToRawType(resolvedType);
            affected = true;
        }
        if (affected) {
            this.initialize(this.genericType, this.bound, this.otherBounds);
        }
    }

    public String toString() {
        switch (this.boundKind) {
            case 0: {
                return new String(WILDCARD_NAME);
            }
            case 1: {
                if (this.otherBounds == null) {
                    return new String(CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
                }
                StringBuffer buffer = new StringBuffer(this.bound.debugName());
                int i2 = 0;
                int length = this.otherBounds.length;
                while (i2 < length) {
                    buffer.append('&').append(this.otherBounds[i2].debugName());
                    ++i2;
                }
                return buffer.toString();
            }
        }
        return new String(CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariables;
        if (this.typeVariable == null && this.rank < (typeVariables = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariables[this.rank];
        }
        return this.typeVariable;
    }
}

