/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        char[][] cArray = this.currentPackageName = unit.currentPackage == null ? CharOperation.NO_CHAR_CHAR : unit.currentPackage.tokens;
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int i2 = 0;
        int length = this.topLevelTypes.length;
        while (i2 < length) {
            this.topLevelTypes[i2].scope.buildFieldsAndMethods();
            ++i2;
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        TypeDeclaration[] types;
        char[][] expectedPackageName;
        this.topLevelTypes = new SourceTypeBinding[0];
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                this.problemReporter().packageCollidesWithType(this.referenceContext);
                return;
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int typeLength = (types = this.referenceContext.types) == null ? 0 : types.length;
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        int i2 = 0;
        while (i2 < typeLength) {
            TypeDeclaration typeDecl = types[i2];
            ReferenceBinding typeBinding = this.fPackage.getType0(typeDecl.name);
            this.recordSimpleReference(typeDecl.name);
            if (typeBinding != null && !(typeBinding instanceof UnresolvedReferenceBinding)) {
                this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
            } else if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(typeDecl.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
            } else {
                ClassScope child;
                SourceTypeBinding type;
                char[] mainTypeName;
                if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                    this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
                }
                if ((type = (child = new ClassScope(this, typeDecl)).buildType(null, this.fPackage, accessRestriction)) != null) {
                    this.topLevelTypes[count++] = type;
                }
            }
            ++i2;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i2];
            if (importReference.onDemand && CharOperation.equals(JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --numberOfImports;
                break;
            }
            ++i2;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i3 = 0;
        while (i3 < numberOfStatements) {
            block10: {
                ImportReference importReference = this.referenceContext.imports[i3];
                char[][] compoundName = importReference.tokens;
                int j = 0;
                while (j < index) {
                    ImportBinding resolved = resolvedImports[j];
                    if (resolved.onDemand != importReference.onDemand || resolved.isStatic() != importReference.isStatic() || !CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                        ++j;
                        continue;
                    }
                    break block10;
                }
                if (importReference.onDemand) {
                    Binding importBinding;
                    if (!(CharOperation.equals(compoundName, this.currentPackageName) || !(importBinding = this.findImport(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && importBinding instanceof PackageBinding)) {
                        resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                    }
                } else {
                    resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
                }
            }
            ++i3;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    void checkParameterizedTypeBounds() {
        int i2 = 0;
        int length = this.topLevelTypes.length;
        while (i2 < length) {
            this.topLevelTypes[i2].scope.checkParameterizedTypeBounds();
            ++i2;
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        char[] candidateName;
        boolean isCompliant15;
        if (localType.constantPoolName() != null) {
            return localType.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        boolean bl = isCompliant15 = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : (isCompliant15 ? CharOperation.concat(CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$'), localType.sourceName) : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName)));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return candidateName;
    }

    void connectTypeHierarchy() {
        int i2 = 0;
        int length = this.topLevelTypes.length;
        while (i2 < length) {
            this.topLevelTypes[i2].scope.connectTypeHierarchy();
            ++i2;
        }
    }

    void faultInImports() {
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        HashtableOfType typesBySimpleNames = null;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            if (!this.referenceContext.imports[i2].onDemand) {
                typesBySimpleNames = new HashtableOfType(this.topLevelTypes.length + numberOfStatements);
                int j = 0;
                int length = this.topLevelTypes.length;
                while (j < length) {
                    typesBySimpleNames.put(this.topLevelTypes[j].sourceName, this.topLevelTypes[j]);
                    ++j;
                }
                break;
            }
            ++i2;
        }
        int numberOfImports = numberOfStatements + 1;
        int i3 = 0;
        while (i3 < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i3];
            if (importReference.onDemand && CharOperation.equals(JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --numberOfImports;
                break;
            }
            ++i3;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i4 = 0;
        while (i4 < numberOfStatements) {
            block26: {
                ReferenceBinding conflictingType;
                Binding importBinding;
                char[][] compoundName;
                ImportReference importReference;
                block32: {
                    block30: {
                        ReferenceBinding referenceBinding;
                        block31: {
                            ReferenceBinding existingType;
                            block29: {
                                block28: {
                                    block27: {
                                        importReference = this.referenceContext.imports[i4];
                                        compoundName = importReference.tokens;
                                        int j = 0;
                                        while (j < index) {
                                            ImportBinding resolved = resolvedImports[j];
                                            if (resolved.onDemand == importReference.onDemand && resolved.isStatic() == importReference.isStatic() && CharOperation.equals(compoundName, resolved.compoundName)) {
                                                this.problemReporter().unusedImport(importReference);
                                                break block26;
                                            }
                                            ++j;
                                        }
                                        if (!importReference.onDemand) break block27;
                                        if (CharOperation.equals(compoundName, this.currentPackageName)) {
                                            this.problemReporter().unusedImport(importReference);
                                        } else {
                                            Binding importBinding2 = this.findImport(compoundName, compoundName.length);
                                            if (!importBinding2.isValidBinding()) {
                                                this.problemReporter().importProblem(importReference, importBinding2);
                                            } else if (importReference.isStatic() && importBinding2 instanceof PackageBinding) {
                                                this.problemReporter().cannotImportPackage(importReference);
                                            } else {
                                                resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding2, importReference);
                                            }
                                        }
                                        break block26;
                                    }
                                    importBinding = this.findSingleImport(compoundName, importReference.isStatic());
                                    if (importBinding.isValidBinding()) break block28;
                                    this.problemReporter().importProblem(importReference, importBinding);
                                    break block26;
                                }
                                if (!(importBinding instanceof PackageBinding)) break block29;
                                this.problemReporter().cannotImportPackage(importReference);
                                break block26;
                            }
                            conflictingType = null;
                            if (importBinding instanceof MethodBinding && !(conflictingType = (ReferenceBinding)this.getType(compoundName, compoundName.length)).isValidBinding()) {
                                conflictingType = null;
                            }
                            if (!(importBinding instanceof ReferenceBinding) && conflictingType == null) break block30;
                            ReferenceBinding referenceBinding2 = referenceBinding = conflictingType == null ? (ReferenceBinding)importBinding : conflictingType;
                            if (importReference.isTypeUseDeprecated(referenceBinding, this)) {
                                this.problemReporter().deprecatedType(referenceBinding, importReference);
                            }
                            if ((existingType = typesBySimpleNames.get(compoundName[compoundName.length - 1])) == null) break block31;
                            if (existingType != referenceBinding) {
                                int j = 0;
                                int length = this.topLevelTypes.length;
                                while (j < length) {
                                    if (CharOperation.equals(this.topLevelTypes[j].sourceName, existingType.sourceName)) {
                                        this.problemReporter().conflictingImport(importReference);
                                        break block26;
                                    }
                                    ++j;
                                }
                                this.problemReporter().duplicateImport(importReference);
                            }
                            break block26;
                        }
                        typesBySimpleNames.put(compoundName[compoundName.length - 1], referenceBinding);
                        break block32;
                    }
                    if (importBinding instanceof FieldBinding) {
                        int j = 0;
                        while (j < index) {
                            ImportBinding resolved = resolvedImports[j];
                            if (resolved.isStatic() && resolved.resolvedImport instanceof FieldBinding && importBinding != resolved.resolvedImport && CharOperation.equals(compoundName[compoundName.length - 1], resolved.compoundName[resolved.compoundName.length - 1])) {
                                this.problemReporter().duplicateImport(importReference);
                                break block26;
                            }
                            ++j;
                        }
                    }
                }
                resolvedImports[index++] = conflictingType == null ? new ImportBinding(compoundName, false, importBinding, importReference) : new ImportConflictBinding(compoundName, importBinding, conflictingType, importReference);
            }
            ++i4;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
        int length = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(length);
        int i5 = 0;
        while (i5 < length) {
            ImportBinding binding = this.imports[i5];
            if (!binding.onDemand && binding.resolvedImport instanceof ReferenceBinding || binding instanceof ImportConflictBinding) {
                this.typeOrPackageCache.put(binding.compoundName[binding.compoundName.length - 1], binding);
            }
            ++i5;
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        int i2 = 0;
        int length = this.topLevelTypes.length;
        while (i2 < length) {
            this.topLevelTypes[i2].faultInTypesForFieldsAndMethods();
            ++i2;
        }
    }

    private Binding findImport(char[][] compoundName, int length) {
        ReferenceBinding type;
        int i2;
        Binding binding;
        block12: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i2 = 1;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i2 < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i2++])) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else if (binding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)binding;
                        continue;
                    }
                    break block12;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i2), null, 1);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i2), null, 1);
            }
            i2 = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i2 < length) {
            char[] name;
            if (!type.canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i2), type, 2);
            }
            if ((type = type.getMemberType(name = compoundName[i2++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i2), null, 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleImport(char[][] compoundName, boolean findStaticImports) {
        if (compoundName.length == 1) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            return typeBinding;
        }
        if (findStaticImports) {
            return this.findSingleStaticImport(compoundName);
        }
        return this.findImport(compoundName, compoundName.length);
    }

    private Binding findSingleStaticImport(char[][] compoundName) {
        Binding binding = this.findImport(compoundName, compoundName.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] name = compoundName[compoundName.length - 1];
        if (binding instanceof PackageBinding) {
            Binding temp = ((PackageBinding)binding).getTypeOrPackage(name);
            if (temp != null && temp instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(compoundName, (ReferenceBinding)temp, 14);
            }
            return binding;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        FieldBinding field = this.findField(type, name, null, true);
        if (field != null && field.isValidBinding() && field.isStatic() && field.canBeSeenBy(this.fPackage)) {
            return field;
        }
        MethodBinding method = this.findStaticMethod(type, name);
        if (method != null) {
            return method;
        }
        if ((type = this.findMemberType(name, type)) == null || !type.isStatic()) {
            return new ProblemReferenceBinding(compoundName, type, 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    MethodBinding findStaticMethod(ReferenceBinding currentType, char[] selector) {
        if (!currentType.canBeSeenBy(this)) {
            return null;
        }
        do {
            MethodBinding[] methods;
            if ((methods = currentType.getMethods(selector)) != NoMethods) {
                int i2 = methods.length;
                while (--i2 >= 0) {
                    MethodBinding method = methods[i2];
                    if (!method.isStatic() || !method.canBeSeenBy(this.fPackage)) continue;
                    return method;
                }
            }
            if (currentType.superInterfaces() != null) continue;
            ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
        } while ((currentType = currentType.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding importBinding = this.environment.getTopLevelPackage(JAVA);
        if (importBinding != null) {
            importBinding = importBinding.getTypeOrPackage(JAVA_LANG[1]);
        }
        if (importBinding == null || !importBinding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(JAVA_LANG, true, importBinding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] compoundName, boolean onDemand, boolean isStaticImport) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, isStaticImport);
    }

    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = qualifiedName.length;
        if (length > 1) {
            while (!this.qualifiedReferences.contains(qualifiedName)) {
                this.qualifiedReferences.add(qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                qualifiedName = new char[length][];
                System.arraycopy(cArray, 0, qualifiedName, 0, length);
            }
        } else if (length == 1) {
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        this.recordSimpleReference(simpleName);
    }

    void recordReference(ReferenceBinding type, char[] simpleName) {
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.recordReference(actualType.compoundName, simpleName);
        }
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    void recordSuperTypeReference(TypeBinding type) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedSuperTypes.containsIdentical(actualType)) {
            this.referencedSuperTypes.add(actualType);
        }
    }

    public void recordTypeConversion(TypeBinding superType, TypeBinding subType) {
        this.recordSuperTypeReference(subType);
    }

    void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
            this.referencedTypes.add(actualType);
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.referencedTypes == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int i2 = 0;
        int max = types.length;
        while (i2 < max) {
            ReferenceBinding actualType = this.typeToRecord(types[i2]);
            if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
                this.referencedTypes.add(actualType);
            }
            ++i2;
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int i2 = 0;
                    int n = 0;
                    int max = this.imports.length;
                    while (i2 < max) {
                        if (this.imports[i2] != importBinding) {
                            newImports[n++] = this.imports[i2];
                        }
                        ++i2;
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i2 = 0;
        while (i2 < this.referencedSuperTypes.size) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding enclosing;
            ReferenceBinding type = (ReferenceBinding)this.referencedSuperTypes.elementAt(i2);
            if (!this.referencedTypes.containsIdentical(type)) {
                this.referencedTypes.add(type);
            }
            if (!type.isLocalType() && (enclosing = type.enclosingType()) != null) {
                this.recordSuperTypeReference(enclosing);
            }
            if ((superclass = type.superclass()) != null) {
                this.recordSuperTypeReference(superclass);
            }
            if ((interfaces = type.superInterfaces()) != null) {
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    this.recordSuperTypeReference(interfaces[j]);
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        int l = this.referencedTypes.size;
        while (i2 < l) {
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i2);
            if (!type.isLocalType()) {
                this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
            }
            ++i2;
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        int i3 = 0;
        while (i3 < size) {
            qualifiedRefs[i3] = this.qualifiedReferences.elementAt(i3);
            ++i3;
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        int i4 = 0;
        while (i4 < size) {
            simpleRefs[i4] = this.simpleNameReferences.elementAt(i4);
            ++i4;
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding type) {
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        switch (type.kind()) {
            case 132: 
            case 516: 
            case 4100: {
                return null;
            }
            case 260: 
            case 1028: {
                type = type.erasure();
            }
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isLocalType()) {
            return null;
        }
        return refType;
    }

    public void verifyMethods(MethodVerifier verifier) {
        int i2 = 0;
        int length = this.topLevelTypes.length;
        while (i2 < length) {
            this.topLevelTypes[i2].verifyMethods(verifier);
            ++i2;
        }
    }
}

