/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public ReferenceBinding[] handledExceptions;
    public static final int BitCacheSize = 32;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public ArrayList extendedExceptions;

    public ExceptionHandlingFlowContext(FlowContext parent, ASTNode associatedNode, ReferenceBinding[] handledExceptions, BlockScope scope, UnconditionalFlowInfo flowInfo) {
        super(parent, associatedNode);
        this.isMethodContext = scope == scope.methodScope();
        this.handledExceptions = handledExceptions;
        int count = handledExceptions.length;
        int cacheSize = count / 32 + 1;
        this.isReached = new int[cacheSize];
        this.isNeeded = new int[cacheSize];
        this.initsOnExceptions = new UnconditionalFlowInfo[count];
        int i2 = 0;
        while (i2 < count) {
            this.indexes.put(handledExceptions[i2], i2);
            int cacheIndex = i2 / 32;
            int bitMask = 1 << i2 % 32;
            if (handledExceptions[i2].isUncheckedException(true)) {
                int n = cacheIndex;
                this.isReached[n] = this.isReached[n] | bitMask;
                this.initsOnExceptions[i2] = flowInfo.copy().unconditionalInits();
            } else {
                this.initsOnExceptions[i2] = FlowInfo.DEAD_END;
            }
            ++i2;
        }
        System.arraycopy(this.isReached, 0, this.isNeeded, 0, cacheSize);
        this.initsOnReturn = FlowInfo.DEAD_END;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration method) {
        MethodScope scope = method.scope;
        if ((method.binding.modifiers & 0x30000000) != 0 && !scope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        int i2 = 0;
        int count = this.handledExceptions.length;
        while (i2 < count) {
            int bitMask;
            int index = this.indexes.get(this.handledExceptions[i2]);
            int cacheIndex = index / 32;
            if ((this.isReached[cacheIndex] & (bitMask = 1 << index % 32)) == 0) {
                scope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[index], method, method.thrownExceptions[index]);
            }
            ++i2;
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope scope, TryStatement tryStatement) {
        int i2 = 0;
        int count = this.handledExceptions.length;
        while (i2 < count) {
            int bitMask;
            int index = this.indexes.get(this.handledExceptions[i2]);
            int cacheIndex = index / 32;
            if ((this.isReached[cacheIndex] & (bitMask = 1 << index % 32)) == 0) {
                scope.problemReporter().unreachableCatchBlock(this.handledExceptions[index], tryStatement.catchArguments[index].type);
            } else if ((this.isNeeded[cacheIndex] & bitMask) == 0) {
                scope.problemReporter().hiddenCatchBlock(this.handledExceptions[index], tryStatement.catchArguments[index].type);
            }
            ++i2;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Exception flow context");
        int length = this.handledExceptions.length;
        int i2 = 0;
        while (i2 < length) {
            int cacheIndex = i2 / 32;
            int bitMask = 1 << i2 % 32;
            buffer.append('[').append(this.handledExceptions[i2].readableName());
            if ((this.isReached[cacheIndex] & bitMask) != 0) {
                if ((this.isNeeded[cacheIndex] & bitMask) == 0) {
                    buffer.append("-masked");
                } else {
                    buffer.append("-reached");
                }
            } else {
                buffer.append("-not reached");
            }
            buffer.append('-').append(this.initsOnExceptions[i2].toString()).append(']');
            ++i2;
        }
        buffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return buffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(ReferenceBinding exceptionType) {
        int index = this.indexes.get(exceptionType);
        if (index < 0) {
            return FlowInfo.DEAD_END;
        }
        return this.initsOnExceptions[index];
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void recordHandlingException(ReferenceBinding exceptionType, UnconditionalFlowInfo flowInfo, TypeBinding raisedException, ASTNode invocationSite, boolean wasAlreadyDefinitelyCaught) {
        int index = this.indexes.get(exceptionType);
        int cacheIndex = index / 32;
        int bitMask = 1 << index % 32;
        if (!wasAlreadyDefinitelyCaught) {
            int n = cacheIndex;
            this.isNeeded[n] = this.isNeeded[n] | bitMask;
        }
        int n = cacheIndex;
        this.isReached[n] = this.isReached[n] | bitMask;
        this.initsOnExceptions[index] = this.initsOnExceptions[index] == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnExceptions[index].mergedWith(flowInfo.copy().unconditionalInits());
    }

    public void recordReturnFrom(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.initsOnReturn = this.initsOnReturn == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnReturn.mergedWith(flowInfo.copy().unconditionalInits());
    }

    public void mergeUnhandledException(TypeBinding newException) {
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            int i2 = 0;
            while (i2 < this.handledExceptions.length) {
                this.extendedExceptions.add(this.handledExceptions[i2]);
                ++i2;
            }
        }
        boolean isRedundant = false;
        int i3 = this.extendedExceptions.size() - 1;
        while (i3 >= 0) {
            switch (Scope.compareTypes(newException, (TypeBinding)this.extendedExceptions.get(i3))) {
                case 1: {
                    this.extendedExceptions.remove(i3);
                    break;
                }
                case -1: {
                    isRedundant = true;
                    break;
                }
            }
            --i3;
        }
        if (!isRedundant) {
            this.extendedExceptions.add(newException);
        }
    }
}

