/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String messageTemplate;

    public AccessRuleSet(AccessRule[] accessRules) {
        this.accessRules = accessRules;
    }

    public AccessRuleSet(AccessRule[] accessRules, String messageTemplate) {
        this.accessRules = accessRules;
        this.messageTemplate = messageTemplate;
    }

    public boolean equals(Object object2) {
        if (this == object2) {
            return true;
        }
        if (!(object2 instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet otherRuleSet = (AccessRuleSet)object2;
        if (!this.messageTemplate.equals(otherRuleSet.messageTemplate)) {
            return false;
        }
        int rulesLength = this.accessRules.length;
        if (rulesLength != otherRuleSet.accessRules.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < rulesLength) {
            if (!this.accessRules[i2].equals(otherRuleSet.accessRules[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] targetTypeFilePath) {
        int i2 = 0;
        int length = this.accessRules.length;
        while (i2 < length) {
            AccessRule accessRule = this.accessRules[i2];
            if (CharOperation.pathMatch(accessRule.pattern, targetTypeFilePath, true, '/')) {
                switch (accessRule.problemId) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplate);
                    }
                }
                return null;
            }
            ++i2;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean wrap) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("AccessRuleSet {");
        if (wrap) {
            buffer.append('\n');
        }
        int i2 = 0;
        int length = this.accessRules.length;
        while (i2 < length) {
            if (wrap) {
                buffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[i2];
            buffer.append(accessRule);
            if (wrap) {
                buffer.append('\n');
            } else if (i2 < length - 1) {
                buffer.append(", ");
            }
            ++i2;
        }
        buffer.append("} [template:\"").append(this.messageTemplate).append("\"]");
        return buffer.toString();
    }
}

