/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int i2 = 0;
        int max = this.dimensions.length;
        while (i2 < max) {
            Expression dim = this.dimensions[i2];
            if (dim != null) {
                flowInfo = dim.analyseCode(currentScope, flowContext, flowInfo);
            }
            ++i2;
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.initializer != null) {
            this.initializer.generateCode(currentScope, codeStream, valueRequired);
            return;
        }
        int nonNullDimensionsLength = 0;
        int i2 = 0;
        int max = this.dimensions.length;
        while (i2 < max) {
            if (this.dimensions[i2] != null) {
                this.dimensions[i2].generateCode(currentScope, codeStream, true);
                ++nonNullDimensionsLength;
            }
            ++i2;
        }
        if (this.resolvedType.dimensions() == 1) {
            codeStream.newArray((ArrayBinding)this.resolvedType);
        } else {
            codeStream.multianewarray(this.resolvedType, nonNullDimensionsLength);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.type.print(0, output);
        int i2 = 0;
        while (i2 < this.dimensions.length) {
            if (this.dimensions[i2] == null) {
                output.append("[]");
            } else {
                output.append('[');
                this.dimensions[i2].printExpression(0, output);
                output.append(']');
            }
            ++i2;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, output);
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding referenceType = this.type.resolveType(scope, true);
        this.constant = Constant.NotAConstant;
        if (referenceType == VoidBinding) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            referenceType = null;
        }
        int explicitDimIndex = -1;
        int i2 = this.dimensions.length;
        while (--i2 >= 0) {
            if (this.dimensions[i2] != null) {
                if (explicitDimIndex >= 0) continue;
                explicitDimIndex = i2;
                continue;
            }
            if (explicitDimIndex <= 0) continue;
            scope.problemReporter().incorrectLocationForNonEmptyDimension(this, explicitDimIndex);
            break;
        }
        if (this.initializer == null) {
            if (explicitDimIndex < 0) {
                scope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
            if (referenceType != null && !referenceType.isReifiable()) {
                scope.problemReporter().illegalGenericArray(referenceType, this);
            }
        } else if (explicitDimIndex >= 0) {
            scope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        i2 = 0;
        while (i2 <= explicitDimIndex) {
            TypeBinding dimensionType;
            if (this.dimensions[i2] != null && (dimensionType = this.dimensions[i2].resolveTypeExpecting(scope, IntBinding)) != null) {
                this.dimensions[i2].computeConversion(scope, IntBinding, dimensionType);
            }
            ++i2;
        }
        if (referenceType != null) {
            if (this.dimensions.length > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(referenceType, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(scope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int dimensionsLength = this.dimensions.length;
            this.type.traverse(visitor, scope);
            int i2 = 0;
            while (i2 < dimensionsLength) {
                if (this.dimensions[i2] != null) {
                    this.dimensions[i2].traverse(visitor, scope);
                }
                ++i2;
            }
            if (this.initializer != null) {
                this.initializer.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

