/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovy.text.RegexUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoaderConfiguration {
    private static final String MAIN_PREFIX = "main is";
    private static final String LOAD_PREFIX = "load";
    private List classPath = new ArrayList();
    private String main;
    private boolean requireMain = true;
    private static final char WILDCARD = '*';
    private static final String ALL_WILDCARD = "**";
    private static final String MATCH_FILE_NAME = "\\\\E[^/]+?\\\\Q";
    private static final String MATCH_ALL = "\\\\E.+?\\\\Q";

    public void configure(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            ++lineNumber;
            if (line.startsWith("#") || line.length() == 0) continue;
            if (line.startsWith(LOAD_PREFIX)) {
                String loadPath = line.substring(LOAD_PREFIX.length()).trim();
                loadPath = this.assignProperties(loadPath);
                this.loadFilteredPath(loadPath);
                continue;
            }
            if (line.startsWith(MAIN_PREFIX)) {
                if (this.main != null) {
                    throw new IOException("duplicate definition of main in line " + lineNumber + " : " + line);
                }
                this.main = line.substring(MAIN_PREFIX.length()).trim();
                continue;
            }
            throw new IOException("unexpected line in " + lineNumber + " : " + line);
        }
        if (this.requireMain && this.main == null) {
            throw new IOException("missing main class definition in config file");
        }
    }

    private String assignProperties(String str) {
        int propertyIndexStart = 0;
        int propertyIndexEnd = 0;
        boolean requireProperty = false;
        String result = "";
        while (propertyIndexStart < str.length()) {
            int i1 = str.indexOf("${", propertyIndexStart);
            int i2 = str.indexOf("!{", propertyIndexStart);
            propertyIndexStart = i1 == -1 ? i2 : (i2 == -1 ? i1 : Math.min(i1, i2));
            boolean bl = requireProperty = propertyIndexStart == i2;
            if (propertyIndexStart == -1) break;
            result = result + str.substring(propertyIndexEnd, propertyIndexStart);
            propertyIndexEnd = str.indexOf("}", propertyIndexStart);
            if (propertyIndexEnd == -1) break;
            String propertyKey = str.substring(propertyIndexStart + 2, propertyIndexEnd);
            String propertyValue = System.getProperty(propertyKey);
            if (propertyValue == null) {
                if (requireProperty) {
                    throw new IllegalArgumentException("Variable " + propertyKey + " in groovy-starter.conf references a non-existent System property! Try passing the property to the VM using -D" + propertyKey + "=myValue in JAVA_OPTS");
                }
                return null;
            }
            propertyValue = this.getSlashyPath(propertyValue);
            result = result + propertyValue;
            propertyIndexStart = ++propertyIndexEnd;
        }
        if (propertyIndexStart == -1 || propertyIndexStart >= str.length()) {
            result = result + str.substring(propertyIndexEnd);
        } else if (propertyIndexEnd == -1) {
            result = result + str.substring(propertyIndexStart);
        }
        return result;
    }

    private void loadFilteredPath(String filter) {
        if (filter == null) {
            return;
        }
        int starIndex = filter.indexOf(42);
        if (starIndex == -1) {
            this.addFile(new File(filter));
            return;
        }
        boolean recursive = filter.indexOf(ALL_WILDCARD) != -1;
        String startDir = filter.substring(0, starIndex - 1);
        File root = new File(startDir);
        filter = RegexUtils.quote(filter);
        filter = filter.replaceAll("\\*\\*", MATCH_ALL);
        filter = filter.replaceAll("\\*", MATCH_FILE_NAME);
        Pattern pattern = Pattern.compile(filter);
        File[] files = root.listFiles();
        if (files != null) {
            this.findMatchingFiles(files, pattern, recursive);
        }
    }

    private void findMatchingFiles(File[] files, Pattern pattern, boolean recursive) {
        for (int i2 = 0; i2 < files.length; ++i2) {
            File[] dirFiles;
            File file = files[i2];
            String fileString = this.getSlashyPath(file.getPath());
            Matcher m = pattern.matcher(fileString);
            if (m.matches() && file.isFile()) {
                this.addFile(file);
            }
            if (!file.isDirectory() || !recursive || (dirFiles = file.listFiles()) == null) continue;
            this.findMatchingFiles(dirFiles, pattern, true);
        }
    }

    private String getSlashyPath(String path) {
        String changedPath = path;
        if (File.separatorChar != '/') {
            changedPath = changedPath.replace(File.separatorChar, '/');
        }
        return changedPath;
    }

    private boolean parentPathDoesExist(String path) {
        File dir2 = new File(path).getParentFile();
        return dir2.exists();
    }

    private String getParentPath(String filter) {
        int index = filter.lastIndexOf(47);
        if (index == -1) {
            return "";
        }
        return filter.substring(index + 1);
    }

    public void addFile(File f2) {
        if (f2 != null && f2.exists()) {
            try {
                this.classPath.add(f2.toURI().toURL());
            }
            catch (MalformedURLException e2) {
                throw new AssertionError((Object)"converting an existing file to an url should have never thrown an exception!");
            }
        }
    }

    public void addFile(String s2) {
        if (s2 != null) {
            this.addFile(new File(s2));
        }
    }

    public void addClassPath(String path) {
        String[] paths = path.split(File.pathSeparator);
        for (int i2 = 0; i2 < paths.length; ++i2) {
            this.addFile(new File(paths[i2]));
        }
    }

    public URL[] getClassPathUrls() {
        return this.classPath.toArray(new URL[this.classPath.size()]);
    }

    public String getMainClass() {
        return this.main;
    }

    public void setMainClass(String clazz) {
        this.main = clazz;
        this.requireMain = false;
    }

    public void setRequireMain(boolean requireMain) {
        this.requireMain = requireMain;
    }
}

