/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.ErrorReporter;

public abstract class CompileTaskSupport
extends MatchingTask {
    protected final LoggingHelper log = new LoggingHelper((Task)this);
    protected Path src;
    protected File destdir;
    protected Path classpath;
    protected CompilerConfiguration config = new CompilerConfiguration();
    protected boolean failOnError = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path dir2) {
        if (!$assertionsDisabled && dir2 == null) {
            throw new AssertionError();
        }
        if (this.src == null) {
            this.src = dir2;
        } else {
            this.src.append(dir2);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File dir2) {
        if (!$assertionsDisabled && dir2 == null) {
            throw new AssertionError();
        }
        this.destdir = dir2;
    }

    public void setClasspath(Path path) {
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError();
        }
        this.createClasspath().setRefid(r);
    }

    public CompilerConfiguration createConfiguration() {
        return this.config;
    }

    protected void validate() throws BuildException {
        if (this.src == null) {
            throw new BuildException("Missing attribute: srcdir (or one or more nested <src> elements).", this.getLocation());
        }
        if (this.destdir == null) {
            throw new BuildException("Missing attribute: destdir", this.getLocation());
        }
        if (!this.destdir.exists()) {
            throw new BuildException("Destination directory does not exist: " + this.destdir, this.getLocation());
        }
    }

    protected GroovyClassLoader createClassLoader() {
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        GroovyClassLoader gcl = new GroovyClassLoader(parent, this.config);
        Path path = this.getClasspath();
        if (path != null) {
            String[] filePaths = path.list();
            for (int i2 = 0; i2 < filePaths.length; ++i2) {
                String filePath = filePaths[i2];
                gcl.addClasspath(filePath);
            }
        }
        return gcl;
    }

    protected void handleException(Exception e2) throws BuildException {
        if (!$assertionsDisabled && e2 == null) {
            throw new AssertionError();
        }
        StringWriter writer = new StringWriter();
        new ErrorReporter(e2, false).write(new PrintWriter(writer));
        String message = writer.toString();
        if (this.failOnError) {
            throw new BuildException(message, (Throwable)e2, this.getLocation());
        }
        this.log.error(message);
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            this.compile();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    protected abstract void compile() throws Exception;

    static {
        $assertionsDisabled = !CompileTaskSupport.class.desiredAssertionStatus();
    }
}

