/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IOUtils {
    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = stream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static int readFully(InputStream in, byte[] b2) throws IOException {
        return IOUtils.readFully(in, b2, 0, b2.length);
    }

    public static int readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = in.read(b2, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }
}

