/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.hssf.record.formula.AreaI;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.RefEvalBase;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.formula.LazyAreaEval;
import org.apache.poi.ss.formula.SheetRefEvaluator;

final class LazyRefEval
extends RefEvalBase {
    private final SheetRefEvaluator _evaluator;

    public LazyRefEval(RefPtg ptg, SheetRefEvaluator sre) {
        super(ptg.getRow(), ptg.getColumn());
        this._evaluator = sre;
    }

    public LazyRefEval(Ref3DPtg ptg, SheetRefEvaluator sre) {
        super(ptg.getRow(), ptg.getColumn());
        this._evaluator = sre;
    }

    public ValueEval getInnerValueEval() {
        return this._evaluator.getEvalForCell(this.getRow(), this.getColumn());
    }

    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        AreaI.OffsetArea area2 = new AreaI.OffsetArea(this.getRow(), this.getColumn(), relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        return new LazyAreaEval(area2, this._evaluator);
    }

    public String toString() {
        CellReference cr = new CellReference(this.getRow(), this.getColumn());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append(this._evaluator.getSheetName());
        sb.append('!');
        sb.append(cr.formatAsString());
        sb.append("]");
        return sb.toString();
    }
}

