/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.ss.formula.FormulaCellCacheEntry;
import org.apache.poi.ss.formula.FormulaCellCacheEntrySet;
import org.apache.poi.ss.formula.IEvaluationListener;

abstract class CellCacheEntry
implements IEvaluationListener.ICacheEntry {
    public static final CellCacheEntry[] EMPTY_ARRAY = new CellCacheEntry[0];
    private final FormulaCellCacheEntrySet _consumingCells = new FormulaCellCacheEntrySet();
    private ValueEval _value;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$NumberEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$StringEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$BoolEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$ErrorEval;

    protected CellCacheEntry() {
    }

    protected final void clearValue() {
        this._value = null;
    }

    public final boolean updateValue(ValueEval value) {
        if (value == null) {
            throw new IllegalArgumentException("Did not expect to update to null");
        }
        boolean result = !CellCacheEntry.areValuesEqual(this._value, value);
        this._value = value;
        return result;
    }

    public final ValueEval getValue() {
        return this._value;
    }

    private static boolean areValuesEqual(ValueEval a2, ValueEval b2) {
        if (a2 == null) {
            return false;
        }
        Class<?> cls = a2.getClass();
        if (cls != b2.getClass()) {
            return false;
        }
        if (a2 == BlankEval.INSTANCE) {
            return b2 == a2;
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = CellCacheEntry.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval)) {
            return ((NumberEval)a2).getNumberValue() == ((NumberEval)b2).getNumberValue();
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$org$apache$poi$hssf$record$formula$eval$StringEval = CellCacheEntry.class$("org.apache.poi.hssf.record.formula.eval.StringEval")) : class$org$apache$poi$hssf$record$formula$eval$StringEval)) {
            return ((StringEval)a2).getStringValue().equals(((StringEval)b2).getStringValue());
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$BoolEval == null ? (class$org$apache$poi$hssf$record$formula$eval$BoolEval = CellCacheEntry.class$("org.apache.poi.hssf.record.formula.eval.BoolEval")) : class$org$apache$poi$hssf$record$formula$eval$BoolEval)) {
            return ((BoolEval)a2).getBooleanValue() == ((BoolEval)b2).getBooleanValue();
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$ErrorEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ErrorEval = CellCacheEntry.class$("org.apache.poi.hssf.record.formula.eval.ErrorEval")) : class$org$apache$poi$hssf$record$formula$eval$ErrorEval)) {
            return ((ErrorEval)a2).getErrorCode() == ((ErrorEval)b2).getErrorCode();
        }
        throw new IllegalStateException("Unexpected value class (" + cls.getName() + ")");
    }

    public final void addConsumingCell(FormulaCellCacheEntry cellLoc) {
        this._consumingCells.add(cellLoc);
    }

    public final FormulaCellCacheEntry[] getConsumingCells() {
        return this._consumingCells.toArray();
    }

    public final void clearConsumingCell(FormulaCellCacheEntry cce) {
        if (!this._consumingCells.remove(cce)) {
            throw new IllegalStateException("Specified formula cell is not consumed by this cell");
        }
    }

    public final void recurseClearCachedFormulaResults(IEvaluationListener listener) {
        if (listener == null) {
            this.recurseClearCachedFormulaResults();
        } else {
            listener.onClearCachedValue(this);
            this.recurseClearCachedFormulaResults(listener, 1);
        }
    }

    protected final void recurseClearCachedFormulaResults() {
        FormulaCellCacheEntry[] formulaCells = this.getConsumingCells();
        for (int i2 = 0; i2 < formulaCells.length; ++i2) {
            FormulaCellCacheEntry fc = formulaCells[i2];
            fc.clearFormulaEntry();
            fc.recurseClearCachedFormulaResults();
        }
    }

    protected final void recurseClearCachedFormulaResults(IEvaluationListener listener, int depth) {
        IEvaluationListener.ICacheEntry[] formulaCells = this.getConsumingCells();
        listener.sortDependentCachedValues(formulaCells);
        for (int i2 = 0; i2 < formulaCells.length; ++i2) {
            IEvaluationListener.ICacheEntry fc = formulaCells[i2];
            listener.onClearDependentCachedValue(fc, depth);
            ((FormulaCellCacheEntry)fc).clearFormulaEntry();
            ((CellCacheEntry)fc).recurseClearCachedFormulaResults(listener, depth + 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

