/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.util.HSSFColor;

public class HSSFPalette {
    private PaletteRecord palette;

    protected HSSFPalette(PaletteRecord palette) {
        this.palette = palette;
    }

    public HSSFColor getColor(short index) {
        if (index == 64) {
            return HSSFColor.AUTOMATIC.getInstance();
        }
        byte[] b2 = this.palette.getColor(index);
        if (b2 != null) {
            return new CustomColor(index, b2);
        }
        return null;
    }

    public HSSFColor getColor(int index) {
        return this.getColor((short)index);
    }

    public HSSFColor findColor(byte red, byte green, byte blue) {
        byte[] b2 = this.palette.getColor((short)8);
        short i2 = 8;
        while (b2 != null) {
            if (b2[0] == red && b2[1] == green && b2[2] == blue) {
                return new CustomColor(i2, b2);
            }
            i2 = (short)(i2 + 1);
            b2 = this.palette.getColor(i2);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte red, byte green, byte blue) {
        HSSFColor result = null;
        int minColorDistance = Integer.MAX_VALUE;
        byte[] b2 = this.palette.getColor((short)8);
        short i2 = 8;
        while (b2 != null) {
            int colorDistance = Math.abs(red - b2[0]) + Math.abs(green - b2[1]) + Math.abs(blue - b2[2]);
            if (colorDistance < minColorDistance) {
                minColorDistance = colorDistance;
                result = this.getColor(i2);
            }
            i2 = (short)(i2 + 1);
            b2 = this.palette.getColor(i2);
        }
        return result;
    }

    public void setColorAtIndex(short index, byte red, byte green, byte blue) {
        this.palette.setColor(index, red, green, blue);
    }

    public HSSFColor addColor(byte red, byte green, byte blue) {
        byte[] b2 = this.palette.getColor((short)8);
        for (short i2 = 8; i2 < 64; i2 = (short)(i2 + 1)) {
            if (b2 == null) {
                this.setColorAtIndex(i2, red, green, blue);
                return this.getColor(i2);
            }
            b2 = this.palette.getColor(i2);
        }
        throw new RuntimeException("Could not find free color index");
    }

    private static class CustomColor
    extends HSSFColor {
        private short byteOffset;
        private byte red;
        private byte green;
        private byte blue;

        private CustomColor(short byteOffset, byte[] colors) {
            this(byteOffset, colors[0], colors[1], colors[2]);
        }

        private CustomColor(short byteOffset, byte red, byte green, byte blue) {
            this.byteOffset = byteOffset;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public short getIndex() {
            return this.byteOffset;
        }

        public short[] getTriplet() {
            return new short[]{(short)(this.red & 0xFF), (short)(this.green & 0xFF), (short)(this.blue & 0xFF)};
        }

        public String getHexString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getGnumericPart(this.red));
            sb.append(':');
            sb.append(this.getGnumericPart(this.green));
            sb.append(':');
            sb.append(this.getGnumericPart(this.blue));
            return sb.toString();
        }

        private String getGnumericPart(byte color) {
            String s2;
            if (color == 0) {
                s2 = "0";
            } else {
                int c2 = color & 0xFF;
                c2 = c2 << 8 | c2;
                s2 = Integer.toHexString(c2).toUpperCase();
                while (s2.length() < 4) {
                    s2 = "0" + s2;
                }
            }
            return s2;
        }
    }
}

