/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.Arrays;

public final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] v) {
        int i2;
        double r = 0.0;
        double m = 0.0;
        double s2 = 0.0;
        int iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += v[i2];
        }
        m = s2 / (double)v.length;
        s2 = 0.0;
        iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += Math.abs(v[i2] - m);
        }
        r = s2 / (double)v.length;
        return r;
    }

    public static double stdev(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length > 1) {
            r = Math.sqrt(StatsLib.devsq(v) / (double)(v.length - 1));
        }
        return r;
    }

    public static double median(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length >= 1) {
            int n = v.length;
            Arrays.sort(v);
            r = n % 2 == 0 ? (v[n / 2] + v[n / 2 - 1]) / 2.0 : v[n / 2];
        }
        return r;
    }

    public static double devsq(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length >= 1) {
            int i2;
            double m = 0.0;
            double s2 = 0.0;
            int n = v.length;
            for (i2 = 0; i2 < n; ++i2) {
                s2 += v[i2];
            }
            m = s2 / (double)n;
            s2 = 0.0;
            for (i2 = 0; i2 < n; ++i2) {
                s2 += (v[i2] - m) * (v[i2] - m);
            }
            r = n == 1 ? 0.0 : s2;
        }
        return r;
    }

    public static double kthLargest(double[] v, int k) {
        double r = Double.NaN;
        if (v != null && v.length > --k && k >= 0) {
            Arrays.sort(v);
            r = v[v.length - k - 1];
        }
        return r;
    }

    public static double kthSmallest(double[] v, int k) {
        double r = Double.NaN;
        if (v != null && v.length > --k && k >= 0) {
            Arrays.sort(v);
            r = v[k];
        }
        return r;
    }
}

