/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public abstract class RefPtgBase
extends OperandPtg {
    private static final int MAX_ROW_NUMBER = 65536;
    private int field_1_row;
    private int field_2_col;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField column = BitFieldFactory.getInstance(255);

    protected RefPtgBase() {
    }

    protected RefPtgBase(String cellref) {
        CellReference c2 = new CellReference(cellref);
        this.setRow(c2.getRow());
        this.setColumn(c2.getCol());
        this.setColRelative(!c2.isColAbsolute());
        this.setRowRelative(!c2.isRowAbsolute());
    }

    protected RefPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected final void readCoordinates(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readUShort();
    }

    protected final void writeCoordinates(byte[] array, int offset) {
        LittleEndian.putUShort(array, offset + 0, this.field_1_row);
        LittleEndian.putUShort(array, offset + 2, this.field_2_col);
    }

    public final void setRow(int row) {
        if (row < 0 || row >= 65536) {
            throw new IllegalArgumentException("The row number, when specified as an integer, must be between 0 and 65536");
        }
        this.field_1_row = row;
    }

    public final int getRow() {
        return this.field_1_row;
    }

    public final boolean isRowRelative() {
        return rowRelative.isSet(this.field_2_col);
    }

    public final void setRowRelative(boolean rel) {
        this.field_2_col = rowRelative.setBoolean(this.field_2_col, rel);
    }

    public final boolean isColRelative() {
        return colRelative.isSet(this.field_2_col);
    }

    public final void setColRelative(boolean rel) {
        this.field_2_col = colRelative.setBoolean(this.field_2_col, rel);
    }

    public final void setColumn(int col2) {
        if (col2 < 0 || col2 >= 256) {
            throw new IllegalArgumentException("Specified colIx (" + col2 + ") is out of range");
        }
        this.field_2_col = column.setValue(this.field_2_col, col2);
    }

    public final int getColumn() {
        return column.getValue(this.field_2_col);
    }

    protected final String formatReferenceAsString() {
        CellReference cr = new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative());
        return cr.formatAsString();
    }

    public final byte getDefaultOperandClass() {
        return 0;
    }
}

