/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnknownRecord;

public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final Class[] CONSTRUCTOR_ARGS = new Class[]{class$org$apache$poi$hssf$record$RecordInputStream == null ? (class$org$apache$poi$hssf$record$RecordInputStream = RecordFactory.class$("org.apache.poi.hssf.record.RecordInputStream")) : class$org$apache$poi$hssf$record$RecordInputStream};
    private static final Class[] records = new Class[]{class$org$apache$poi$hssf$record$ArrayRecord == null ? (class$org$apache$poi$hssf$record$ArrayRecord = RecordFactory.class$("org.apache.poi.hssf.record.ArrayRecord")) : class$org$apache$poi$hssf$record$ArrayRecord, class$org$apache$poi$hssf$record$BackupRecord == null ? (class$org$apache$poi$hssf$record$BackupRecord = RecordFactory.class$("org.apache.poi.hssf.record.BackupRecord")) : class$org$apache$poi$hssf$record$BackupRecord, class$org$apache$poi$hssf$record$BlankRecord == null ? (class$org$apache$poi$hssf$record$BlankRecord = RecordFactory.class$("org.apache.poi.hssf.record.BlankRecord")) : class$org$apache$poi$hssf$record$BlankRecord, class$org$apache$poi$hssf$record$BOFRecord == null ? (class$org$apache$poi$hssf$record$BOFRecord = RecordFactory.class$("org.apache.poi.hssf.record.BOFRecord")) : class$org$apache$poi$hssf$record$BOFRecord, class$org$apache$poi$hssf$record$BookBoolRecord == null ? (class$org$apache$poi$hssf$record$BookBoolRecord = RecordFactory.class$("org.apache.poi.hssf.record.BookBoolRecord")) : class$org$apache$poi$hssf$record$BookBoolRecord, class$org$apache$poi$hssf$record$BoolErrRecord == null ? (class$org$apache$poi$hssf$record$BoolErrRecord = RecordFactory.class$("org.apache.poi.hssf.record.BoolErrRecord")) : class$org$apache$poi$hssf$record$BoolErrRecord, class$org$apache$poi$hssf$record$BottomMarginRecord == null ? (class$org$apache$poi$hssf$record$BottomMarginRecord = RecordFactory.class$("org.apache.poi.hssf.record.BottomMarginRecord")) : class$org$apache$poi$hssf$record$BottomMarginRecord, class$org$apache$poi$hssf$record$BoundSheetRecord == null ? (class$org$apache$poi$hssf$record$BoundSheetRecord = RecordFactory.class$("org.apache.poi.hssf.record.BoundSheetRecord")) : class$org$apache$poi$hssf$record$BoundSheetRecord, class$org$apache$poi$hssf$record$CalcCountRecord == null ? (class$org$apache$poi$hssf$record$CalcCountRecord = RecordFactory.class$("org.apache.poi.hssf.record.CalcCountRecord")) : class$org$apache$poi$hssf$record$CalcCountRecord, class$org$apache$poi$hssf$record$CalcModeRecord == null ? (class$org$apache$poi$hssf$record$CalcModeRecord = RecordFactory.class$("org.apache.poi.hssf.record.CalcModeRecord")) : class$org$apache$poi$hssf$record$CalcModeRecord, class$org$apache$poi$hssf$record$CFHeaderRecord == null ? (class$org$apache$poi$hssf$record$CFHeaderRecord = RecordFactory.class$("org.apache.poi.hssf.record.CFHeaderRecord")) : class$org$apache$poi$hssf$record$CFHeaderRecord, class$org$apache$poi$hssf$record$CFRuleRecord == null ? (class$org$apache$poi$hssf$record$CFRuleRecord = RecordFactory.class$("org.apache.poi.hssf.record.CFRuleRecord")) : class$org$apache$poi$hssf$record$CFRuleRecord, class$org$apache$poi$hssf$record$ChartRecord == null ? (class$org$apache$poi$hssf$record$ChartRecord = RecordFactory.class$("org.apache.poi.hssf.record.ChartRecord")) : class$org$apache$poi$hssf$record$ChartRecord, class$org$apache$poi$hssf$record$ChartTitleFormatRecord == null ? (class$org$apache$poi$hssf$record$ChartTitleFormatRecord = RecordFactory.class$("org.apache.poi.hssf.record.ChartTitleFormatRecord")) : class$org$apache$poi$hssf$record$ChartTitleFormatRecord, class$org$apache$poi$hssf$record$CodepageRecord == null ? (class$org$apache$poi$hssf$record$CodepageRecord = RecordFactory.class$("org.apache.poi.hssf.record.CodepageRecord")) : class$org$apache$poi$hssf$record$CodepageRecord, class$org$apache$poi$hssf$record$ColumnInfoRecord == null ? (class$org$apache$poi$hssf$record$ColumnInfoRecord = RecordFactory.class$("org.apache.poi.hssf.record.ColumnInfoRecord")) : class$org$apache$poi$hssf$record$ColumnInfoRecord, class$org$apache$poi$hssf$record$ContinueRecord == null ? (class$org$apache$poi$hssf$record$ContinueRecord = RecordFactory.class$("org.apache.poi.hssf.record.ContinueRecord")) : class$org$apache$poi$hssf$record$ContinueRecord, class$org$apache$poi$hssf$record$CountryRecord == null ? (class$org$apache$poi$hssf$record$CountryRecord = RecordFactory.class$("org.apache.poi.hssf.record.CountryRecord")) : class$org$apache$poi$hssf$record$CountryRecord, class$org$apache$poi$hssf$record$CRNCountRecord == null ? (class$org$apache$poi$hssf$record$CRNCountRecord = RecordFactory.class$("org.apache.poi.hssf.record.CRNCountRecord")) : class$org$apache$poi$hssf$record$CRNCountRecord, class$org$apache$poi$hssf$record$CRNRecord == null ? (class$org$apache$poi$hssf$record$CRNRecord = RecordFactory.class$("org.apache.poi.hssf.record.CRNRecord")) : class$org$apache$poi$hssf$record$CRNRecord, class$org$apache$poi$hssf$record$DateWindow1904Record == null ? (class$org$apache$poi$hssf$record$DateWindow1904Record = RecordFactory.class$("org.apache.poi.hssf.record.DateWindow1904Record")) : class$org$apache$poi$hssf$record$DateWindow1904Record, class$org$apache$poi$hssf$record$DBCellRecord == null ? (class$org$apache$poi$hssf$record$DBCellRecord = RecordFactory.class$("org.apache.poi.hssf.record.DBCellRecord")) : class$org$apache$poi$hssf$record$DBCellRecord, class$org$apache$poi$hssf$record$DefaultColWidthRecord == null ? (class$org$apache$poi$hssf$record$DefaultColWidthRecord = RecordFactory.class$("org.apache.poi.hssf.record.DefaultColWidthRecord")) : class$org$apache$poi$hssf$record$DefaultColWidthRecord, class$org$apache$poi$hssf$record$DefaultRowHeightRecord == null ? (class$org$apache$poi$hssf$record$DefaultRowHeightRecord = RecordFactory.class$("org.apache.poi.hssf.record.DefaultRowHeightRecord")) : class$org$apache$poi$hssf$record$DefaultRowHeightRecord, class$org$apache$poi$hssf$record$DeltaRecord == null ? (class$org$apache$poi$hssf$record$DeltaRecord = RecordFactory.class$("org.apache.poi.hssf.record.DeltaRecord")) : class$org$apache$poi$hssf$record$DeltaRecord, class$org$apache$poi$hssf$record$DimensionsRecord == null ? (class$org$apache$poi$hssf$record$DimensionsRecord = RecordFactory.class$("org.apache.poi.hssf.record.DimensionsRecord")) : class$org$apache$poi$hssf$record$DimensionsRecord, class$org$apache$poi$hssf$record$DrawingGroupRecord == null ? (class$org$apache$poi$hssf$record$DrawingGroupRecord = RecordFactory.class$("org.apache.poi.hssf.record.DrawingGroupRecord")) : class$org$apache$poi$hssf$record$DrawingGroupRecord, class$org$apache$poi$hssf$record$DrawingRecord == null ? (class$org$apache$poi$hssf$record$DrawingRecord = RecordFactory.class$("org.apache.poi.hssf.record.DrawingRecord")) : class$org$apache$poi$hssf$record$DrawingRecord, class$org$apache$poi$hssf$record$DrawingSelectionRecord == null ? (class$org$apache$poi$hssf$record$DrawingSelectionRecord = RecordFactory.class$("org.apache.poi.hssf.record.DrawingSelectionRecord")) : class$org$apache$poi$hssf$record$DrawingSelectionRecord, class$org$apache$poi$hssf$record$DSFRecord == null ? (class$org$apache$poi$hssf$record$DSFRecord = RecordFactory.class$("org.apache.poi.hssf.record.DSFRecord")) : class$org$apache$poi$hssf$record$DSFRecord, class$org$apache$poi$hssf$record$DVALRecord == null ? (class$org$apache$poi$hssf$record$DVALRecord = RecordFactory.class$("org.apache.poi.hssf.record.DVALRecord")) : class$org$apache$poi$hssf$record$DVALRecord, class$org$apache$poi$hssf$record$DVRecord == null ? (class$org$apache$poi$hssf$record$DVRecord = RecordFactory.class$("org.apache.poi.hssf.record.DVRecord")) : class$org$apache$poi$hssf$record$DVRecord, class$org$apache$poi$hssf$record$EOFRecord == null ? (class$org$apache$poi$hssf$record$EOFRecord = RecordFactory.class$("org.apache.poi.hssf.record.EOFRecord")) : class$org$apache$poi$hssf$record$EOFRecord, class$org$apache$poi$hssf$record$ExtendedFormatRecord == null ? (class$org$apache$poi$hssf$record$ExtendedFormatRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExtendedFormatRecord")) : class$org$apache$poi$hssf$record$ExtendedFormatRecord, class$org$apache$poi$hssf$record$ExternalNameRecord == null ? (class$org$apache$poi$hssf$record$ExternalNameRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExternalNameRecord")) : class$org$apache$poi$hssf$record$ExternalNameRecord, class$org$apache$poi$hssf$record$ExternSheetRecord == null ? (class$org$apache$poi$hssf$record$ExternSheetRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExternSheetRecord")) : class$org$apache$poi$hssf$record$ExternSheetRecord, class$org$apache$poi$hssf$record$ExtSSTRecord == null ? (class$org$apache$poi$hssf$record$ExtSSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExtSSTRecord")) : class$org$apache$poi$hssf$record$ExtSSTRecord, class$org$apache$poi$hssf$record$FilePassRecord == null ? (class$org$apache$poi$hssf$record$FilePassRecord = RecordFactory.class$("org.apache.poi.hssf.record.FilePassRecord")) : class$org$apache$poi$hssf$record$FilePassRecord, class$org$apache$poi$hssf$record$FileSharingRecord == null ? (class$org$apache$poi$hssf$record$FileSharingRecord = RecordFactory.class$("org.apache.poi.hssf.record.FileSharingRecord")) : class$org$apache$poi$hssf$record$FileSharingRecord, class$org$apache$poi$hssf$record$FnGroupCountRecord == null ? (class$org$apache$poi$hssf$record$FnGroupCountRecord = RecordFactory.class$("org.apache.poi.hssf.record.FnGroupCountRecord")) : class$org$apache$poi$hssf$record$FnGroupCountRecord, class$org$apache$poi$hssf$record$FontRecord == null ? (class$org$apache$poi$hssf$record$FontRecord = RecordFactory.class$("org.apache.poi.hssf.record.FontRecord")) : class$org$apache$poi$hssf$record$FontRecord, class$org$apache$poi$hssf$record$FooterRecord == null ? (class$org$apache$poi$hssf$record$FooterRecord = RecordFactory.class$("org.apache.poi.hssf.record.FooterRecord")) : class$org$apache$poi$hssf$record$FooterRecord, class$org$apache$poi$hssf$record$FormatRecord == null ? (class$org$apache$poi$hssf$record$FormatRecord = RecordFactory.class$("org.apache.poi.hssf.record.FormatRecord")) : class$org$apache$poi$hssf$record$FormatRecord, class$org$apache$poi$hssf$record$FormulaRecord == null ? (class$org$apache$poi$hssf$record$FormulaRecord = RecordFactory.class$("org.apache.poi.hssf.record.FormulaRecord")) : class$org$apache$poi$hssf$record$FormulaRecord, class$org$apache$poi$hssf$record$GridsetRecord == null ? (class$org$apache$poi$hssf$record$GridsetRecord = RecordFactory.class$("org.apache.poi.hssf.record.GridsetRecord")) : class$org$apache$poi$hssf$record$GridsetRecord, class$org$apache$poi$hssf$record$GutsRecord == null ? (class$org$apache$poi$hssf$record$GutsRecord = RecordFactory.class$("org.apache.poi.hssf.record.GutsRecord")) : class$org$apache$poi$hssf$record$GutsRecord, class$org$apache$poi$hssf$record$HCenterRecord == null ? (class$org$apache$poi$hssf$record$HCenterRecord = RecordFactory.class$("org.apache.poi.hssf.record.HCenterRecord")) : class$org$apache$poi$hssf$record$HCenterRecord, class$org$apache$poi$hssf$record$HeaderRecord == null ? (class$org$apache$poi$hssf$record$HeaderRecord = RecordFactory.class$("org.apache.poi.hssf.record.HeaderRecord")) : class$org$apache$poi$hssf$record$HeaderRecord, class$org$apache$poi$hssf$record$HideObjRecord == null ? (class$org$apache$poi$hssf$record$HideObjRecord = RecordFactory.class$("org.apache.poi.hssf.record.HideObjRecord")) : class$org$apache$poi$hssf$record$HideObjRecord, class$org$apache$poi$hssf$record$HorizontalPageBreakRecord == null ? (class$org$apache$poi$hssf$record$HorizontalPageBreakRecord = RecordFactory.class$("org.apache.poi.hssf.record.HorizontalPageBreakRecord")) : class$org$apache$poi$hssf$record$HorizontalPageBreakRecord, class$org$apache$poi$hssf$record$HyperlinkRecord == null ? (class$org$apache$poi$hssf$record$HyperlinkRecord = RecordFactory.class$("org.apache.poi.hssf.record.HyperlinkRecord")) : class$org$apache$poi$hssf$record$HyperlinkRecord, class$org$apache$poi$hssf$record$IndexRecord == null ? (class$org$apache$poi$hssf$record$IndexRecord = RecordFactory.class$("org.apache.poi.hssf.record.IndexRecord")) : class$org$apache$poi$hssf$record$IndexRecord, class$org$apache$poi$hssf$record$InterfaceEndRecord == null ? (class$org$apache$poi$hssf$record$InterfaceEndRecord = RecordFactory.class$("org.apache.poi.hssf.record.InterfaceEndRecord")) : class$org$apache$poi$hssf$record$InterfaceEndRecord, class$org$apache$poi$hssf$record$InterfaceHdrRecord == null ? (class$org$apache$poi$hssf$record$InterfaceHdrRecord = RecordFactory.class$("org.apache.poi.hssf.record.InterfaceHdrRecord")) : class$org$apache$poi$hssf$record$InterfaceHdrRecord, class$org$apache$poi$hssf$record$IterationRecord == null ? (class$org$apache$poi$hssf$record$IterationRecord = RecordFactory.class$("org.apache.poi.hssf.record.IterationRecord")) : class$org$apache$poi$hssf$record$IterationRecord, class$org$apache$poi$hssf$record$LabelRecord == null ? (class$org$apache$poi$hssf$record$LabelRecord = RecordFactory.class$("org.apache.poi.hssf.record.LabelRecord")) : class$org$apache$poi$hssf$record$LabelRecord, class$org$apache$poi$hssf$record$LabelSSTRecord == null ? (class$org$apache$poi$hssf$record$LabelSSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.LabelSSTRecord")) : class$org$apache$poi$hssf$record$LabelSSTRecord, class$org$apache$poi$hssf$record$LeftMarginRecord == null ? (class$org$apache$poi$hssf$record$LeftMarginRecord = RecordFactory.class$("org.apache.poi.hssf.record.LeftMarginRecord")) : class$org$apache$poi$hssf$record$LeftMarginRecord, class$org$apache$poi$hssf$record$LegendRecord == null ? (class$org$apache$poi$hssf$record$LegendRecord = RecordFactory.class$("org.apache.poi.hssf.record.LegendRecord")) : class$org$apache$poi$hssf$record$LegendRecord, class$org$apache$poi$hssf$record$MergeCellsRecord == null ? (class$org$apache$poi$hssf$record$MergeCellsRecord = RecordFactory.class$("org.apache.poi.hssf.record.MergeCellsRecord")) : class$org$apache$poi$hssf$record$MergeCellsRecord, class$org$apache$poi$hssf$record$MMSRecord == null ? (class$org$apache$poi$hssf$record$MMSRecord = RecordFactory.class$("org.apache.poi.hssf.record.MMSRecord")) : class$org$apache$poi$hssf$record$MMSRecord, class$org$apache$poi$hssf$record$MulBlankRecord == null ? (class$org$apache$poi$hssf$record$MulBlankRecord = RecordFactory.class$("org.apache.poi.hssf.record.MulBlankRecord")) : class$org$apache$poi$hssf$record$MulBlankRecord, class$org$apache$poi$hssf$record$MulRKRecord == null ? (class$org$apache$poi$hssf$record$MulRKRecord = RecordFactory.class$("org.apache.poi.hssf.record.MulRKRecord")) : class$org$apache$poi$hssf$record$MulRKRecord, class$org$apache$poi$hssf$record$NameRecord == null ? (class$org$apache$poi$hssf$record$NameRecord = RecordFactory.class$("org.apache.poi.hssf.record.NameRecord")) : class$org$apache$poi$hssf$record$NameRecord, class$org$apache$poi$hssf$record$NoteRecord == null ? (class$org$apache$poi$hssf$record$NoteRecord = RecordFactory.class$("org.apache.poi.hssf.record.NoteRecord")) : class$org$apache$poi$hssf$record$NoteRecord, class$org$apache$poi$hssf$record$NumberRecord == null ? (class$org$apache$poi$hssf$record$NumberRecord = RecordFactory.class$("org.apache.poi.hssf.record.NumberRecord")) : class$org$apache$poi$hssf$record$NumberRecord, class$org$apache$poi$hssf$record$ObjectProtectRecord == null ? (class$org$apache$poi$hssf$record$ObjectProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.ObjectProtectRecord")) : class$org$apache$poi$hssf$record$ObjectProtectRecord, class$org$apache$poi$hssf$record$ObjRecord == null ? (class$org$apache$poi$hssf$record$ObjRecord = RecordFactory.class$("org.apache.poi.hssf.record.ObjRecord")) : class$org$apache$poi$hssf$record$ObjRecord, class$org$apache$poi$hssf$record$PaletteRecord == null ? (class$org$apache$poi$hssf$record$PaletteRecord = RecordFactory.class$("org.apache.poi.hssf.record.PaletteRecord")) : class$org$apache$poi$hssf$record$PaletteRecord, class$org$apache$poi$hssf$record$PaneRecord == null ? (class$org$apache$poi$hssf$record$PaneRecord = RecordFactory.class$("org.apache.poi.hssf.record.PaneRecord")) : class$org$apache$poi$hssf$record$PaneRecord, class$org$apache$poi$hssf$record$PasswordRecord == null ? (class$org$apache$poi$hssf$record$PasswordRecord = RecordFactory.class$("org.apache.poi.hssf.record.PasswordRecord")) : class$org$apache$poi$hssf$record$PasswordRecord, class$org$apache$poi$hssf$record$PasswordRev4Record == null ? (class$org$apache$poi$hssf$record$PasswordRev4Record = RecordFactory.class$("org.apache.poi.hssf.record.PasswordRev4Record")) : class$org$apache$poi$hssf$record$PasswordRev4Record, class$org$apache$poi$hssf$record$PrecisionRecord == null ? (class$org$apache$poi$hssf$record$PrecisionRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrecisionRecord")) : class$org$apache$poi$hssf$record$PrecisionRecord, class$org$apache$poi$hssf$record$PrintGridlinesRecord == null ? (class$org$apache$poi$hssf$record$PrintGridlinesRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintGridlinesRecord")) : class$org$apache$poi$hssf$record$PrintGridlinesRecord, class$org$apache$poi$hssf$record$PrintHeadersRecord == null ? (class$org$apache$poi$hssf$record$PrintHeadersRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintHeadersRecord")) : class$org$apache$poi$hssf$record$PrintHeadersRecord, class$org$apache$poi$hssf$record$PrintSetupRecord == null ? (class$org$apache$poi$hssf$record$PrintSetupRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintSetupRecord")) : class$org$apache$poi$hssf$record$PrintSetupRecord, class$org$apache$poi$hssf$record$ProtectionRev4Record == null ? (class$org$apache$poi$hssf$record$ProtectionRev4Record = RecordFactory.class$("org.apache.poi.hssf.record.ProtectionRev4Record")) : class$org$apache$poi$hssf$record$ProtectionRev4Record, class$org$apache$poi$hssf$record$ProtectRecord == null ? (class$org$apache$poi$hssf$record$ProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.ProtectRecord")) : class$org$apache$poi$hssf$record$ProtectRecord, class$org$apache$poi$hssf$record$RecalcIdRecord == null ? (class$org$apache$poi$hssf$record$RecalcIdRecord = RecordFactory.class$("org.apache.poi.hssf.record.RecalcIdRecord")) : class$org$apache$poi$hssf$record$RecalcIdRecord, class$org$apache$poi$hssf$record$RefModeRecord == null ? (class$org$apache$poi$hssf$record$RefModeRecord = RecordFactory.class$("org.apache.poi.hssf.record.RefModeRecord")) : class$org$apache$poi$hssf$record$RefModeRecord, class$org$apache$poi$hssf$record$RefreshAllRecord == null ? (class$org$apache$poi$hssf$record$RefreshAllRecord = RecordFactory.class$("org.apache.poi.hssf.record.RefreshAllRecord")) : class$org$apache$poi$hssf$record$RefreshAllRecord, class$org$apache$poi$hssf$record$RightMarginRecord == null ? (class$org$apache$poi$hssf$record$RightMarginRecord = RecordFactory.class$("org.apache.poi.hssf.record.RightMarginRecord")) : class$org$apache$poi$hssf$record$RightMarginRecord, class$org$apache$poi$hssf$record$RKRecord == null ? (class$org$apache$poi$hssf$record$RKRecord = RecordFactory.class$("org.apache.poi.hssf.record.RKRecord")) : class$org$apache$poi$hssf$record$RKRecord, class$org$apache$poi$hssf$record$RowRecord == null ? (class$org$apache$poi$hssf$record$RowRecord = RecordFactory.class$("org.apache.poi.hssf.record.RowRecord")) : class$org$apache$poi$hssf$record$RowRecord, class$org$apache$poi$hssf$record$SaveRecalcRecord == null ? (class$org$apache$poi$hssf$record$SaveRecalcRecord = RecordFactory.class$("org.apache.poi.hssf.record.SaveRecalcRecord")) : class$org$apache$poi$hssf$record$SaveRecalcRecord, class$org$apache$poi$hssf$record$ScenarioProtectRecord == null ? (class$org$apache$poi$hssf$record$ScenarioProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.ScenarioProtectRecord")) : class$org$apache$poi$hssf$record$ScenarioProtectRecord, class$org$apache$poi$hssf$record$SelectionRecord == null ? (class$org$apache$poi$hssf$record$SelectionRecord = RecordFactory.class$("org.apache.poi.hssf.record.SelectionRecord")) : class$org$apache$poi$hssf$record$SelectionRecord, class$org$apache$poi$hssf$record$SeriesRecord == null ? (class$org$apache$poi$hssf$record$SeriesRecord = RecordFactory.class$("org.apache.poi.hssf.record.SeriesRecord")) : class$org$apache$poi$hssf$record$SeriesRecord, class$org$apache$poi$hssf$record$SeriesTextRecord == null ? (class$org$apache$poi$hssf$record$SeriesTextRecord = RecordFactory.class$("org.apache.poi.hssf.record.SeriesTextRecord")) : class$org$apache$poi$hssf$record$SeriesTextRecord, class$org$apache$poi$hssf$record$SharedFormulaRecord == null ? (class$org$apache$poi$hssf$record$SharedFormulaRecord = RecordFactory.class$("org.apache.poi.hssf.record.SharedFormulaRecord")) : class$org$apache$poi$hssf$record$SharedFormulaRecord, class$org$apache$poi$hssf$record$SSTRecord == null ? (class$org$apache$poi$hssf$record$SSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.SSTRecord")) : class$org$apache$poi$hssf$record$SSTRecord, class$org$apache$poi$hssf$record$StringRecord == null ? (class$org$apache$poi$hssf$record$StringRecord = RecordFactory.class$("org.apache.poi.hssf.record.StringRecord")) : class$org$apache$poi$hssf$record$StringRecord, class$org$apache$poi$hssf$record$StyleRecord == null ? (class$org$apache$poi$hssf$record$StyleRecord = RecordFactory.class$("org.apache.poi.hssf.record.StyleRecord")) : class$org$apache$poi$hssf$record$StyleRecord, class$org$apache$poi$hssf$record$SupBookRecord == null ? (class$org$apache$poi$hssf$record$SupBookRecord = RecordFactory.class$("org.apache.poi.hssf.record.SupBookRecord")) : class$org$apache$poi$hssf$record$SupBookRecord, class$org$apache$poi$hssf$record$TabIdRecord == null ? (class$org$apache$poi$hssf$record$TabIdRecord = RecordFactory.class$("org.apache.poi.hssf.record.TabIdRecord")) : class$org$apache$poi$hssf$record$TabIdRecord, class$org$apache$poi$hssf$record$TableRecord == null ? (class$org$apache$poi$hssf$record$TableRecord = RecordFactory.class$("org.apache.poi.hssf.record.TableRecord")) : class$org$apache$poi$hssf$record$TableRecord, class$org$apache$poi$hssf$record$TextObjectRecord == null ? (class$org$apache$poi$hssf$record$TextObjectRecord = RecordFactory.class$("org.apache.poi.hssf.record.TextObjectRecord")) : class$org$apache$poi$hssf$record$TextObjectRecord, class$org$apache$poi$hssf$record$TopMarginRecord == null ? (class$org$apache$poi$hssf$record$TopMarginRecord = RecordFactory.class$("org.apache.poi.hssf.record.TopMarginRecord")) : class$org$apache$poi$hssf$record$TopMarginRecord, class$org$apache$poi$hssf$record$UncalcedRecord == null ? (class$org$apache$poi$hssf$record$UncalcedRecord = RecordFactory.class$("org.apache.poi.hssf.record.UncalcedRecord")) : class$org$apache$poi$hssf$record$UncalcedRecord, class$org$apache$poi$hssf$record$UseSelFSRecord == null ? (class$org$apache$poi$hssf$record$UseSelFSRecord = RecordFactory.class$("org.apache.poi.hssf.record.UseSelFSRecord")) : class$org$apache$poi$hssf$record$UseSelFSRecord, class$org$apache$poi$hssf$record$VCenterRecord == null ? (class$org$apache$poi$hssf$record$VCenterRecord = RecordFactory.class$("org.apache.poi.hssf.record.VCenterRecord")) : class$org$apache$poi$hssf$record$VCenterRecord, class$org$apache$poi$hssf$record$VerticalPageBreakRecord == null ? (class$org$apache$poi$hssf$record$VerticalPageBreakRecord = RecordFactory.class$("org.apache.poi.hssf.record.VerticalPageBreakRecord")) : class$org$apache$poi$hssf$record$VerticalPageBreakRecord, class$org$apache$poi$hssf$record$WindowOneRecord == null ? (class$org$apache$poi$hssf$record$WindowOneRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowOneRecord")) : class$org$apache$poi$hssf$record$WindowOneRecord, class$org$apache$poi$hssf$record$WindowProtectRecord == null ? (class$org$apache$poi$hssf$record$WindowProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowProtectRecord")) : class$org$apache$poi$hssf$record$WindowProtectRecord, class$org$apache$poi$hssf$record$WindowTwoRecord == null ? (class$org$apache$poi$hssf$record$WindowTwoRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowTwoRecord")) : class$org$apache$poi$hssf$record$WindowTwoRecord, class$org$apache$poi$hssf$record$WriteAccessRecord == null ? (class$org$apache$poi$hssf$record$WriteAccessRecord = RecordFactory.class$("org.apache.poi.hssf.record.WriteAccessRecord")) : class$org$apache$poi$hssf$record$WriteAccessRecord, class$org$apache$poi$hssf$record$WriteProtectRecord == null ? (class$org$apache$poi$hssf$record$WriteProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.WriteProtectRecord")) : class$org$apache$poi$hssf$record$WriteProtectRecord, class$org$apache$poi$hssf$record$WSBoolRecord == null ? (class$org$apache$poi$hssf$record$WSBoolRecord = RecordFactory.class$("org.apache.poi.hssf.record.WSBoolRecord")) : class$org$apache$poi$hssf$record$WSBoolRecord};
    private static Map recordsMap = RecordFactory.recordsToMap(records);
    private static short[] _allKnownRecordSIDs;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RecordInputStream;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ArrayRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BackupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BookBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoolErrRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BottomMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoundSheetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CFHeaderRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CFRuleRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ChartRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ChartTitleFormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CodepageRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ColumnInfoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ContinueRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CountryRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CRNCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CRNRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DateWindow1904Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DBCellRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultColWidthRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultRowHeightRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DeltaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DimensionsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingGroupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingSelectionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DSFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DVALRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DVRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$EOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtendedFormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternalNameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternSheetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FilePassRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FileSharingRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FnGroupCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FontRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FooterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormulaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GridsetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GutsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HeaderRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HideObjRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HorizontalPageBreakRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HyperlinkRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IndexRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceEndRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceHdrRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IterationRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LeftMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LegendRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MergeCellsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MMSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulBlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulRKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NoteRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NumberRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ObjectProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ObjRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PaletteRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PaneRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrecisionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintGridlinesRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintHeadersRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintSetupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectionRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RecalcIdRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefreshAllRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RightMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RowRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SaveRecalcRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ScenarioProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SelectionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SeriesRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SeriesTextRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SharedFormulaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StringRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StyleRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SupBookRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TabIdRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TableRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TextObjectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TopMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$UncalcedRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$UseSelFSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$VCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$VerticalPageBreakRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowOneRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowTwoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WriteAccessRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WriteProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WSBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$Record;

    public static Record[] createRecord(RecordInputStream in) {
        Record retval;
        Constructor constructor = (Constructor)recordsMap.get(new Short(in.getSid()));
        if (constructor == null) {
            return new Record[]{new UnknownRecord(in)};
        }
        try {
            retval = (Record)constructor.newInstance(in);
        }
        catch (InvocationTargetException e2) {
            throw new RecordFormatException("Unable to construct record instance", e2.getTargetException());
        }
        catch (IllegalArgumentException e3) {
            throw new RuntimeException(e3);
        }
        catch (InstantiationException e4) {
            throw new RuntimeException(e4);
        }
        catch (IllegalAccessException e5) {
            throw new RuntimeException(e5);
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            return new Record[]{num};
        }
        if (retval instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            Record[] mulRecs = new Record[mrk.getNumColumns()];
            for (int k = 0; k < mrk.getNumColumns(); ++k) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k));
                nr.setValue(mrk.getRKNumberAt(k));
                mulRecs[k] = nr;
            }
            return mulRecs;
        }
        if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            Record[] mulRecs = new Record[mb.getNumColumns()];
            for (int k = 0; k < mb.getNumColumns(); ++k) {
                BlankRecord br2 = new BlankRecord();
                br2.setColumn((short)(k + mb.getFirstColumn()));
                br2.setRow(mb.getRow());
                br2.setXFIndex(mb.getXFAt(k));
                mulRecs[k] = br2;
            }
            return mulRecs;
        }
        return new Record[]{retval};
    }

    public static short[] getAllKnownRecordSIDs() {
        if (_allKnownRecordSIDs == null) {
            short[] results = new short[recordsMap.size()];
            int i2 = 0;
            Iterator iterator = recordsMap.keySet().iterator();
            while (iterator.hasNext()) {
                Short sid = (Short)iterator.next();
                results[i2++] = sid;
            }
            Arrays.sort(results);
            _allKnownRecordSIDs = results;
        }
        return (short[])_allKnownRecordSIDs.clone();
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        HashSet<Class> uniqueRecClasses = new HashSet<Class>(records.length * 3 / 2);
        for (int i2 = 0; i2 < records.length; ++i2) {
            Constructor constructor;
            short sid;
            Class recClass;
            if (!(class$org$apache$poi$hssf$record$Record == null ? RecordFactory.class$("org.apache.poi.hssf.record.Record") : class$org$apache$poi$hssf$record$Record).isAssignableFrom(recClass = records[i2])) {
                throw new RuntimeException("Invalid record sub-class (" + recClass.getName() + ")");
            }
            if (Modifier.isAbstract(recClass.getModifiers())) {
                throw new RuntimeException("Invalid record class (" + recClass.getName() + ") - must not be abstract");
            }
            if (!uniqueRecClasses.add(recClass)) {
                throw new RuntimeException("duplicate record class (" + recClass.getName() + ")");
            }
            try {
                sid = recClass.getField("sid").getShort(null);
                constructor = recClass.getConstructor(CONSTRUCTOR_ARGS);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            Short key = new Short(sid);
            if (result.containsKey(key)) {
                Class prev = (Class)result.get(key);
                throw new RuntimeException("duplicate record sid 0x" + Integer.toHexString(sid).toUpperCase() + " for classes (" + recClass.getName() + ") and (" + prev.getName() + ")");
            }
            result.put(key, constructor);
        }
        return result;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(512);
        RecordInputStream recStream = new RecordInputStream(in);
        DrawingRecord lastDrawingRecord = new DrawingRecord();
        Record lastRecord = null;
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record[] recs = RecordFactory.createRecord(recStream);
            if (recs.length > 1) {
                for (int k = 0; k < recs.length; ++k) {
                    records.add(recs[k]);
                }
                continue;
            }
            Record record = recs[0];
            if (record == null) continue;
            if (record.getSid() == 235 && lastRecord instanceof DrawingGroupRecord) {
                DrawingGroupRecord lastDGRecord = (DrawingGroupRecord)lastRecord;
                lastDGRecord.join((AbstractEscherHolderRecord)record);
                continue;
            }
            if (record.getSid() == 60) {
                ContinueRecord contRec = (ContinueRecord)record;
                if (lastRecord instanceof ObjRecord || lastRecord instanceof TextObjectRecord) {
                    lastDrawingRecord.processContinueRecord(contRec.getData());
                    records.add(record);
                    continue;
                }
                if (lastRecord instanceof DrawingGroupRecord) {
                    ((DrawingGroupRecord)lastRecord).processContinueRecord(contRec.getData());
                    continue;
                }
                if (lastRecord instanceof StringRecord) {
                    ((StringRecord)lastRecord).processContinueRecord(contRec.getData());
                    continue;
                }
                if (lastRecord instanceof UnknownRecord) {
                    records.add(record);
                    continue;
                }
                throw new RecordFormatException("Unhandled Continue Record");
            }
            lastRecord = record;
            if (record instanceof DrawingRecord) {
                lastDrawingRecord = (DrawingRecord)record;
            }
            records.add(record);
        }
        return records;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

