/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventmodel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.eventmodel.ERFListener;
import org.apache.poi.hssf.eventmodel.EventRecordFactory;
import org.apache.poi.hssf.eventmodel.ModelFactoryListener;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.Record;

public class ModelFactory
implements ERFListener {
    List listeners = new ArrayList(1);
    Model currentmodel;
    boolean lastEOF;

    public void registerListener(ModelFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void run(InputStream stream) {
        EventRecordFactory factory = new EventRecordFactory(this, null);
        this.lastEOF = true;
        factory.processRecords(stream);
    }

    public boolean processRecord(Record rec) {
        if (rec.getSid() == 2057) {
            if (!this.lastEOF) {
                throw new RuntimeException("Not yet handled embedded models");
            }
            BOFRecord bof = (BOFRecord)rec;
            switch (bof.getType()) {
                case 5: {
                    this.currentmodel = new Workbook();
                    break;
                }
                case 16: {
                    this.currentmodel = Sheet.createSheet();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported model type " + bof.getType());
                }
            }
        }
        if (rec.getSid() == 10) {
            this.lastEOF = true;
            this.throwEvent(this.currentmodel);
        } else {
            this.lastEOF = false;
        }
        return true;
    }

    private void throwEvent(Model model) {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            ModelFactoryListener mfl = (ModelFactoryListener)i2.next();
            mfl.process(model);
        }
    }
}

