/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReflectionUtils {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$javaflow$utils$ReflectionUtils == null ? (class$org$apache$commons$javaflow$utils$ReflectionUtils = ReflectionUtils.class$("org.apache.commons.javaflow.utils.ReflectionUtils")) : class$org$apache$commons$javaflow$utils$ReflectionUtils);
    private static Indexer defaultIndexer = new DefaultIndexer();
    private static Matcher defaultMatcher = new DefaultMatcher();
    static /* synthetic */ Class class$org$apache$commons$javaflow$utils$ReflectionUtils;

    public static Map discoverFields(Class pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverFields(pClazz, pMatcher, defaultIndexer);
    }

    public static Map discoverFields(Class pClazz) {
        return ReflectionUtils.discoverFields(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map discoverFields(Class pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug("discovering fields on " + pClazz.getName());
        HashMap result = new HashMap();
        Class current = pClazz;
        do {
            Field[] fields = current.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                String fname = fields[i2].getName();
                if (!pMatcher.matches(fname)) continue;
                pIndexer.put(result, fname, fields[i2]);
                log.debug("discovered field " + fname + " -> " + fields[i2]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Map discoverMethods(Class pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverMethods(pClazz, pMatcher, defaultIndexer);
    }

    public static Map discoverMethods(Class pClazz) {
        return ReflectionUtils.discoverMethods(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map discoverMethods(Class pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug("discovering methods on " + pClazz.getName());
        HashMap result = new HashMap();
        Class current = pClazz;
        do {
            Method[] methods = current.getDeclaredMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                String mname = methods[i2].getName();
                if (!pMatcher.matches(mname)) continue;
                pIndexer.put(result, mname, methods[i2]);
                log.debug("discovered method " + mname + " -> " + methods[i2]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Object cast(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buffer);
        oos.writeObject(o);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        return ois.readObject();
    }

    public static String getClassName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return o.getClass().getName() + "@" + o.hashCode();
    }

    public static String getClassLoaderName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return ReflectionUtils.getClassName(o.getClass().getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultIndexer
    implements Indexer {
        public void put(Map pMap, String pKey, Object pObject) {
            pMap.put(pKey, pObject);
        }
    }

    public static class DefaultMatcher
    implements Matcher {
        public boolean matches(String pName) {
            return true;
        }
    }

    public static interface Indexer {
        public void put(Map var1, String var2, Object var3);
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

