/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.expression;

import org.apache.commons.beanutils.expression.Resolver;

public class DefaultResolver
implements Resolver {
    private static final char NESTED = '.';
    private static final char MAPPED_START = '(';
    private static final char MAPPED_END = ')';
    private static final char INDEXED_START = '[';
    private static final char INDEXED_END = ']';

    public int getIndex(String expression) {
        if (expression == null || expression.length() == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '(') {
                return -1;
            }
            if (c2 != '[') continue;
            int end = expression.indexOf(93, i2);
            if (end < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            String value = expression.substring(i2 + 1, end);
            if (value.length() == 0) {
                throw new IllegalArgumentException("No Index Value");
            }
            int index = 0;
            try {
                index = Integer.parseInt(value, 10);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Invalid index value '" + value + "'");
            }
            return index;
        }
        return -1;
    }

    public String getKey(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '[') {
                return null;
            }
            if (c2 != '(') continue;
            int end = expression.indexOf(41, i2);
            if (end < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            return expression.substring(i2 + 1, end);
        }
        return null;
    }

    public String getProperty(String expression) {
        if (expression == null || expression.length() == 0) {
            return expression;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.') {
                return expression.substring(0, i2);
            }
            if (c2 != '(' && c2 != '[') continue;
            return expression.substring(0, i2);
        }
        return expression;
    }

    public boolean hasNested(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return this.remove(expression) != null;
    }

    public boolean isIndexed(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '(') {
                return false;
            }
            if (c2 != '[') continue;
            return true;
        }
        return false;
    }

    public boolean isMapped(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '[') {
                return false;
            }
            if (c2 != '(') continue;
            return true;
        }
        return false;
    }

    public String next(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        boolean indexed = false;
        boolean mapped = false;
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (indexed) {
                if (c2 != ']') continue;
                return expression.substring(0, i2 + 1);
            }
            if (mapped) {
                if (c2 != ')') continue;
                return expression.substring(0, i2 + 1);
            }
            if (c2 == '.') {
                return expression.substring(0, i2);
            }
            if (c2 == '(') {
                mapped = true;
                continue;
            }
            if (c2 != '[') continue;
            indexed = true;
        }
        return expression;
    }

    public String remove(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        String property = this.next(expression);
        if (expression.length() == property.length()) {
            return null;
        }
        int start = property.length();
        if (expression.charAt(start) == '.') {
            ++start;
        }
        return expression.substring(start);
    }
}

