/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.util.Arrays;
import net.sourceforge.barbecue.output.AbstractOutput;

public class Module {
    protected final int[] bars;
    private String symbol;

    public Module(int[] nArray) {
        this.bars = nArray;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public int widthInBars() {
        int n = 0;
        for (int j = 0; j < this.bars.length; ++j) {
            n += this.bars[j];
        }
        return n;
    }

    protected double draw(AbstractOutput abstractOutput, double d2, double d3) {
        double d4 = 0.0;
        for (int j = 0; j < this.bars.length; ++j) {
            int n = this.bars[j];
            double d5 = (double)n * abstractOutput.getBarWidth();
            d4 += d5;
            abstractOutput.drawBar((int)d2, (int)d3, (int)d5, (int)abstractOutput.getBarHeight(), j % 2 == 0);
            d2 += d5;
        }
        return d4;
    }

    public boolean equals(Object object2) {
        if (this == object2) {
            return true;
        }
        if (!(object2 instanceof Module)) {
            return false;
        }
        Module module = (Module)object2;
        return Arrays.equals(this.bars, module.bars);
    }

    public int hashCode() {
        int n = 0;
        for (int j = 0; j < this.bars.length; ++j) {
            n += (j + 1) * this.bars[j];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.bars.length; ++j) {
            if (j > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.bars[j]);
        }
        return stringBuffer.toString();
    }
}

