/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRViewerController {
    private static final Log log = LogFactory.getLog(JRViewerController.class);
    protected static final int TYPE_FILE_NAME = 1;
    protected static final int TYPE_INPUT_STREAM = 2;
    protected static final int TYPE_OBJECT = 3;
    private ResourceBundle resourceBundle = null;
    private Locale locale = null;
    private final List listeners = new ArrayList();
    protected int type = 1;
    protected boolean isXML = false;
    protected String reportFileName = null;
    protected SimpleFileResolver fileResolver = null;
    protected boolean reloadSupported;
    private JasperPrint jasperPrint = null;
    private int pageIndex = 0;
    private float zoom = 0.0f;
    private boolean fitPage;
    private boolean fitWidth;

    public JRViewerController(Locale locale, ResourceBundle resBundle) {
        this.locale = locale != null ? locale : Locale.getDefault();
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resBundle;
    }

    public void addListener(JRViewerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(JRViewerListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireListeners(int eventCode) {
        if (!this.listeners.isEmpty()) {
            JRViewerEvent event = new JRViewerEvent(this, eventCode);
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                JRViewerListener listener = (JRViewerListener)it.next();
                listener.viewerEvent(event);
            }
        }
    }

    public void loadReport(String fileName, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.load(fileName) : (JasperPrint)JRLoader.loadObject(fileName);
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
        this.fileResolver = new SimpleFileResolver(Arrays.asList(new File(fileName).getParentFile(), new File(".")));
        this.fileResolver.setResolveAbsolutePath(true);
        this.reloadSupported = true;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    public void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.load(is) : (JasperPrint)JRLoader.loadObject(is);
        this.type = 2;
        this.isXML = isXmlReport;
        this.reloadSupported = false;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    public void loadReport(JasperPrint jrPrint) {
        this.jasperPrint = jrPrint;
        this.type = 3;
        this.isXML = false;
        this.reloadSupported = false;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    public void reload() {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Reload failed.", e2);
                }
                this.jasperPrint = null;
                this.setPageIndex(0);
                this.refreshPage();
                this.fireListeners(7);
            }
            this.forceRefresh();
        }
    }

    public boolean hasPages() {
        return this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0;
    }

    public void refreshPage() {
        this.fireListeners(2);
    }

    protected void forceRefresh() {
        this.zoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    public void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.fitPage = false;
            this.fitWidth = false;
            float old = this.zoom;
            this.zoom = newZoom;
            this.fireListeners(4);
            if (this.zoom != old) {
                this.refreshPage();
            }
        }
    }

    public void setPageIndex(int index) {
        if (this.hasPages()) {
            if (index >= 0 && index < this.jasperPrint.getPages().size()) {
                this.pageIndex = index;
                this.fireListeners(3);
            }
        } else {
            this.fireListeners(3);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getBundleString(String key) {
        return this.resourceBundle.getString(key);
    }

    public FileResolver getFileResolver() {
        return this.type == 1 ? this.fileResolver : null;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public int getPageCount() {
        return this.jasperPrint.getPages().size();
    }

    public void clear() {
        this.jasperPrint = null;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isReloadSupported() {
        return this.reloadSupported;
    }

    public boolean isFitPage() {
        return this.fitPage;
    }

    public boolean isFitWidth() {
        return this.fitWidth;
    }

    public void fitPage() {
        this.fireListeners(5);
        this.fitPage = true;
    }

    public void fitWidth() {
        this.fireListeners(6);
        this.fitWidth = true;
    }
}

