/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlBaseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlTemplateWriter
extends JRXmlBaseWriter {
    private static final Log log = LogFactory.getLog(JRXmlTemplateWriter.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final JRTemplate template;
    private final String encoding;

    public static String writeTemplate(JRTemplate template) {
        return JRXmlTemplateWriter.writeTemplate(template, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JRTemplate template, String encoding) {
        StringWriter stringOut = new StringWriter();
        try {
            JRXmlTemplateWriter.writeTemplate(template, stringOut, encoding);
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
        return stringOut.toString();
    }

    public static void writeTemplate(JRTemplate template, OutputStream out) {
        JRXmlTemplateWriter.writeTemplate(template, out, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JRTemplate template, OutputStream out, String encoding) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            JRXmlTemplateWriter.writeTemplate(template, writer, encoding);
        }
        catch (UnsupportedEncodingException e2) {
            throw new JRRuntimeException(e2);
        }
        catch (IOException e3) {
            throw new JRRuntimeException(e3);
        }
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile) {
        JRXmlTemplateWriter.writeTemplateToFile(template, outputFile, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile, String encoding) {
        BufferedOutputStream fileOut = null;
        boolean close = true;
        try {
            fileOut = new BufferedOutputStream(new FileOutputStream(outputFile));
            JRXmlTemplateWriter.writeTemplate(template, fileOut, encoding);
            fileOut.flush();
            close = false;
            fileOut.close();
        }
        catch (FileNotFoundException e2) {
            throw new JRRuntimeException(e2);
        }
        catch (IOException e3) {
            throw new JRRuntimeException(e3);
        }
        finally {
            if (fileOut != null && close) {
                try {
                    fileOut.close();
                }
                catch (IOException e4) {
                    log.warn("Could not close file " + outputFile, e4);
                }
            }
        }
    }

    protected static void writeTemplate(JRTemplate template, Writer out, String encoding) throws IOException {
        JRXmlTemplateWriter writer = new JRXmlTemplateWriter(template, out, encoding);
        writer.write();
        out.flush();
    }

    public JRXmlTemplateWriter(JRTemplate template, Writer out, String encoding) {
        this.template = template;
        this.encoding = encoding;
        this.useWriter(new JRXmlWriteHelper(out));
    }

    public void write() throws IOException {
        this.writer.writeProlog(this.encoding);
        this.writer.writePublicDoctype("jasperTemplate", "-//JasperReports//DTD Template//EN", "http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd");
        this.writer.startElement("jasperTemplate");
        this.writeIncludedTemplates();
        this.writeStyles();
        this.writer.closeElement();
    }

    protected void writeIncludedTemplates() throws IOException {
        JRTemplateReference[] includedTemplates = this.template.getIncludedTemplates();
        if (includedTemplates != null) {
            for (int i2 = 0; i2 < includedTemplates.length; ++i2) {
                JRTemplateReference reference = includedTemplates[i2];
                this.writeIncludedTemplate(reference);
            }
        }
    }

    protected void writeIncludedTemplate(JRTemplateReference reference) throws IOException {
        this.writer.writeCDATAElement("template", reference.getLocation());
    }

    protected void writeStyles() throws IOException {
        JRStyle[] styles = this.template.getStyles();
        if (styles != null) {
            for (int i2 = 0; i2 < styles.length; ++i2) {
                JRStyle style2 = styles[i2];
                this.writeStyle(style2);
            }
        }
    }

    protected boolean toWriteConditionalStyles() {
        return false;
    }
}

