/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;

public class AsynchronousFillHandle {
    protected final JasperReport jasperReport;
    protected final Map parameters;
    protected final JRDataSource dataSource;
    protected final Connection conn;
    protected final JRBaseFiller filler;
    protected final List listeners;
    protected Thread fillThread;
    protected boolean started = false;
    protected boolean running = false;
    protected boolean cancelled = false;
    protected final Object lock;
    protected Integer priority = null;
    protected String threadName;

    protected AsynchronousFillHandle(JasperReport jasperReport, Map parameters, JRDataSource dataSource) throws JRException {
        this(jasperReport, parameters, dataSource, null);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map parameters, Connection conn) throws JRException {
        this(jasperReport, parameters, null, conn);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map parameters) throws JRException {
        this(jasperReport, parameters, null, null);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map parameters, JRDataSource dataSource, Connection conn) throws JRException {
        this.jasperReport = jasperReport;
        this.parameters = parameters;
        this.dataSource = dataSource;
        this.conn = conn;
        this.filler = JRFiller.createFiller(jasperReport);
        this.listeners = new ArrayList();
        this.lock = this;
    }

    public void addListener(AsynchronousFilllListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(AsynchronousFilllListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFill() {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.started) {
                throw new IllegalStateException("Fill already started.");
            }
            this.started = true;
        }
        ReportFiller reportFiller = new ReportFiller();
        this.fillThread = this.threadName == null ? new Thread(reportFiller) : new Thread((Runnable)reportFiller, this.threadName);
        if (this.priority != null) {
            this.fillThread.setPriority(this.priority);
        }
        this.fillThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancellFill() throws JRException {
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.running) {
                throw new IllegalStateException("Fill not running.");
            }
            this.filler.cancelFill();
            this.cancelled = true;
        }
    }

    protected void notifyFinish(JasperPrint print) {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            AsynchronousFilllListener listener = (AsynchronousFilllListener)i2.next();
            listener.reportFinished(print);
        }
    }

    protected void notifyCancel() {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            AsynchronousFilllListener listener = (AsynchronousFilllListener)i2.next();
            listener.reportCancelled();
        }
    }

    protected void notifyError(Throwable e2) {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            AsynchronousFilllListener listener = (AsynchronousFilllListener)i2.next();
            listener.reportFillError(e2);
        }
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map parameters, JRDataSource dataSource) throws JRException {
        AsynchronousFillHandle filler = new AsynchronousFillHandle(jasperReport, parameters, dataSource);
        return filler;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map parameters, Connection conn) throws JRException {
        AsynchronousFillHandle filler = new AsynchronousFillHandle(jasperReport, parameters, conn);
        return filler;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map parameters) throws JRException {
        AsynchronousFillHandle filler = new AsynchronousFillHandle(jasperReport, parameters);
        return filler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.priority = new Integer(priority);
            if (this.fillThread != null) {
                this.fillThread.setPriority(priority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadName(String name) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.threadName = name;
            if (this.fillThread != null) {
                this.fillThread.setName(name);
            }
        }
    }

    protected class ReportFiller
    implements Runnable {
        protected ReportFiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object2 = AsynchronousFillHandle.this.lock;
            synchronized (object2) {
                AsynchronousFillHandle.this.running = true;
            }
            try {
                JasperPrint print = AsynchronousFillHandle.this.conn != null ? AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters, AsynchronousFillHandle.this.conn) : (AsynchronousFillHandle.this.dataSource != null ? AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters, AsynchronousFillHandle.this.dataSource) : AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters));
                AsynchronousFillHandle.this.notifyFinish(print);
            }
            catch (Exception e2) {
                Object object3 = AsynchronousFillHandle.this.lock;
                synchronized (object3) {
                    if (AsynchronousFillHandle.this.cancelled) {
                        AsynchronousFillHandle.this.notifyCancel();
                    } else {
                        AsynchronousFillHandle.this.notifyError(e2);
                    }
                }
            }
            finally {
                Object object4 = AsynchronousFillHandle.this.lock;
                synchronized (object4) {
                    AsynchronousFillHandle.this.running = false;
                }
            }
        }
    }
}

