/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseCrosstabMeasure
implements JRCrosstabMeasure,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name;
    protected String valueClassName;
    protected String valueClassRealName = null;
    protected Class valueClass;
    protected JRExpression expression;
    protected byte calculation = 1;
    protected String incrementerFactoryClassName;
    protected String incrementerFactoryClassRealName;
    protected Class incrementerFactoryClass;
    protected byte percentageOfType = 0;
    protected String percentageCalculatorClassName;
    protected String percentageCalculatorClassRealName;
    protected Class percentageCalculatorClass;
    protected JRVariable variable;

    protected JRBaseCrosstabMeasure() {
    }

    public JRBaseCrosstabMeasure(JRCrosstabMeasure measure, JRBaseObjectFactory factory) {
        factory.put(measure, this);
        this.name = measure.getName();
        this.valueClassName = measure.getValueClassName();
        this.expression = factory.getExpression(measure.getValueExpression());
        this.calculation = measure.getCalculation();
        this.incrementerFactoryClassName = measure.getIncrementerFactoryClassName();
        this.percentageOfType = measure.getPercentageOfType();
        this.percentageCalculatorClassName = measure.getPercentageCalculatorClassName();
        this.variable = factory.getVariable(measure.getVariable());
    }

    public String getName() {
        return this.name;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public JRExpression getValueExpression() {
        return this.expression;
    }

    public byte getCalculation() {
        return this.calculation;
    }

    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    public byte getPercentageOfType() {
        return this.percentageOfType;
    }

    public Class getIncrementerFactoryClass() {
        String className;
        if (this.incrementerFactoryClass == null && (className = this.getIncrementerFactoryClassRealName()) != null) {
            try {
                this.incrementerFactoryClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException("Could not load measure incrementer class", e2);
            }
        }
        return this.incrementerFactoryClass;
    }

    private String getIncrementerFactoryClassRealName() {
        if (this.incrementerFactoryClassRealName == null) {
            this.incrementerFactoryClassRealName = JRClassLoader.getClassRealName(this.incrementerFactoryClassName);
        }
        return this.incrementerFactoryClassRealName;
    }

    public Class getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException("Could not load bucket value class", e2);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    public JRVariable getVariable() {
        return this.variable;
    }

    public String getPercentageCalculatorClassName() {
        return this.percentageCalculatorClassName;
    }

    public Class getPercentageCalculatorClass() {
        String className;
        if (this.percentageCalculatorClass == null && (className = this.getPercentageCalculatorClassRealName()) != null) {
            try {
                this.percentageCalculatorClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException("Could not load measure percentage calculator class", e2);
            }
        }
        return this.percentageCalculatorClass;
    }

    private String getPercentageCalculatorClassRealName() {
        if (this.percentageCalculatorClassRealName == null) {
            this.percentageCalculatorClassRealName = JRClassLoader.getClassRealName(this.percentageCalculatorClassName);
        }
        return this.percentageCalculatorClassRealName;
    }

    public Object clone() {
        try {
            JRBaseCrosstabMeasure clone = (JRBaseCrosstabMeasure)super.clone();
            clone.expression = (JRExpression)JRCloneUtils.nullSafeClone(this.expression);
            clone.variable = (JRVariable)JRCloneUtils.nullSafeClone(this.variable);
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

