/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class Sequence
extends ArrayList
implements GroovyObject {
    private MetaClass metaClass = InvokerHelper.getMetaClass(this);
    private Class type;
    private int hashCode;

    public Sequence() {
        this((Class)null);
    }

    public Sequence(Class type) {
        this.type = type;
    }

    public Sequence(Class type, List content) {
        super(content.size());
        this.type = type;
        this.addAll((Collection)content);
    }

    public void set(Collection collection) {
        this.checkCollectionType(collection);
        this.clear();
        this.addAll(collection);
    }

    public boolean equals(Object that) {
        if (that instanceof Sequence) {
            return this.equals((Sequence)that);
        }
        return false;
    }

    public boolean equals(Sequence that) {
        if (this.size() == that.size()) {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (DefaultTypeTransformation.compareEqual(this.get(i2), that.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                Object value = this.get(i2);
                int hash = value != null ? value.hashCode() : 47806;
                this.hashCode ^= hash;
            }
            if (this.hashCode == 0) {
                this.hashCode = 47806;
            }
        }
        return this.hashCode;
    }

    public int minimumSize() {
        return 0;
    }

    public Class type() {
        return this.type;
    }

    public void add(int index, Object element) {
        this.checkType(element);
        this.hashCode = 0;
        super.add(index, element);
    }

    public boolean add(Object element) {
        this.checkType(element);
        this.hashCode = 0;
        return super.add(element);
    }

    public boolean addAll(Collection c2) {
        this.checkCollectionType(c2);
        this.hashCode = 0;
        return super.addAll(c2);
    }

    public boolean addAll(int index, Collection c2) {
        this.checkCollectionType(c2);
        this.hashCode = 0;
        return super.addAll(index, c2);
    }

    public void clear() {
        this.hashCode = 0;
        super.clear();
    }

    public Object remove(int index) {
        this.hashCode = 0;
        return super.remove(index);
    }

    protected void removeRange(int fromIndex, int toIndex) {
        this.hashCode = 0;
        super.removeRange(fromIndex, toIndex);
    }

    public Object set(int index, Object element) {
        this.hashCode = 0;
        return super.set(index, element);
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException e2) {
            ArrayList<Object> answer = new ArrayList<Object>(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object value = InvokerHelper.invokeMethod(element, name, args);
                answer.add(value);
            }
            return answer;
        }
    }

    public Object getProperty(String property) {
        return this.getMetaClass().getProperty(this, property);
    }

    public void setProperty(String property, Object newValue) {
        this.getMetaClass().setProperty(this, property, newValue);
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    protected void checkCollectionType(Collection c2) {
        if (this.type != null) {
            Iterator iter = c2.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                this.checkType(element);
            }
        }
    }

    protected void checkType(Object object2) {
        if (object2 == null) {
            throw new NullPointerException("Sequences cannot contain null, use a List instead");
        }
        if (this.type != null && !this.type.isInstance(object2)) {
            throw new IllegalArgumentException("Invalid type of argument for sequence of type: " + this.type.getName() + " cannot add object: " + object2);
        }
    }
}

