/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.ElementFactory;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.xml.simpleparser.EntitiesToSymbol;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;
    float topMargin = 36.0f;
    float rightMargin = 36.0f;
    float leftMargin = 36.0f;
    float bottomMargin = 36.0f;
    protected HashMap myTags;
    private BaseFont bf = null;
    static /* synthetic */ Class class$com$lowagie$text$PageSize;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap) {
        this(docListener);
        this.myTags = htmlTagMap;
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap, BaseFont baseFont) {
        this(docListener, htmlTagMap);
        this.bf = baseFont;
    }

    public SAXiTextHandler(DocListener docListener, HashMap hashMap) {
        this(docListener);
        this.myTags = hashMap;
    }

    public void setControlOpenClose(boolean bl) {
        this.controlOpenClose = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Properties properties = new Properties();
        if (attributes != null) {
            for (int j = 0; j < attributes.getLength(); ++j) {
                String string4 = attributes.getQName(j);
                properties.setProperty(string4, attributes.getValue(j));
            }
        }
        this.handleStartingTags(string3, properties);
    }

    public void handleStartingTags(String string, Properties properties) {
        Object object2;
        if (this.ignore || "ignore".equals(string)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                object2 = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object2 = this.bf == null ? new Paragraph("", new Font()) : new Paragraph("", new Font(this.bf));
            }
            object2.add(this.currentChunk);
            this.stack.push(object2);
            this.currentChunk = null;
        }
        if ("chunk".equals(string)) {
            this.currentChunk = ElementFactory.getChunk(properties);
            if (this.bf != null) {
                this.currentChunk.setFont(new Font(this.bf));
            }
            return;
        }
        if ("entity".equals(string)) {
            object2 = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object2 = this.currentChunk.getFont();
            }
            this.currentChunk = EntitiesToSymbol.get(properties.getProperty("id"), (Font)object2);
            return;
        }
        if ("phrase".equals(string)) {
            this.stack.push(ElementFactory.getPhrase(properties));
            return;
        }
        if ("anchor".equals(string)) {
            this.stack.push(ElementFactory.getAnchor(properties));
            return;
        }
        if ("paragraph".equals(string) || "title".equals(string)) {
            this.stack.push(ElementFactory.getParagraph(properties));
            return;
        }
        if ("list".equals(string)) {
            this.stack.push(ElementFactory.getList(properties));
            return;
        }
        if ("listitem".equals(string)) {
            this.stack.push(ElementFactory.getListItem(properties));
            return;
        }
        if ("cell".equals(string)) {
            this.stack.push(ElementFactory.getCell(properties));
            return;
        }
        if ("table".equals(string)) {
            object2 = ElementFactory.getTable(properties);
            float[] fArray = ((Table)object2).getProportionalWidths();
            for (int j = 0; j < fArray.length; ++j) {
                if (fArray[j] != 0.0f) continue;
                fArray[j] = 100.0f / (float)fArray.length;
            }
            try {
                ((Table)object2).setWidths(fArray);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
            this.stack.push(object2);
            return;
        }
        if ("section".equals(string)) {
            Section section;
            object2 = (Element)this.stack.pop();
            try {
                section = ElementFactory.getSection((Section)object2, properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter(classCastException);
            }
            this.stack.push(object2);
            this.stack.push(section);
            return;
        }
        if ("chapter".equals(string)) {
            this.stack.push(ElementFactory.getChapter(properties));
            return;
        }
        if ("image".equals(string)) {
            try {
                object2 = ElementFactory.getImage(properties);
                try {
                    this.addImage((Image)object2);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object2);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if ("annotation".equals(string)) {
            object2 = ElementFactory.getAnnotation(properties);
            try {
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    try {
                        textElementArray.add(object2);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object2);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object2);
                }
                return;
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        if (this.isNewline(string)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add(Chunk.NEWLINE);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(string)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                Chunk chunk = new Chunk("");
                chunk.setNewPage();
                if (this.bf != null) {
                    chunk.setFont(new Font(this.bf));
                }
                object2.add(chunk);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                this.document.newPage();
            }
            return;
        }
        if ("horizontalrule".equals(string)) {
            LineSeparator lineSeparator = new LineSeparator(1.0f, 100.0f, null, 1, 0.0f);
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add(lineSeparator);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add(lineSeparator);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            return;
        }
        if (this.isDocumentRoot(string)) {
            Rectangle rectangle = null;
            String string2 = null;
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                String string3 = properties.getProperty((String)object2);
                try {
                    if ("left".equalsIgnoreCase((String)object2)) {
                        this.leftMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("right".equalsIgnoreCase((String)object2)) {
                        this.rightMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("top".equalsIgnoreCase((String)object2)) {
                        this.topMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("bottom".equalsIgnoreCase((String)object2)) {
                        this.bottomMargin = Float.parseFloat(string3 + "f");
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                if ("pagesize".equals(object2)) {
                    try {
                        String string4 = string3;
                        Field field = (class$com$lowagie$text$PageSize == null ? SAXiTextHandler.class$("com.lowagie.text.PageSize") : class$com$lowagie$text$PageSize).getField(string4);
                        rectangle = (Rectangle)field.get(null);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                if ("orientation".equals(object2)) {
                    try {
                        if (!"landscape".equals(string3)) continue;
                        string2 = "landscape";
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                try {
                    this.document.add(new Meta((String)object2, string3));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (rectangle != null) {
                if ("landscape".equals(string2)) {
                    rectangle = rectangle.rotate();
                }
                this.document.setPageSize(rectangle);
            }
            this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    protected void addImage(Image image) throws EmptyStackException {
        Object e2 = this.stack.pop();
        if (e2 instanceof Chapter || e2 instanceof Section || e2 instanceof Cell) {
            ((TextElementArray)e2).add(image);
            this.stack.push(e2);
            return;
        }
        Stack stack = new Stack();
        while (!(e2 instanceof Chapter || e2 instanceof Section || e2 instanceof Cell)) {
            stack.push(e2);
            if (e2 instanceof Anchor) {
                image.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)e2).getReference()));
            }
            e2 = this.stack.pop();
        }
        ((TextElementArray)e2).add(image);
        this.stack.push(e2);
        while (!stack.empty()) {
            this.stack.push(stack.pop());
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.ignore) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0 && string.indexOf(32) < 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        block6: for (int j = 0; j < n3; ++j) {
            char c2 = string.charAt(j);
            switch (c2) {
                case ' ': {
                    if (bl) continue block6;
                    stringBuffer.append(c2);
                    continue block6;
                }
                case '\n': {
                    if (j <= 0) continue block6;
                    bl = true;
                    stringBuffer.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c2);
                }
            }
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.bf == null ? new Chunk(stringBuffer.toString()) : new Chunk(stringBuffer.toString(), new Font(this.bf));
        } else {
            this.currentChunk.append(stringBuffer.toString());
        }
    }

    public void setBaseFont(BaseFont baseFont) {
        this.bf = baseFont;
    }

    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    public void handleEndingTags(String string) {
        if ("ignore".equals(string)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.isNewpage(string) || "annotation".equals(string) || "image".equals(string) || this.isNewline(string)) {
            return;
        }
        try {
            TextElementArray textElementArray;
            Object object2;
            if ("title".equals(string)) {
                Paragraph paragraph = (Paragraph)this.stack.pop();
                if (this.currentChunk != null) {
                    paragraph.add(this.currentChunk);
                    this.currentChunk = null;
                }
                Section section = (Section)this.stack.pop();
                section.setTitle(paragraph);
                this.stack.push(section);
                return;
            }
            if (this.currentChunk != null) {
                try {
                    object2 = (TextElementArray)this.stack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    object2 = new Paragraph();
                }
                object2.add(this.currentChunk);
                this.stack.push(object2);
                this.currentChunk = null;
            }
            if ("chunk".equals(string)) {
                return;
            }
            if ("phrase".equals(string) || "anchor".equals(string) || "list".equals(string) || "paragraph".equals(string)) {
                object2 = (Element)this.stack.pop();
                try {
                    TextElementArray textElementArray2 = (TextElementArray)this.stack.pop();
                    textElementArray2.add(object2);
                    this.stack.push(textElementArray2);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object2);
                }
                return;
            }
            if ("listitem".equals(string)) {
                object2 = (ListItem)this.stack.pop();
                textElementArray = (List)this.stack.pop();
                ((List)textElementArray).add(object2);
                this.stack.push(textElementArray);
            }
            if ("table".equals(string)) {
                object2 = (Table)this.stack.pop();
                try {
                    textElementArray = (TextElementArray)this.stack.pop();
                    textElementArray.add(object2);
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object2);
                }
                return;
            }
            if ("row".equals(string)) {
                Cell cell;
                Object object3;
                object2 = new ArrayList();
                int n = 0;
                while ((object3 = (Element)this.stack.pop()).type() == 20) {
                    cell = (Cell)object3;
                    n += cell.getColspan();
                    ((ArrayList)object2).add(cell);
                }
                Table table2 = (Table)object3;
                if (table2.getColumns() < n) {
                    table2.addColumns(n - table2.getColumns());
                }
                Collections.reverse(object2);
                float[] fArray = new float[n];
                boolean[] blArray = new boolean[n];
                for (int j = 0; j < n; ++j) {
                    fArray[j] = 0.0f;
                    blArray[j] = true;
                }
                float f2 = 0.0f;
                int n2 = 0;
                Object object4 = ((ArrayList)object2).iterator();
                while (object4.hasNext()) {
                    cell = (Cell)object4.next();
                    object3 = cell.getWidthAsString();
                    if (cell.getWidth() == 0.0f) {
                        if (cell.getColspan() == 1 && fArray[n2] == 0.0f) {
                            try {
                                fArray[n2] = 100.0f / (float)n;
                                f2 += fArray[n2];
                            }
                            catch (Exception exception) {}
                        } else if (cell.getColspan() == 1) {
                            blArray[n2] = false;
                        }
                    } else if (cell.getColspan() == 1 && ((String)object3).endsWith("%")) {
                        try {
                            fArray[n2] = Float.parseFloat(((String)object3).substring(0, ((String)object3).length() - 1) + "f");
                            f2 += fArray[n2];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    n2 += cell.getColspan();
                    table2.addCell(cell);
                }
                object4 = table2.getProportionalWidths();
                if (((Object)object4).length == n) {
                    int n3;
                    float f3 = 0.0f;
                    for (n3 = 0; n3 < n; ++n3) {
                        if (!blArray[n3] || object4[n3] == 0.0f) continue;
                        f3 += object4[n3];
                        fArray[n3] = (float)object4[n3];
                    }
                    if (100.0 >= (double)f2) {
                        for (n3 = 0; n3 < ((Object)object4).length; ++n3) {
                            if (fArray[n3] != 0.0f || object4[n3] == 0.0f) continue;
                            fArray[n3] = (float)(object4[n3] / f3 * (100.0f - f2));
                        }
                    }
                    table2.setWidths(fArray);
                }
                this.stack.push(table2);
            }
            if ("cell".equals(string)) {
                return;
            }
            if ("section".equals(string)) {
                this.stack.pop();
                return;
            }
            if ("chapter".equals(string)) {
                this.document.add((Element)this.stack.pop());
                return;
            }
            if (this.isDocumentRoot(string)) {
                try {
                    while (true) {
                        object2 = (Element)this.stack.pop();
                        try {
                            TextElementArray textElementArray3 = (TextElementArray)this.stack.pop();
                            textElementArray3.add(object2);
                            this.stack.push(textElementArray3);
                        }
                        catch (EmptyStackException emptyStackException) {
                            this.document.add((Element)object2);
                        }
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    if (this.controlOpenClose) {
                        this.document.close();
                    }
                    return;
                }
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    private boolean isNewpage(String string) {
        return "newpage".equals(string);
    }

    private boolean isNewline(String string) {
        return "newline".equals(string);
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

