/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.draw.DrawInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int START_COLUMN = 0;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected BidiLine bidiLine;
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected PdfContentByte[] canvases;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    protected boolean rectangularMode = false;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private float firstLineY;
    private boolean firstLineYDone = false;
    private int arabicOptions = 0;
    protected float descender;
    protected boolean composite = false;
    protected ColumnText compositeColumn;
    protected LinkedList compositeElements;
    protected int listIdx = 0;
    private boolean splittedRow;
    protected Phrase waitPhrase;
    private boolean useAscender = false;
    private float filledWidth;
    private boolean adjustFirstLine = true;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
    }

    public static ColumnText duplicate(ColumnText columnText) {
        ColumnText columnText2 = new ColumnText(null);
        columnText2.setACopy(columnText);
        return columnText2;
    }

    public ColumnText setACopy(ColumnText columnText) {
        this.setSimpleVars(columnText);
        if (columnText.bidiLine != null) {
            this.bidiLine = new BidiLine(columnText.bidiLine);
        }
        return this;
    }

    protected void setSimpleVars(ColumnText columnText) {
        this.maxY = columnText.maxY;
        this.minY = columnText.minY;
        this.alignment = columnText.alignment;
        this.leftWall = null;
        if (columnText.leftWall != null) {
            this.leftWall = new ArrayList(columnText.leftWall);
        }
        this.rightWall = null;
        if (columnText.rightWall != null) {
            this.rightWall = new ArrayList(columnText.rightWall);
        }
        this.yLine = columnText.yLine;
        this.currentLeading = columnText.currentLeading;
        this.fixedLeading = columnText.fixedLeading;
        this.multipliedLeading = columnText.multipliedLeading;
        this.canvas = columnText.canvas;
        this.canvases = columnText.canvases;
        this.lineStatus = columnText.lineStatus;
        this.indent = columnText.indent;
        this.followingIndent = columnText.followingIndent;
        this.rightIndent = columnText.rightIndent;
        this.extraParagraphSpace = columnText.extraParagraphSpace;
        this.rectangularWidth = columnText.rectangularWidth;
        this.rectangularMode = columnText.rectangularMode;
        this.spaceCharRatio = columnText.spaceCharRatio;
        this.lastWasNewline = columnText.lastWasNewline;
        this.linesWritten = columnText.linesWritten;
        this.arabicOptions = columnText.arabicOptions;
        this.runDirection = columnText.runDirection;
        this.descender = columnText.descender;
        this.composite = columnText.composite;
        this.splittedRow = columnText.splittedRow;
        if (columnText.composite) {
            this.compositeElements = new LinkedList(columnText.compositeElements);
            if (this.splittedRow) {
                PdfPTable pdfPTable = (PdfPTable)this.compositeElements.getFirst();
                this.compositeElements.set(0, new PdfPTable(pdfPTable));
            }
            if (columnText.compositeColumn != null) {
                this.compositeColumn = ColumnText.duplicate(columnText.compositeColumn);
            }
        }
        this.listIdx = columnText.listIdx;
        this.firstLineY = columnText.firstLineY;
        this.leftX = columnText.leftX;
        this.rightX = columnText.rightX;
        this.firstLineYDone = columnText.firstLineYDone;
        this.waitPhrase = columnText.waitPhrase;
        this.useAscender = columnText.useAscender;
        this.filledWidth = columnText.filledWidth;
        this.adjustFirstLine = columnText.adjustFirstLine;
    }

    private void addWaitingPhrase() {
        if (this.bidiLine == null && this.waitPhrase != null) {
            this.bidiLine = new BidiLine();
            Iterator iterator = this.waitPhrase.getChunks().iterator();
            while (iterator.hasNext()) {
                this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
            }
            this.waitPhrase = null;
        }
    }

    public void addText(Phrase phrase) {
        if (phrase == null || this.composite) {
            return;
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            this.waitPhrase = phrase;
            return;
        }
        Iterator iterator = phrase.getChunks().iterator();
        while (iterator.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void setText(Phrase phrase) {
        this.bidiLine = null;
        this.composite = false;
        this.compositeColumn = null;
        this.compositeElements = null;
        this.listIdx = 0;
        this.splittedRow = false;
        this.waitPhrase = phrase;
    }

    public void addText(Chunk chunk) {
        if (chunk == null || this.composite) {
            return;
        }
        this.addText(new Phrase(chunk));
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof Image) {
            Image image = (Image)element;
            PdfPTable pdfPTable = new PdfPTable(1);
            float f2 = image.getWidthPercentage();
            if (f2 == 0.0f) {
                pdfPTable.setTotalWidth(image.getScaledWidth());
                pdfPTable.setLockedWidth(true);
            } else {
                pdfPTable.setWidthPercentage(f2);
            }
            pdfPTable.setSpacingAfter(image.getSpacingAfter());
            pdfPTable.setSpacingBefore(image.getSpacingBefore());
            switch (image.getAlignment()) {
                case 0: {
                    pdfPTable.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    pdfPTable.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    pdfPTable.setHorizontalAlignment(1);
                }
            }
            PdfPCell pdfPCell = new PdfPCell(image, true);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setBorder(image.getBorder());
            pdfPCell.setBorderColor(image.getBorderColor());
            pdfPCell.setBorderWidth(image.getBorderWidth());
            pdfPCell.setBackgroundColor(image.getBackgroundColor());
            pdfPTable.addCell(pdfPCell);
            element = pdfPTable;
        }
        if (element.type() == 10) {
            element = new Paragraph((Chunk)element);
        } else if (element.type() == 11) {
            element = new Paragraph((Phrase)element);
        }
        if (element instanceof SimpleTable) {
            try {
                element = ((SimpleTable)element).createPdfPTable();
            }
            catch (DocumentException documentException) {
                throw new IllegalArgumentException("Element not allowed.");
            }
        } else if (element.type() != 12 && element.type() != 14 && element.type() != 23 && element.type() != 55) {
            throw new IllegalArgumentException("Element not allowed.");
        }
        if (!this.composite) {
            this.composite = true;
            this.compositeElements = new LinkedList();
            this.bidiLine = null;
            this.waitPhrase = null;
        }
        this.compositeElements.add(element);
    }

    protected ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (int j = 0; j < fArray.length - 2; j += 2) {
            float f2 = fArray[j];
            float f3 = fArray[j + 1];
            float f4 = fArray[j + 2];
            float f5 = fArray[j + 3];
            if (f3 == f5) continue;
            float f6 = (f2 - f4) / (f3 - f5);
            float f7 = f2 - f6 * f3;
            float[] fArray2 = new float[]{Math.min(f3, f5), Math.max(f3, f5), f6, f7};
            arrayList.add(fArray2);
            this.maxY = Math.max(this.maxY, fArray2[1]);
            this.minY = Math.min(this.minY, fArray2[0]);
        }
        if (arrayList.isEmpty()) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    protected float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        for (int j = 0; j < arrayList.size(); ++j) {
            float[] fArray = (float[])arrayList.get(j);
            if (this.yLine < fArray[0] || this.yLine > fArray[1]) continue;
            return fArray[2] * this.yLine + fArray[3];
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float f2 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f3 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f2, f3};
    }

    protected float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        boolean bl = false;
        while (true) {
            if (bl && this.currentLeading == 0.0f) {
                return null;
            }
            bl = true;
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.maxY = -1.0E21f;
        this.minY = 1.0E21f;
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
        this.rectangularMode = false;
    }

    public void setSimpleColumn(Phrase phrase, float f2, float f3, float f4, float f5, float f6, int n) {
        this.addText(phrase);
        this.setSimpleColumn(f2, f3, f4, f5, f6, n);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5, float f6, int n) {
        this.setLeading(f6);
        this.alignment = n;
        this.setSimpleColumn(f2, f3, f4, f5);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5) {
        this.leftX = Math.min(f2, f4);
        this.maxY = Math.max(f3, f5);
        this.minY = Math.min(f3, f5);
        this.rightX = Math.max(f2, f4);
        this.yLine = this.maxY;
        this.rectangularWidth = this.rightX - this.leftX;
        if (this.rectangularWidth < 0.0f) {
            this.rectangularWidth = 0.0f;
        }
        this.rectangularMode = true;
    }

    public void setLeading(float f2) {
        this.fixedLeading = f2;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f2, float f3) {
        this.fixedLeading = f2;
        this.multipliedLeading = f3;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f2) {
        this.yLine = f2;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f2) {
        this.indent = f2;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f2) {
        this.followingIndent = f2;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f2) {
        this.rightIndent = f2;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl) throws DocumentException {
        int n;
        PdfContentByte pdfContentByte;
        boolean bl2;
        block28: {
            if (this.composite) {
                return this.goComposite(bl);
            }
            this.addWaitingPhrase();
            if (this.bidiLine == null) {
                return 1;
            }
            this.descender = 0.0f;
            this.linesWritten = 0;
            bl2 = false;
            float f2 = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f3 = new Float(0.0f);
            objectArray[1] = f3;
            PdfDocument pdfDocument = null;
            PdfContentByte pdfContentByte2 = null;
            pdfContentByte = null;
            this.firstLineY = Float.NaN;
            int n2 = 1;
            if (this.runDirection != 0) {
                n2 = this.runDirection;
            }
            if (this.canvas != null) {
                pdfContentByte2 = this.canvas;
                pdfDocument = this.canvas.getPdfDocument();
                pdfContentByte = this.canvas.getDuplicate();
            } else if (!bl) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl) {
                if (f2 == 0.0f) {
                    f2 = pdfContentByte.getPdfWriter().getSpaceCharRatio();
                } else if (f2 < 0.001f) {
                    f2 = 0.001f;
                }
            }
            float f4 = 0.0f;
            n = 0;
            if (this.rectangularMode) {
                while (true) {
                    float f5 = f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= f4 + this.rightIndent) {
                        n = 2;
                        if (this.bidiLine.isEmpty()) {
                            n |= 1;
                        }
                        break block28;
                    }
                    if (this.bidiLine.isEmpty()) {
                        n = 1;
                        break block28;
                    }
                    PdfLine pdfLine = this.bidiLine.processLine(this.leftX, this.rectangularWidth - f4 - this.rightIndent, this.alignment, n2, this.arabicOptions);
                    if (pdfLine == null) {
                        n = 1;
                        break block28;
                    }
                    float f6 = pdfLine.getMaxSizeSimple();
                    this.currentLeading = this.isUseAscender() && Float.isNaN(this.firstLineY) ? pdfLine.getAscender() : this.fixedLeading + f6 * this.multipliedLeading;
                    if (this.yLine > this.maxY || this.yLine - this.currentLeading < this.minY) {
                        n = 2;
                        this.bidiLine.restore();
                        break block28;
                    }
                    this.yLine -= this.currentLeading;
                    if (!bl && !bl2) {
                        pdfContentByte.beginText();
                        bl2 = true;
                    }
                    if (Float.isNaN(this.firstLineY)) {
                        this.firstLineY = this.yLine;
                    }
                    this.updateFilledWidth(this.rectangularWidth - pdfLine.widthLeft());
                    if (!bl) {
                        objectArray[0] = pdfFont;
                        pdfContentByte.setTextMatrix(this.leftX + (pdfLine.isRTL() ? this.rightIndent : f4) + pdfLine.indentLeft(), this.yLine);
                        pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    this.lastWasNewline = pdfLine.isNewlineSplit();
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = pdfLine.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine pdfLine;
                f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                float f7 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n = 2;
                    if (this.bidiLine.isEmpty()) {
                        n |= 1;
                    }
                    this.yLine = f7;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    n = 1;
                    this.yLine = f7;
                    break;
                }
                float f8 = Math.max(fArray[0], fArray[2]);
                float f9 = Math.min(fArray[1], fArray[3]);
                if (f9 - f8 <= f4 + this.rightIndent) continue;
                if (!bl && !bl2) {
                    pdfContentByte.beginText();
                    bl2 = true;
                }
                if ((pdfLine = this.bidiLine.processLine(f8, f9 - f8 - f4 - this.rightIndent, this.alignment, n2, this.arabicOptions)) == null) {
                    n = 1;
                    this.yLine = f7;
                    break;
                }
                if (!bl) {
                    objectArray[0] = pdfFont;
                    pdfContentByte.setTextMatrix(f8 + (pdfLine.isRTL() ? this.rightIndent : f4) + pdfLine.indentLeft(), this.yLine);
                    pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                    pdfFont = (PdfFont)objectArray[0];
                }
                this.lastWasNewline = pdfLine.isNewlineSplit();
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = pdfLine.getDescender();
            }
        }
        if (bl2) {
            pdfContentByte.endText();
            this.canvas.add(pdfContentByte);
        }
        return n;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }

    public void clearChunks() {
        if (this.bidiLine != null) {
            this.bidiLine.clearChunks();
        }
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2;
    }

    public void setRunDirection(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n) {
        this.arabicOptions = n;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int n, int n2) {
        ColumnText columnText = new ColumnText(null);
        columnText.addText(phrase);
        columnText.addWaitingPhrase();
        PdfLine pdfLine = columnText.bidiLine.processLine(0.0f, 20000.0f, 0, n, n2);
        if (pdfLine == null) {
            return 0.0f;
        }
        return 20000.0f - pdfLine.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f2, float f3, float f4, int n2, int n3) {
        if (n != 0 && n != 1 && n != 2) {
            n = 0;
        }
        pdfContentByte.saveState();
        ColumnText columnText = new ColumnText(pdfContentByte);
        if (f4 == 0.0f) {
            if (n == 0) {
                columnText.setSimpleColumn(phrase, f2, f3 - 1.0f, 20000.0f + f2, f3 + 2.0f, 2.0f, n);
            } else if (n == 2) {
                columnText.setSimpleColumn(phrase, f2 - 20000.0f, f3 - 1.0f, f2, f3 + 2.0f, 2.0f, n);
            } else {
                columnText.setSimpleColumn(phrase, f2 - 20000.0f, f3 - 1.0f, f2 + 20000.0f, f3 + 2.0f, 2.0f, n);
            }
        } else {
            double d2 = (double)f4 * Math.PI / 180.0;
            float f5 = (float)Math.cos(d2);
            float f6 = (float)Math.sin(d2);
            pdfContentByte.concatCTM(f5, f6, -f6, f5, f2, f3);
            if (n == 0) {
                columnText.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
            } else if (n == 2) {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, n);
            } else {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
            }
        }
        if (n2 == 3) {
            if (n == 0) {
                n = 2;
            } else if (n == 2) {
                n = 0;
            }
        }
        columnText.setAlignment(n);
        columnText.setArabicOptions(n3);
        columnText.setRunDirection(n2);
        try {
            columnText.go();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        pdfContentByte.restoreState();
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f2, float f3, float f4) {
        ColumnText.showTextAligned(pdfContentByte, n, phrase, f2, f3, f4, 1, 0);
    }

    protected int goComposite(boolean bl) throws DocumentException {
        if (!this.rectangularMode) {
            throw new DocumentException("Irregular columns are not supported in composite mode.");
        }
        this.linesWritten = 0;
        this.descender = 0.0f;
        boolean bl2 = this.adjustFirstLine;
        block4: while (!this.compositeElements.isEmpty()) {
            boolean bl3;
            int n;
            int n2;
            int n3;
            float f2;
            Object object2;
            Element element = (Element)this.compositeElements.getFirst();
            if (element.type() == 12) {
                object2 = (Paragraph)element;
                int n4 = 0;
                for (int j = 0; j < 2; ++j) {
                    f2 = this.yLine;
                    boolean bl4 = false;
                    if (this.compositeColumn == null) {
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender(bl2 ? this.useAscender : false);
                        this.compositeColumn.setAlignment(((Paragraph)object2).getAlignment());
                        this.compositeColumn.setIndent(((Paragraph)object2).getIndentationLeft() + ((Paragraph)object2).getFirstLineIndent());
                        this.compositeColumn.setExtraParagraphSpace(((Paragraph)object2).getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(((Paragraph)object2).getIndentationLeft());
                        this.compositeColumn.setRightIndent(((Paragraph)object2).getIndentationRight());
                        this.compositeColumn.setLeading(((Phrase)object2).getLeading(), ((Paragraph)object2).getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText((Phrase)object2);
                        if (!bl2) {
                            this.yLine -= ((Paragraph)object2).spacingBefore();
                        }
                        bl4 = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    n3 = ((Paragraph)object2).getKeepTogether() && bl4 && !bl2 ? 1 : 0;
                    n4 = this.compositeColumn.go(bl || n3 != 0 && j == 0);
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((n4 & 1) == 0 && n3 != 0) {
                        this.compositeColumn = null;
                        this.yLine = f2;
                        return 2;
                    }
                    if (bl || n3 == 0) break;
                    if (j != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = f2;
                }
                bl2 = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                if (n4 & true) {
                    this.compositeColumn = null;
                    this.compositeElements.removeFirst();
                    this.yLine -= ((Paragraph)object2).spacingAfter();
                }
                if ((n4 & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 14) {
                object2 = (List)element;
                ArrayList arrayList = ((List)object2).getItems();
                ListItem listItem = null;
                f2 = ((List)object2).getIndentationLeft();
                int n5 = 0;
                Stack<Object[]> stack = new Stack<Object[]>();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    Object e2 = arrayList.get(n2);
                    if (e2 instanceof ListItem) {
                        if (n5 == this.listIdx) {
                            listItem = (ListItem)e2;
                            break;
                        }
                        ++n5;
                    } else if (e2 instanceof List) {
                        stack.push(new Object[]{object2, new Integer(n2), new Float(f2)});
                        object2 = (List)e2;
                        arrayList = ((List)object2).getItems();
                        f2 += ((List)object2).getIndentationLeft();
                        n2 = -1;
                        continue;
                    }
                    if (n2 != arrayList.size() - 1 || stack.isEmpty()) continue;
                    Object[] objectArray = (Object[])stack.pop();
                    object2 = (List)objectArray[0];
                    arrayList = ((List)object2).getItems();
                    n2 = (Integer)objectArray[1];
                    f2 = ((Float)objectArray[2]).floatValue();
                }
                n2 = 0;
                for (n = 0; n < 2; ++n) {
                    float f3 = this.yLine;
                    boolean bl5 = false;
                    if (this.compositeColumn == null) {
                        if (listItem == null) {
                            this.listIdx = 0;
                            this.compositeElements.removeFirst();
                            continue block4;
                        }
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender(bl2 ? this.useAscender : false);
                        this.compositeColumn.setAlignment(listItem.getAlignment());
                        this.compositeColumn.setIndent(listItem.getIndentationLeft() + f2 + listItem.getFirstLineIndent());
                        this.compositeColumn.setExtraParagraphSpace(listItem.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(this.compositeColumn.getIndent());
                        this.compositeColumn.setRightIndent(listItem.getIndentationRight() + ((List)object2).getIndentationRight());
                        this.compositeColumn.setLeading(listItem.getLeading(), listItem.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(listItem);
                        if (!bl2) {
                            this.yLine -= listItem.spacingBefore();
                        }
                        bl5 = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    bl3 = listItem.getKeepTogether() && bl5 && !bl2;
                    n2 = this.compositeColumn.go(bl || bl3 && n == 0);
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((n2 & 1) == 0 && bl3) {
                        this.compositeColumn = null;
                        this.yLine = f3;
                        return 2;
                    }
                    if (bl || !bl3) break;
                    if (n != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = f3;
                }
                bl2 = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                if (!Float.isNaN(this.compositeColumn.firstLineY) && !this.compositeColumn.firstLineYDone) {
                    if (!bl) {
                        ColumnText.showTextAligned(this.canvas, 0, new Phrase(listItem.getListSymbol()), this.compositeColumn.leftX + f2, this.compositeColumn.firstLineY, 0.0f);
                    }
                    this.compositeColumn.firstLineYDone = true;
                }
                if ((n2 & 1) != 0) {
                    this.compositeColumn = null;
                    ++this.listIdx;
                    this.yLine -= listItem.spacingAfter();
                }
                if ((n2 & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 23) {
                Object object3;
                float f4;
                int n6;
                float f5;
                if (this.yLine < this.minY || this.yLine > this.maxY) {
                    return 2;
                }
                object2 = (PdfPTable)element;
                if (((PdfPTable)object2).size() <= ((PdfPTable)object2).getHeaderRows()) {
                    this.compositeElements.removeFirst();
                    continue;
                }
                float f6 = this.yLine;
                if (!bl2 && this.listIdx == 0) {
                    f6 -= ((PdfPTable)object2).spacingBefore();
                }
                float f7 = f6;
                if (f6 < this.minY || f6 > this.maxY) {
                    return 2;
                }
                this.currentLeading = 0.0f;
                f2 = this.leftX;
                if (((PdfPTable)object2).isLockedWidth()) {
                    f5 = ((PdfPTable)object2).getTotalWidth();
                    this.updateFilledWidth(f5);
                } else {
                    f5 = this.rectangularWidth * ((PdfPTable)object2).getWidthPercentage() / 100.0f;
                    ((PdfPTable)object2).setTotalWidth(f5);
                }
                n3 = ((PdfPTable)object2).getHeaderRows();
                n2 = ((PdfPTable)object2).getFooterRows();
                if (n2 > n3) {
                    n2 = n3;
                }
                n = n3 - n2;
                float f8 = ((PdfPTable)object2).getHeaderHeight();
                float f9 = ((PdfPTable)object2).getFooterHeight();
                boolean bl6 = bl3 = !bl2 && ((PdfPTable)object2).isSkipFirstHeader() && this.listIdx <= n3;
                if (!bl3 && ((f6 -= f8) < this.minY || f6 > this.maxY)) {
                    if (bl2) {
                        this.compositeElements.removeFirst();
                        continue;
                    }
                    return 2;
                }
                if (this.listIdx < n3) {
                    this.listIdx = n3;
                }
                if (!((PdfPTable)object2).isComplete()) {
                    f6 -= f9;
                }
                for (n6 = this.listIdx; n6 < ((PdfPTable)object2).size() && !(f6 - (f4 = ((PdfPTable)object2).getRowHeight(n6)) < this.minY); ++n6) {
                    f6 -= f4;
                }
                if (!((PdfPTable)object2).isComplete()) {
                    f6 += f9;
                }
                if (n6 < ((PdfPTable)object2).size()) {
                    if (((PdfPTable)object2).isSplitRows() && (!((PdfPTable)object2).isSplitLate() || n6 == this.listIdx && bl2)) {
                        if (!this.splittedRow) {
                            this.splittedRow = true;
                            object2 = new PdfPTable((PdfPTable)object2);
                            this.compositeElements.set(0, object2);
                            ArrayList arrayList = ((PdfPTable)object2).getRows();
                            for (int j = n3; j < this.listIdx; ++j) {
                                arrayList.set(j, null);
                            }
                        }
                        f4 = f6 - this.minY;
                        object3 = ((PdfPTable)object2).getRow(n6).splitRow(f4);
                        if (object3 == null) {
                            if (n6 == this.listIdx) {
                                return 2;
                            }
                        } else {
                            f6 = this.minY;
                            ((PdfPTable)object2).getRows().add(++n6, object3);
                        }
                    } else {
                        if (!((PdfPTable)object2).isSplitRows() && n6 == this.listIdx && bl2) {
                            this.compositeElements.removeFirst();
                            this.splittedRow = false;
                            continue;
                        }
                        if (!(n6 != this.listIdx || bl2 || ((PdfPTable)object2).isSplitRows() && !((PdfPTable)object2).isSplitLate() || ((PdfPTable)object2).getFooterRows() != 0 && !((PdfPTable)object2).isComplete())) {
                            return 2;
                        }
                    }
                }
                bl2 = false;
                if (!bl) {
                    PdfPRow pdfPRow;
                    int n7;
                    switch (((PdfPTable)object2).getHorizontalAlignment()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            f2 += this.rectangularWidth - f5;
                            break;
                        }
                        default: {
                            f2 += (this.rectangularWidth - f5) / 2.0f;
                        }
                    }
                    PdfPTable pdfPTable = PdfPTable.shallowCopy((PdfPTable)object2);
                    object3 = ((PdfPTable)object2).getRows();
                    ArrayList arrayList = pdfPTable.getRows();
                    if (!bl3) {
                        for (n7 = 0; n7 < n; ++n7) {
                            pdfPRow = (PdfPRow)((ArrayList)object3).get(n7);
                            arrayList.add(pdfPRow);
                        }
                    } else {
                        pdfPTable.setHeaderRows(n2);
                    }
                    for (n7 = this.listIdx; n7 < n6; ++n7) {
                        arrayList.add(((ArrayList)object3).get(n7));
                    }
                    if (n6 < ((PdfPTable)object2).size()) {
                        pdfPTable.setComplete(true);
                    }
                    for (n7 = 0; n7 < n2 && pdfPTable.isComplete(); ++n7) {
                        arrayList.add(((ArrayList)object3).get(n7 + n));
                    }
                    float f10 = 0.0f;
                    if (((PdfPTable)object2).isExtendLastRow()) {
                        pdfPRow = (PdfPRow)arrayList.get(arrayList.size() - 1 - n2);
                        f10 = pdfPRow.getMaxHeights();
                        pdfPRow.setMaxHeights(f6 - this.minY + f10);
                        f6 = this.minY;
                    }
                    if (this.canvases != null) {
                        pdfPTable.writeSelectedRows(0, -1, f2, f7, this.canvases);
                    } else {
                        pdfPTable.writeSelectedRows(0, -1, f2, f7, this.canvas);
                    }
                    if (((PdfPTable)object2).isExtendLastRow()) {
                        pdfPRow = (PdfPRow)arrayList.get(arrayList.size() - 1 - n2);
                        pdfPRow.setMaxHeights(f10);
                    }
                } else if (((PdfPTable)object2).isExtendLastRow() && this.minY > -1.0737418E9f) {
                    f6 = this.minY;
                }
                this.yLine = f6;
                if (!bl3 && !((PdfPTable)object2).isComplete()) {
                    this.yLine += f9;
                }
                if (n6 >= ((PdfPTable)object2).size()) {
                    this.yLine -= ((PdfPTable)object2).spacingAfter();
                    this.compositeElements.removeFirst();
                    this.splittedRow = false;
                    this.listIdx = 0;
                    continue;
                }
                if (this.splittedRow) {
                    ArrayList arrayList = ((PdfPTable)object2).getRows();
                    for (int j = this.listIdx; j < n6; ++j) {
                        arrayList.set(j, null);
                    }
                }
                this.listIdx = n6;
                return 2;
            }
            if (element.type() == 55) {
                if (!bl) {
                    object2 = (DrawInterface)((Object)element);
                    object2.draw(this.canvas, this.leftX, this.minY, this.rightX, this.maxY, this.yLine);
                }
                this.compositeElements.removeFirst();
                continue;
            }
            this.compositeElements.removeFirst();
        }
        return 1;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
        this.canvases = null;
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvas(pdfContentByte);
        }
    }

    public void setCanvases(PdfContentByte[] pdfContentByteArray) {
        this.canvases = pdfContentByteArray;
        this.canvas = pdfContentByteArray[3];
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvases(pdfContentByteArray);
        }
    }

    public PdfContentByte[] getCanvases() {
        return this.canvases;
    }

    public boolean zeroHeightElement() {
        return this.composite && !this.compositeElements.isEmpty() && ((Element)this.compositeElements.getFirst()).type() == 55;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean bl) {
        this.useAscender = bl;
    }

    public static boolean hasMoreText(int n) {
        return (n & 1) == 0;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float f2) {
        this.filledWidth = f2;
    }

    public void updateFilledWidth(float f2) {
        if (f2 > this.filledWidth) {
            this.filledWidth = f2;
        }
    }

    public boolean isAdjustFirstLine() {
        return this.adjustFirstLine;
    }

    public void setAdjustFirstLine(boolean bl) {
        this.adjustFirstLine = bl;
    }
}

