/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.CachedPreparedStatement;
import org.jboss.resource.adapter.jdbc.PreparedStatementCache;
import org.jboss.resource.adapter.jdbc.WrappedConnection;

public abstract class BaseWrapperManagedConnection
implements ManagedConnection {
    protected final BaseWrapperManagedConnectionFactory mcf;
    protected final Connection con;
    protected final Properties props;
    private final int transactionIsolation;
    private final boolean readOnly;
    private final Collection cels = new ArrayList();
    private final Set handles = new HashSet();
    private PreparedStatementCache psCache = null;
    protected Object stateLock = new Object();
    protected boolean inManagedTransaction = false;
    protected boolean jdbcAutoCommit = true;
    protected boolean underlyingAutoCommit = true;
    protected boolean jdbcReadOnly;
    protected boolean underlyingReadOnly;
    protected int jdbcTransactionIsolation;
    protected boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseWrapperManagedConnection(BaseWrapperManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        this.mcf = mcf;
        this.con = con;
        this.props = props;
        if (psCacheSize > 0) {
            this.psCache = new PreparedStatementCache(psCacheSize);
        }
        if (transactionIsolation == -1) {
            this.transactionIsolation = con.getTransactionIsolation();
        } else {
            this.transactionIsolation = transactionIsolation;
            con.setTransactionIsolation(transactionIsolation);
        }
        this.readOnly = con.isReadOnly();
        if (mcf.getNewConnectionSQL() != null) {
            Statement s = con.createStatement();
            try {
                s.execute(mcf.getNewConnectionSQL());
            }
            finally {
                s.close();
            }
        }
        this.underlyingReadOnly = this.readOnly;
        this.jdbcReadOnly = this.readOnly;
        this.jdbcTransactionIsolation = this.transactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.add(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.remove(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new JBossResourceException("Wrong kind of connection handle to associate" + handle);
        }
        ((WrappedConnection)handle).setManagedConnection(this);
        Set set = this.handles;
        synchronized (set) {
            this.handles.add(handle);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        Object object = this.handles;
        synchronized (object) {
            Iterator i = this.handles.iterator();
            while (i.hasNext()) {
                WrappedConnection lc = (WrappedConnection)i.next();
                lc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        object = this.stateLock;
        synchronized (object) {
            this.jdbcAutoCommit = true;
            this.jdbcReadOnly = this.readOnly;
            if (this.jdbcTransactionIsolation != this.transactionIsolation) {
                try {
                    this.con.setTransactionIsolation(this.jdbcTransactionIsolation);
                    this.jdbcTransactionIsolation = this.transactionIsolation;
                }
                catch (SQLException e) {
                    this.mcf.log.warn((Object)"Error resetting transaction isolation ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.checkIdentity(subject, cri);
        WrappedConnection lc = new WrappedConnection(this);
        Set set = this.handles;
        synchronized (set) {
            this.handles.add(lc);
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        Object object = this.stateLock;
        synchronized (object) {
            this.destroyed = true;
        }
        this.cleanup();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public boolean checkValid() {
        SQLException e = this.mcf.isValidConnection(this.con);
        if (e == null) {
            return true;
        }
        this.mcf.log.warn((Object)"Destroying connection that is not valid, due to the following exception:", (Throwable)e);
        this.broadcastConnectionError(e);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandle(WrappedConnection handle) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
        }
        object = this.handles;
        synchronized (object) {
            this.handles.remove(handle);
        }
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
        ce.setConnectionHandle((Object)handle);
        ArrayList copy = null;
        Collection collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList(this.cels);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cel = (ConnectionEventListener)i.next();
            cel.connectionClosed(ce);
        }
    }

    void connectionError(SQLException e) {
        if (this.mcf.isExceptionFatal(e)) {
            this.broadcastConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastConnectionError(SQLException e) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, (Exception)e);
        ArrayList copy = null;
        Collection collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList(this.cels);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cel = (ConnectionEventListener)i.next();
            cel.connectionErrorOccurred(ce);
        }
    }

    Connection getConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException("Connection has been destroyed!!!");
        }
        return this.con;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.psCache == null) return this.con.prepareStatement(sql);
        CachedPreparedStatement cachedps = (CachedPreparedStatement)this.psCache.get(sql);
        if (cachedps != null) {
            if (!this.canUse(cachedps)) return this.con.prepareStatement(sql);
            cachedps.inUse();
            return cachedps;
        } else {
            PreparedStatement ps = this.con.prepareStatement(sql);
            cachedps = new CachedPreparedStatement(ps);
            this.psCache.insert(sql, cachedps);
        }
        return cachedps;
    }

    boolean canUse(CachedPreparedStatement cachedps) {
        if (!cachedps.isInUse()) {
            return true;
        }
        if (this.underlyingAutoCommit) {
            return false;
        }
        return this.mcf.sharePS;
    }

    protected Logger getLog() {
        return this.mcf.log;
    }

    private void checkIdentity(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.mcf.getConnectionProperties(subject, cri);
        if (!this.props.equals(newProps)) {
            throw new JBossResourceException("Wrong credentials passed to getConnection!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTransaction() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                return;
            }
            if (this.jdbcAutoCommit != this.underlyingAutoCommit) {
                this.con.setAutoCommit(this.jdbcAutoCommit);
                this.underlyingAutoCommit = this.jdbcAutoCommit;
            }
        }
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.jdbcReadOnly != this.underlyingReadOnly) {
                this.con.setReadOnly(this.jdbcReadOnly);
                this.underlyingReadOnly = this.jdbcReadOnly;
            }
        }
    }

    boolean isJdbcAutoCommit() {
        return this.inManagedTransaction ? false : this.jdbcAutoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcAutoCommit(boolean jdbcAutoCommit) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot set autocommit during a managed transaction!");
            }
            this.jdbcAutoCommit = jdbcAutoCommit;
        }
    }

    boolean isJdbcReadOnly() {
        return this.jdbcReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcReadOnly(boolean readOnly) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot set read only during a managed transaction!");
            }
            this.jdbcReadOnly = readOnly;
        }
    }

    int getJdbcTransactionIsolation() {
        return this.jdbcTransactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcTransactionIsolation(int isolationLevel) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.jdbcTransactionIsolation = isolationLevel;
            this.con.setTransactionIsolation(this.jdbcTransactionIsolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcCommit() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot commit during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot commit with autocommit set!");
            }
        }
        this.con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback(Savepoint savepoint) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback(savepoint);
    }

    int getTrackStatements() {
        return this.mcf.trackStatements;
    }

    protected void checkException(SQLException e) throws ResourceException {
        this.connectionError(e);
        throw new JBossResourceException("SQLException", (Throwable)e);
    }
}

