/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private Vector points;
    private int precision;

    public XYSplineRenderer() {
        this(5);
    }

    public XYSplineRenderer(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p2) {
        if (p2 <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p2;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYLineAndShapeRenderer.State state = (XYLineAndShapeRenderer.State)super.initialise(g2, dataArea, plot, data, info);
        state.setProcessVisibleItemsOnly(false);
        this.points = new Vector();
        this.setDrawSeriesLineAsPath(true);
        return state;
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        ControlPoint p2;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!(Double.isNaN(transX1) || Double.isNaN(transY1) || this.points.contains(p2 = new ControlPoint(plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transY1 : (float)transX1, plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transX1 : (float)transY1)))) {
            this.points.add(p2);
        }
        if (item == dataset.getItemCount(series) - 1) {
            XYLineAndShapeRenderer.State s2 = (XYLineAndShapeRenderer.State)state;
            if (this.points.size() > 1) {
                ControlPoint cp0 = (ControlPoint)this.points.get(0);
                s2.seriesPath.moveTo(cp0.x, cp0.y);
                if (this.points.size() == 2) {
                    ControlPoint cp1 = (ControlPoint)this.points.get(1);
                    s2.seriesPath.lineTo(cp1.x, cp1.y);
                } else {
                    int i2;
                    int i3;
                    int np = this.points.size();
                    float[] d2 = new float[np];
                    float[] x = new float[np];
                    float oldy = 0.0f;
                    float oldt = 0.0f;
                    float[] a2 = new float[np];
                    float[] h7 = new float[np];
                    for (i3 = 0; i3 < np; ++i3) {
                        ControlPoint cpi = (ControlPoint)this.points.get(i3);
                        x[i3] = cpi.x;
                        d2[i3] = cpi.y;
                    }
                    for (i3 = 1; i3 <= np - 1; ++i3) {
                        h7[i3] = x[i3] - x[i3 - 1];
                    }
                    float[] sub2 = new float[np - 1];
                    float[] diag = new float[np - 1];
                    float[] sup2 = new float[np - 1];
                    for (i2 = 1; i2 <= np - 2; ++i2) {
                        diag[i2] = (h7[i2] + h7[i2 + 1]) / 3.0f;
                        sup2[i2] = h7[i2 + 1] / 6.0f;
                        sub2[i2] = h7[i2] / 6.0f;
                        a2[i2] = (d2[i2 + 1] - d2[i2]) / h7[i2 + 1] - (d2[i2] - d2[i2 - 1]) / h7[i2];
                    }
                    this.solveTridiag(sub2, diag, sup2, a2, np - 2);
                    oldt = x[0];
                    oldy = d2[0];
                    s2.seriesPath.moveTo(oldt, oldy);
                    for (i2 = 1; i2 <= np - 1; ++i2) {
                        for (int j = 1; j <= this.precision; ++j) {
                            float t1 = h7[i2] * (float)j / (float)this.precision;
                            float t2 = h7[i2] - t1;
                            float y = ((-a2[i2 - 1] / 6.0f * (t2 + h7[i2]) * t1 + d2[i2 - 1]) * t2 + (-a2[i2] / 6.0f * (t1 + h7[i2]) * t2 + d2[i2]) * t1) / h7[i2];
                            float t = x[i2 - 1] + t1;
                            s2.seriesPath.lineTo(t, y);
                            oldt = t;
                            oldy = y;
                        }
                    }
                }
                this.drawFirstPassShape(g2, pass, series, item, s2.seriesPath);
            }
            this.points = new Vector();
        }
    }

    private void solveTridiag(float[] sub2, float[] diag, float[] sup2, float[] b2, int n) {
        int i2;
        for (i2 = 2; i2 <= n; ++i2) {
            sub2[i2] = sub2[i2] / diag[i2 - 1];
            diag[i2] = diag[i2] - sub2[i2] * sup2[i2 - 1];
            b2[i2] = b2[i2] - sub2[i2] * b2[i2 - 1];
        }
        b2[n] = b2[n] / diag[n];
        for (i2 = n - 1; i2 >= 1; --i2) {
            b2[i2] = (b2[i2] - sup2[i2] * b2[i2 + 1]) / diag[i2];
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer that = (XYSplineRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        return super.equals(obj);
    }

    class ControlPoint {
        public float x;
        public float y;

        public ControlPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ControlPoint)) {
                return false;
            }
            ControlPoint that = (ControlPoint)obj;
            return this.x == that.x;
        }
    }
}

