/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    public MethodBinding tiebreakMethod;
    public boolean isUnchecked;

    public static MethodBinding computeCompatibleMethod(MethodBinding originalMethod, TypeBinding[] arguments, Scope scope, InvocationSite invocationSite) {
        ParameterizedGenericMethodBinding methodSubstitute;
        TypeVariableBinding[] typeVariables = originalMethod.typeVariables;
        TypeBinding[] substitutes = invocationSite.genericTypeArguments();
        if (substitutes != null) {
            if (substitutes.length != typeVariables.length) {
                return new ProblemMethodBinding(originalMethod, originalMethod.selector, substitutes, 11);
            }
            methodSubstitute = new ParameterizedGenericMethodBinding(originalMethod, substitutes, scope.environment());
        } else {
            TypeBinding[] parameters = originalMethod.parameters;
            int varLength = typeVariables.length;
            HashMap<TypeVariableBinding, TypeBinding[][]> collectedSubstitutes = new HashMap<TypeVariableBinding, TypeBinding[][]>(varLength);
            int i2 = 0;
            while (i2 < varLength) {
                collectedSubstitutes.put(typeVariables[i2], new TypeBinding[3][]);
                ++i2;
            }
            substitutes = new TypeBinding[varLength];
            methodSubstitute = ParameterizedGenericMethodBinding.inferFromArgumentTypes(scope, originalMethod, arguments, parameters, collectedSubstitutes, substitutes);
            if (methodSubstitute == null) {
                return null;
            }
            if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
                TypeBinding expectedType = null;
                if (methodSubstitute.returnType != VoidBinding) {
                    if (invocationSite instanceof MessageSend) {
                        MessageSend message = (MessageSend)invocationSite;
                        expectedType = message.expectedType;
                    }
                    if (expectedType == null) {
                        expectedType = scope.getJavaLangObject();
                    }
                }
                if ((methodSubstitute = methodSubstitute.inferFromExpectedType(scope, expectedType, collectedSubstitutes, substitutes)) == null) {
                    return null;
                }
            }
        }
        if (!methodSubstitute.isRaw) {
            int i3 = 0;
            int length = typeVariables.length;
            while (i3 < length) {
                TypeVariableBinding typeVariable = typeVariables[i3];
                TypeBinding substitute = methodSubstitute.typeArguments[i3];
                switch (typeVariable.boundCheck(methodSubstitute, substitute)) {
                    case 2: {
                        int argLength = arguments.length;
                        TypeBinding[] augmentedArguments = new TypeBinding[argLength + 2];
                        System.arraycopy(arguments, 0, augmentedArguments, 0, argLength);
                        augmentedArguments[argLength] = substitute;
                        augmentedArguments[argLength + 1] = typeVariable;
                        return new ProblemMethodBinding(methodSubstitute, originalMethod.selector, augmentedArguments, 10);
                    }
                    case 1: {
                        methodSubstitute.isUnchecked = true;
                    }
                }
                ++i3;
            }
        }
        return methodSubstitute;
    }

    private static boolean hasUnresolvedTypeArgument(TypeBinding[] substitutes) {
        int i2 = 0;
        int varLength = substitutes.length;
        while (i2 < varLength) {
            if (substitutes[i2] == null) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static ParameterizedGenericMethodBinding inferFromArgumentTypes(Scope scope, MethodBinding originalMethod, TypeBinding[] arguments, TypeBinding[] parameters, Map collectedSubstitutes, TypeBinding[] substitutes) {
        block15: {
            block14: {
                block17: {
                    block16: {
                        if (!originalMethod.isVarargs()) break block14;
                        paramLength = parameters.length;
                        minArgLength = paramLength - 1;
                        argLength = arguments.length;
                        i = 0;
                        while (i < minArgLength) {
                            parameters[i].collectSubstitutes(scope, arguments[i], collectedSubstitutes, 1);
                            ++i;
                        }
                        if (minArgLength >= argLength) break block15;
                        varargType = parameters[minArgLength];
                        lastArgument = arguments[minArgLength];
                        if (paramLength != argLength) break block16;
                        if (lastArgument == ParameterizedGenericMethodBinding.NullBinding) break block17;
                        switch (lastArgument.dimensions()) {
                            case 0: {
                                ** break;
                            }
                            case 1: {
                                if (lastArgument.leafComponentType().isBaseType()) ** break;
                                break block17;
                            }
                            default: {
                                break block17;
                            }
                        }
                    }
                    varargType = ((ArrayBinding)varargType).elementsType();
                }
                i = minArgLength;
                while (i < argLength) {
                    varargType.collectSubstitutes(scope, arguments[i], collectedSubstitutes, 1);
                    ++i;
                }
                break block15;
            }
            paramLength = parameters.length;
            i = 0;
            while (i < paramLength) {
                parameters[i].collectSubstitutes(scope, arguments[i], collectedSubstitutes, 1);
                ++i;
            }
        }
        originalVariables = originalMethod.typeVariables;
        varLength = originalVariables.length;
        if ((substitutes = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, originalVariables, substitutes, false, collectedSubstitutes)) == null) {
            return null;
        }
        if (substitutes.length == 0) {
            return new ParameterizedGenericMethodBinding(originalMethod, null, scope.environment());
        }
        resolvedSubstitutes = substitutes;
        i = 0;
        while (i < varLength) {
            if (substitutes[i] == null) {
                if (resolvedSubstitutes == substitutes) {
                    resolvedSubstitutes = new TypeBinding[varLength];
                    System.arraycopy(substitutes, 0, resolvedSubstitutes, 0, i);
                }
                resolvedSubstitutes[i] = originalVariables[i];
            } else if (resolvedSubstitutes != substitutes) {
                resolvedSubstitutes[i] = substitutes[i];
            }
            ++i;
        }
        return new ParameterizedGenericMethodBinding(originalMethod, resolvedSubstitutes, scope.environment());
    }

    private static TypeBinding[] resolveSubstituteConstraints(Scope scope, TypeVariableBinding[] typeVariables, TypeBinding[] substitutes, boolean considerEXTENDSConstraints, Map collectedSubstitutes) {
        TypeBinding[] bounds;
        TypeBinding[][] variableSubstitutes;
        TypeBinding substitute;
        TypeVariableBinding current;
        if (collectedSubstitutes.isEmpty()) {
            return NoTypes;
        }
        int varLength = typeVariables.length;
        int i2 = 0;
        while (i2 < varLength) {
            TypeBinding[] equalSubstitutes;
            current = typeVariables[i2];
            substitute = substitutes[i2];
            if (substitute == null && (equalSubstitutes = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[0]) != null) {
                int j = 0;
                int equalLength = equalSubstitutes.length;
                block1: while (j < equalLength) {
                    TypeBinding equalSubstitute = equalSubstitutes[j];
                    if (equalSubstitute != null) {
                        if (equalSubstitute == current) {
                            int k = j + 1;
                            while (k < equalLength) {
                                equalSubstitute = equalSubstitutes[k];
                                if (equalSubstitute != current && equalSubstitute != null) {
                                    substitutes[i2] = equalSubstitute;
                                    break block1;
                                }
                                ++k;
                            }
                            substitutes[i2] = current;
                            break;
                        }
                        substitutes[i2] = equalSubstitute;
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
            i2 = 0;
            while (i2 < varLength) {
                current = typeVariables[i2];
                substitute = substitutes[i2];
                if (substitute == null && (bounds = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[2]) != null) {
                    TypeBinding mostSpecificSubstitute = scope.lowerUpperBound(bounds);
                    if (mostSpecificSubstitute == null) {
                        return null;
                    }
                    if (mostSpecificSubstitute != VoidBinding) {
                        substitutes[i2] = mostSpecificSubstitute;
                    }
                }
                ++i2;
            }
        }
        if (considerEXTENDSConstraints && ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
            i2 = 0;
            while (i2 < varLength) {
                current = typeVariables[i2];
                substitute = substitutes[i2];
                if (substitute == null && (bounds = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[1]) != null) {
                    TypeBinding[] glb = Scope.greaterLowerBound(bounds);
                    TypeBinding mostSpecificSubstitute = null;
                    if (glb != null) {
                        mostSpecificSubstitute = glb[0];
                    }
                    if (mostSpecificSubstitute != null) {
                        substitutes[i2] = mostSpecificSubstitute;
                    }
                }
                ++i2;
            }
        }
        return substitutes;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, RawTypeBinding rawType, LookupEnvironment environment) {
        TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        int length = originalVariables.length;
        TypeBinding[] rawArguments = new TypeBinding[length];
        int i2 = 0;
        while (i2 < length) {
            rawArguments[i2] = environment.convertToRawType(originalVariables[i2].erasure());
            ++i2;
        }
        this.isRaw = true;
        this.isUnchecked = false;
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = rawType == null ? originalMethod.declaringClass : rawType;
        this.typeVariables = NoTypeVariables;
        this.typeArguments = rawArguments;
        this.originalMethod = originalMethod;
        boolean ignoreRawTypeSubstitution = rawType == null || originalMethod.isStatic();
        this.parameters = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.parameters : Scope.substitute((Substitution)rawType, originalMethod.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.thrownExceptions : Scope.substitute((Substitution)rawType, originalMethod.thrownExceptions));
        this.returnType = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.returnType : Scope.substitute((Substitution)rawType, originalMethod.returnType));
        this.wasInferred = false;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, TypeBinding[] typeArguments, LookupEnvironment environment) {
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = originalMethod.declaringClass;
        this.typeVariables = NoTypeVariables;
        this.typeArguments = typeArguments;
        this.isRaw = false;
        this.isUnchecked = false;
        this.originalMethod = originalMethod;
        this.parameters = Scope.substitute((Substitution)this, originalMethod.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, originalMethod.thrownExceptions);
        this.returnType = Scope.substitute((Substitution)this, originalMethod.returnType);
        this.wasInferred = true;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.originalMethod.computeUniqueKey(false));
        buffer.append('%');
        buffer.append('<');
        if (!this.isRaw) {
            int length = this.typeArguments.length;
            int i2 = 0;
            while (i2 < length) {
                TypeBinding typeArgument = this.typeArguments[i2];
                buffer.append(typeArgument.computeUniqueKey(false));
                ++i2;
            }
        }
        buffer.append('>');
        int resultLength = buffer.length();
        char[] result = new char[resultLength];
        buffer.getChars(0, resultLength, result, 0);
        return result;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    private ParameterizedGenericMethodBinding inferFromExpectedType(Scope scope, TypeBinding expectedType, Map collectedSubstitutes, TypeBinding[] substitutes) {
        TypeVariableBinding[] originalVariables = this.originalMethod.typeVariables;
        int varLength = originalVariables.length;
        if (expectedType != null) {
            this.returnType.collectSubstitutes(scope, expectedType, collectedSubstitutes, 2);
        }
        int i2 = 0;
        while (i2 < varLength) {
            boolean argAlreadyInferred;
            TypeBinding argument = this.typeArguments[i2];
            TypeVariableBinding originalVariable = originalVariables[i2];
            boolean bl = argAlreadyInferred = argument != originalVariable;
            if (originalVariable.firstBound == originalVariable.superclass) {
                TypeBinding substitutedBound = Scope.substitute((Substitution)this, originalVariable.superclass);
                argument.collectSubstitutes(scope, substitutedBound, collectedSubstitutes, 2);
                if (argAlreadyInferred) {
                    substitutedBound.collectSubstitutes(scope, argument, collectedSubstitutes, 1);
                }
            }
            int j = 0;
            int max = originalVariable.superInterfaces.length;
            while (j < max) {
                TypeBinding substitutedBound = Scope.substitute((Substitution)this, originalVariable.superInterfaces[j]);
                argument.collectSubstitutes(scope, substitutedBound, collectedSubstitutes, 2);
                if (argAlreadyInferred) {
                    substitutedBound.collectSubstitutes(scope, argument, collectedSubstitutes, 1);
                }
                ++j;
            }
            ++i2;
        }
        if ((substitutes = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, originalVariables, substitutes, true, collectedSubstitutes)) == null) {
            return null;
        }
        if (substitutes.length == 0) {
            this.isRaw = true;
            this.isUnchecked = false;
            i2 = 0;
            while (i2 < varLength) {
                this.typeArguments[i2] = originalVariables[i2].upperBound();
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < varLength) {
                TypeBinding substitute = substitutes[i2];
                this.typeArguments[i2] = substitute != null ? substitutes[i2] : originalVariables[i2].upperBound();
                ++i2;
            }
        }
        TypeBinding oldReturnType = this.returnType;
        this.returnType = Scope.substitute((Substitution)this, this.returnType);
        this.inferredReturnType = this.returnType != oldReturnType;
        this.parameters = Scope.substitute((Substitution)this, this.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
        return this;
    }

    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    public TypeBinding substitute(TypeVariableBinding originalVariable) {
        TypeVariableBinding[] variables = this.originalMethod.typeVariables;
        int length = variables.length;
        if (originalVariable.rank < length && variables[originalVariable.rank] == originalVariable) {
            return this.typeArguments[originalVariable.rank];
        }
        if (!this.isStatic() && this.declaringClass instanceof Substitution) {
            return ((Substitution)((Object)this.declaringClass)).substitute(originalVariable);
        }
        return originalVariable;
    }

    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            this.tiebreakMethod = this.isRaw ? this : new ParameterizedGenericMethodBinding(this.originalMethod, null, this.environment);
        }
        return this.tiebreakMethod;
    }
}

