/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding returnTypeBinding;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.declaringClass.isLocalType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(initializationContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.arguments != null) {
                int i2 = 0;
                int count = this.arguments.length;
                while (i2 < count) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i2].binding);
                    ++i2;
                }
            }
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int i3 = 0;
                int count = this.statements.length;
                while (i3 < count) {
                    Statement stat = this.statements[i3];
                    if (!stat.complainIfUnreachable(flowInfo, this.scope, didAlreadyComplain)) {
                        flowInfo = stat.analyseCode(this.scope, methodContext, flowInfo);
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i3;
                }
            }
            if ((returnTypeBinding = this.binding.returnType) == VoidBinding || this.isAbstract()) {
                this.needFreeReturn = flowInfo.isReachable();
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(returnTypeBinding, this);
            }
            methodContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean isMethod() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, unit);
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        if (this.returnType == null) {
            return output;
        }
        return this.returnType.printExpression(0, output).append(' ');
    }

    public void resolveStatements() {
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        if (this.typeParameters != null) {
            int i2 = 0;
            int length = this.typeParameters.length;
            while (i2 < length) {
                this.typeParameters[i2].resolve(this.scope);
                ++i2;
            }
        }
        if (this.binding != null && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
            int bindingModifiers = this.binding.modifiers;
            boolean hasOverrideAnnotation = (this.binding.tagBits & 0x1000000000000L) != 0L;
            boolean isInterfaceMethod = this.binding.declaringClass.isInterface();
            if (hasOverrideAnnotation) {
                if ((bindingModifiers & 0x10000000) == 0 || isInterfaceMethod) {
                    this.scope.problemReporter().methodMustOverride(this);
                }
            } else if (!isInterfaceMethod && (bindingModifiers & 0x10000008) == 0x10000000) {
                this.scope.problemReporter().missingOverrideAnnotation(this);
            }
        }
        switch (this.scope.referenceType().kind()) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) == 0 && (this.modifiers & 0x400) == 0) break;
                this.scope.problemReporter().methodNeedingNoBody(this);
            }
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i2;
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                i2 = 0;
                while (i2 < annotationsLength) {
                    this.annotations[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                i2 = 0;
                while (i2 < typeParametersLength) {
                    this.typeParameters[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(visitor, this.scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i2 = 0;
                while (i2 < argumentLength) {
                    this.arguments[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i2 = 0;
                while (i2 < thrownExceptionsLength) {
                    this.thrownExceptions[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i2 = 0;
                while (i2 < statementsLength) {
                    this.statements[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

