/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int explicitDeclarations) {
        this.explicitDeclarations = explicitDeclarations;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean didAlreadyComplain = false;
        int i2 = 0;
        int max = this.statements.length;
        while (i2 < max) {
            Statement stat = this.statements[i2];
            if (!stat.complainIfUnreachable(flowInfo, this.scope, didAlreadyComplain)) {
                flowInfo = stat.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                didAlreadyComplain = true;
            }
            ++i2;
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.statements != null) {
            int i2 = 0;
            int max = this.statements.length;
            while (i2 < max) {
                this.statements[i2].generateCode(this.scope, codeStream);
                ++i2;
            }
        }
        if (this.scope != currentScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.statements == null) {
            return output;
        }
        int i2 = 0;
        while (i2 < this.statements.length) {
            this.statements[i2].printStatement(indent + 1, output);
            output.append('\n');
            ++i2;
        }
        return output;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        Block.printIndent(indent, output);
        output.append("{\n");
        this.printBody(indent, output);
        return Block.printIndent(indent, output).append('}');
    }

    public void resolve(BlockScope upperScope) {
        if ((this.bits & 8) != 0) {
            upperScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope, this.explicitDeclarations);
            int i2 = 0;
            int length = this.statements.length;
            while (i2 < length) {
                this.statements[i2].resolve(this.scope);
                ++i2;
            }
        }
    }

    public void resolveUsing(BlockScope givenScope) {
        if ((this.bits & 8) != 0) {
            givenScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = givenScope;
        if (this.statements != null) {
            int i2 = 0;
            int length = this.statements.length;
            while (i2 < length) {
                this.statements[i2].resolve(this.scope);
                ++i2;
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.statements != null) {
            int i2 = 0;
            int length = this.statements.length;
            while (i2 < length) {
                this.statements[i2].traverse(visitor, this.scope);
                ++i2;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label2) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(label2);
        }
    }
}

