/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class StringUtil {
    private static final String ENCODING = "ISO-8859-1";

    private StringUtil() {
    }

    public static String getFromUnicodeLE(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length " + len);
        }
        try {
            return new String(string, offset, len * 2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeLE(byte[] string) {
        if (string.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeLE(string, 0, string.length / 2);
    }

    public static String getFromUnicodeBE(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length");
        }
        try {
            return new String(string, offset, len * 2, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeBE(byte[] string) {
        if (string.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeBE(string, 0, string.length / 2);
    }

    public static String getFromCompressedUnicode(byte[] string, int offset, int len) {
        try {
            int len_to_use = Math.min(len, string.length - offset);
            return new String(string, offset, len_to_use, ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static void putCompressedUnicode(String input2, byte[] output, int offset) {
        try {
            byte[] bytes = input2.getBytes(ENCODING);
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static void putUnicodeLE(String input2, byte[] output, int offset) {
        try {
            byte[] bytes = input2.getBytes("UTF-16LE");
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static void putUnicodeBE(String input2, byte[] output, int offset) {
        try {
            byte[] bytes = input2.getBytes("UTF-16BE");
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError();
        }
    }

    public static String format(String message, Object[] params) {
        int currentParamNumber = 0;
        StringBuffer formattedMessage = new StringBuffer();
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (message.charAt(i2) == '%') {
                if (currentParamNumber >= params.length) {
                    formattedMessage.append("?missing data?");
                    continue;
                }
                if (params[currentParamNumber] instanceof Number && i2 + 1 < message.length()) {
                    i2 += StringUtil.matchOptionalFormatting((Number)params[currentParamNumber++], message.substring(i2 + 1), formattedMessage);
                    continue;
                }
                formattedMessage.append(params[currentParamNumber++].toString());
                continue;
            }
            if (message.charAt(i2) == '\\' && i2 + 1 < message.length() && message.charAt(i2 + 1) == '%') {
                formattedMessage.append('%');
                ++i2;
                continue;
            }
            formattedMessage.append(message.charAt(i2));
        }
        return formattedMessage.toString();
    }

    private static int matchOptionalFormatting(Number number, String formatting, StringBuffer outputTo) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < formatting.length() && Character.isDigit(formatting.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(formatting.charAt(0) + ""));
            if (2 < formatting.length() && formatting.charAt(1) == '.' && Character.isDigit(formatting.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(2) + ""));
                numberFormat.format(number, outputTo, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 1;
        }
        if (0 < formatting.length() && formatting.charAt(0) == '.' && 1 < formatting.length() && Character.isDigit(formatting.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(1) + ""));
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, outputTo, new FieldPosition(0));
        return 1;
    }

    public static String getPreferredEncoding() {
        return ENCODING;
    }

    public static boolean hasMultibyte(String value) {
        if (value == null) {
            return false;
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean isUnicodeString(String value) {
        try {
            return !value.equals(new String(value.getBytes(ENCODING), ENCODING));
        }
        catch (UnsupportedEncodingException e2) {
            return true;
        }
    }
}

